DESHAW_PERMISSIONS_DOCUMENTATION_URL = "https://go/confluence/permissions";

(function ($) {

	// If hide is true, hide the receiver, otherwise show it
	$.fn.hideIf = function(hide) {
        return this.showIf(!hide);
	};

	// If show is true, show the receiver, otherwise hide it
	$.fn.showIf = function(show) {
        return this.each(function() {
			if (show) $(this).show();
			else $(this).hide();
        });
	};

	EffectivePermissions.Restrictions = function () {
		this.initializing = false;
		this.dialog = $("#update-page-restrictions-dialog");
		this.initialize();
	};
	
	var prototype = EffectivePermissions.Restrictions.prototype;

	prototype.addInheritedEditRestrictionWarning = function (result) {

		// Warning user when restrictions are not inherited
		if (result.success && !result.hasInheritedEditPermissions && !result.parentCannotPropagate) {
			var $messageArea = $("<div>").attr("id", "not-inheriting-permissions-messages");
			$(".page-restrictions-dialog-entities-container", this.dialog).prepend($messageArea);
			AJS.messages.info($messageArea, {
			    body: "<p>This page is not inheriting edit permissions from the parent page and has its own permissions defined.</p><p>To clear this page's permissions and re-enable inheritance, select <em>No restrictions</em>.</p>"
			});
		}
		
		this.dialog.addClass("inherited-permissions-checked");
	};
	
	prototype.addWarnings = function () {
		// Warning user if edit restrictions won't propagate
		if (!EffectivePermissions.parentPageId) {
			var $messageArea = $("<div>").attr("id", "effective-permissions-messages");
			$(".page-restrictions-dialog-top", this.dialog).after($messageArea);
			AJS.messages.info($messageArea, {
			    // title: "Edit restrictions won't affect child pages."//,
			    body: "<p>This is a home or root page: edit restrictions don't affect child pages.</p>"
			});
		}
	};
	
	prototype.adjustToggler = function () {
		if (this.isViewingEffectivePermissions()) this.toggler.removeClass("viewing-effective-permissions").text("View Effective Permissions");
		else this.toggler.addClass("viewing-effective-permissions").text("Edit Page Restrictions");
	};

	prototype.dialogTopText = function () {
		return $(".page-restrictions-dialog-top-text", this.dialog);
	};
	
	prototype.forPageId = function () {
		// If we have a 0 page id, we're creating a new page, so grab the parent id to calculate effective permissions
		return EffectivePermissions.pageId > 0 ? EffectivePermissions.pageId : EffectivePermissions.parentPageId;
	};
	
	prototype.groupMemberRows = function (groupName) {
		return $("tr[data-group-name='" + groupName + "']");
	};
	
	// prototype.hideEverybodyRow = function () {
	// 	$(".restrictions-dialog-table .everybody-row").hide();
	// };
	
	prototype.initialize = function (callback) {
		var self = this;
		if (!self.dialog.length || self.dialog.hasClass("effective-permissions-enabled")) return;
		else self.dialog.addClass("effective-permissions-enabled");
		
		self.addWarnings();
		
		// self.hideEverybodyRow();
		
		// Add the toggler
		self.toggler = $("<a>").addClass("aui-link effective-permissions-toggler").text("View Effective Permissions");
		self.dialogTopText().empty().append(self.toggler);
		self.toggler.click(function (e) { self.toggleEffectivePermissionsView(e) });
		
		// Add the effective permissions loader panel (loading is deferred until the user clicks the toggler)
		self.panel = $(".effective-permissions-panel");
		if (!self.panel.length) {
			self.panel = $("<div>").addClass("effective-permissions-panel");
			$(".page-restrictions-dialog-top").parent().append(self.panel);
			self.panel.on("click", ".group-members-toggler", function (e) { self.toggleGroupMembers(e, this); });
		}
		self.loader = $("<div>").addClass("loader").text("Calculating effective permissions...");
		self.panel.hide().empty().append(self.loader);
		self.loader.spin();
		
		// Add the effective permissions title
		var $title = $("<h1>").addClass("effective-permissions-title").text("Effective Permissions").hide();
		$(".page-restrictions-dialog-selector-container").append($title);
		
		// Switch out the Help link destination
		$("#update-page-restrictions-dialog .dialog-help-link a").attr("href", DESHAW_PERMISSIONS_DOCUMENTATION_URL);
		
		// Call back to server to check whether the page is inheriting edit permission to support DESHAW-104 warning message
		if (!self.dialog.hasClass("inherited-permissions-checked")) $.get(
			contextPath + "/plugins/editrestrictions/pagehasinheritededitpermissions.action",
			{pageId: EffectivePermissions.pageId},
			function (result) { self.addInheritedEditRestrictionWarning(result); },
			"json"
		);

	};
	
	prototype.initializeEffectivePermissionsPanel = function () {
		var self = this;
		self.loader = false;
		
		$("#effective-permissions-options .propagate-edit-restrictions")
			.showIf(!EffectivePermissions.parentPageId.length)
			.click(function (e) { return self.propagateEditRestrictions(e, this); });
		
		Confluence.Binder.userHover();
	};
	
	prototype.initializeGroupMembersPanel = function (result, $members, groupName) {
		var self = this;
		var display = $members.css("display");
		$members.replaceWith(result);
		self.groupMemberRows(groupName).css("display", display);
		Confluence.Binder.userHover();
	};
	
	prototype.isViewingEffectivePermissions = function () {
		return this.toggler.hasClass("viewing-effective-permissions");
	};
	
	prototype.propagateEditRestrictions = function (e, link) {
		return confirm($.trim($(link).text()) + "?\n\nPage with explicit edit restrictions will be ignored.");
	};

	prototype.toggleEffectivePermissionsView = function (e) {
		e.preventDefault();
		var self = this;

		self.adjustToggler();
		var isOn = this.isViewingEffectivePermissions();
		
		// Keep track of each panel's state as Confluence changes visibility based on user action
		if (isOn) {
			EffectivePermissions.emptyPlaceholderDisplay = $(".page-restrictions-dialog-empty-placeholder").css("display");
			EffectivePermissions.entitiesContainerDisplay = $(".page-restrictions-dialog-entities-container").css("display");
			$(".page-restrictions-dialog-empty-placeholder, .page-restrictions-dialog-entities-container").css("display", "none");
		}
		else {
			$(".page-restrictions-dialog-empty-placeholder").css("display", EffectivePermissions.emptyPlaceholderDisplay);
			$(".page-restrictions-dialog-entities-container").css("display", EffectivePermissions.entitiesContainerDisplay);
			
		}

		$(".page-restrictions-dialog-selector-container form.aui, #page-restrictions-dialog-save-button, #effective-permissions-messages").hideIf(isOn);
		$(".effective-permissions-title, .effective-permissions-panel").showIf(isOn);
		
		if (self.loader || isOn) {
			self.panel.load(contextPath + "/plugins/effectivepermissions/load.action",
				{pageId: self.forPageId(), draftContentId: (EffectivePermissions.pageId == 0 ? EffectivePermissions.contentId : 0)},
				function () { self.initializeEffectivePermissionsPanel(); }
			);
		}
		
		return false;
	};
	
	prototype.toggleGroupMembers = function (e, toggler) {
		var self = this;
		e.preventDefault();
		var $toggler = $(toggler);
		$toggler.find(".aui-icon").toggleClass("aui-iconfont-collapsed aui-iconfont-expanded");
		var $row = $toggler.closest("tr");
		var groupName = $row.data("group");
		
		var $members = self.groupMemberRows(groupName);
		if ($members.length) {
			$members.toggle();
		}
		else {
			var $loader = $("<td>").attr("colspan", "3").html("<em>Loading...</em>");
			$members = $("<tr>").addClass("group-members loading").attr("data-group-name", groupName).append($loader);
			$row.after($members);
			$.get(contextPath + "/plugins/groupmembers/load.action",
				{groupName: groupName, pageId: self.forPageId(), wantsEdit: $row.data("edit")},
				function (result) {self.initializeGroupMembersPanel(result, $members, groupName); }
			);
		}
		
		return false;
	};
	

})(jQuery);

(function ($) {
	
	EffectivePermissions.toInit(function ($) {		
		$(document).ajaxComplete(function () { new EffectivePermissions.Restrictions(); });
		
		// Add information messages to panels to describe effects of propagating edit restrictions
		var addEditRestrictionsMessage = function (selector) {
			AJS.messages.info(selector, {
				insert: "prepend",
			    title: "Review the Effective Permissions view after moving.",
			    body: "<p>When pages are moved, inherited page edit restrictions will be updated for their new location. Edit permissions from root or home pages will not be inherited.</p>"
			});
			$(selector).addClass("adjusted-for-edit-restrictions");
		};
		addEditRestrictionsMessage("#space-tools-body .pagecontent");	// Space Tools > Reorder Pages
		addEditRestrictionsMessage("#content.list-content-tree .pagecontent");	// Page > View In Hierarchy
		$(document).ajaxComplete(function () { 							// Page > Move popup dialog
			addEditRestrictionsMessage("#move-page-dialog .dialog-panel-body.location-panel:not(.adjusted-for-edit-restrictions)");
		});
	});

	EffectivePermissions.toInit(function ($) {		
		
		// Adjust the View Info page to remove display ofthe page restrictions and provide link to the wizard
		$(".pageInfoLayoutTable .basicPanelTitle").each(function () { 
			if ($.trim($(this).text()) != "Page Permissions") return;
			var $opener = $("<a>").attr("id", "page-restrictions-opener").text("View Effective Permissions");
			$opener.click(function () { $("#action-page-permissions-link").click(); return false; });
			$(this).closest(".basicPanelContainer").find(".basicPanelBody ul").replaceWith($opener);
		});
		
	});

	EffectivePermissions.toInit(function ($) {		
		
		var bulkPropagate = function () {
			if ($(this).hasClass("disabled") || !confirm("Propagate page edit restrictions throughout this space?\n\nHome pages and root pages will be ignored.")) return false;
			$("#bulk-propagate-restrictions-options").spin().find("a").addClass("disabled");
			$.post(contextPath + "/plugins/editrestrictions/bulkpropagate.action",
				{key: EffectivePermissions.spaceKey},
				displayResult,
				"json"
			);
			checkProgress();
			return false;
		};
		
		var bulkRemove = function () {
			if ($(this).hasClass("disabled") || !confirm("Remove inherited page edit restrictions from all pages in this space?\n\nDirectly applied restrictions will be preserved.")) return false;
			$("#bulk-propagate-restrictions-options").spin().find("a").addClass("disabled");
			$.post(contextPath + "/plugins/editrestrictions/bulkremove.action",
				{key: EffectivePermissions.spaceKey},
				displayResult,
				"json"
			);
			checkProgress();
			return false;
		};
		
		var checkProgress = function (immediate) {
			clearTimeout(EffectivePermissions.progressChecker);
			EffectivePermissions.progressChecker = setTimeout(updateProgressBar, immediate ? 0 : 3000);
		};
		
		var displayResult = function (result) { 
			clearTimeout(EffectivePermissions.progressChecker);
			if (result.success) {
				setBarWidth("100%");
				alert("Done.\n\nClick OK to reload page."); 
				location.reload(true);
			}
			else {
				alert(result.message);
			}
		};
				
		var setBarWidth = function (width) {
			$("#propagate-progress").css("display", "inline-block").find(".visual").css("width", width);
		};
		
		var updateProgressBar = function () {
			$.get(contextPath + "/plugins/editrestrictions/progress.action",
				{key: EffectivePermissions.spaceKey},
				function (result) {
					if (result.progress) {
						$("#bulk-propagate-restrictions-options").spinStop().find("a").addClass("disabled");
						setBarWidth(result.progress);
						EffectivePermissions.bulkOperationInProgress = true;
						checkProgress();
					}
					else if (EffectivePermissions.bulkOperationInProgress) {
						displayResult({success: true});
					}
				},
				"json"
			)
		};
		
		// Add bulk edit restrictions propagtion links to the Space Tools > Restrictions panel
		var $restrictionsPanel = $(".spacetools.list-permission-pages-mode .space-administration.list-permission-pages #space-tools-body #action-messages");
		if ($restrictionsPanel.length) {
			var $bulkPropagateLink = $("<a>")
					.attr("id", "bulk-propagate-restrictions")
					.attr("href", "#")
					.text("Bulk Propagate Edit Restrictions")
					.click(bulkPropagate);
			var $bulkRemoveLink = $("<a>")
					.attr("id", "bulk-remove-inherited-restrictions")
					.attr("href", "#")
					.text("Bulk Remove Inherited Edit Restrictions")
					.click(bulkRemove);
			
			var $progress = $("<div>").addClass("progress-bar").attr("id", "propagate-progress").append($("<span>").addClass("visual"));
			var $options = $("<div>").attr("id", "bulk-propagate-restrictions-options").append($bulkPropagateLink).append($bulkRemoveLink).append($progress);
			$restrictionsPanel.before($options);
			checkProgress(true);
		}
		
		// $("#action-page-permissions-link").click();

		if (EffectivePermissions.pageId && EffectivePermissions.parentPageId && $(".wiki-content").length && !$("#editPageLink").length) {
			$("#create-page-button").remove();
			$("#quick-create-page-button").removeAttr("id").unbind().click(function () {
				alert("You do not have edit restrictions on the current page and cannot create a page here.");
				return false;
			});
		}
	});

})(jQuery);