(function ($) {

	// To simplify brikit-core, reference core javascript using BrikitCore
	var BrikitCore = this[brikitProduct];

	BrikitCore.String = {
		
		// Return the sentence case version of the receiver, converting underscores and hyphens to spaces
		// "Read him the riot_act".titleize() => "Read Him The Riot Act"
		titleize: function (string) {
			return string.replace(/[-_]/g, function () { return " ";})
				.toLowerCase()
				.replace(/(?:^|\s)[a-z]/g, function (c) { return c.toUpperCase(); });
		},
		
		truncateWords: function (string, limit) {
			if (string.length <= limit) return string;
			limit -= 3;
			var result = "";
			$.each(string.split(" "), function (i, s) {
				var n = result + " " + s;
				if (n.length < limit) result = n;
			});
			if (!result.length) result = string.substring(0, limit);
			return result + "...";
		}
	}

})(jQuery);

String.prototype.titleize = function (string) {
	return this.replace(/[-_]/g, function () { return " ";})
		.toLowerCase()
		.replace(/(?:^|\s)[a-z]/g, function (c) { return c.toUpperCase(); });
};
