/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model.query;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.ConfluenceUser;
import com.brikit.contentflow.model.ApprovalStep;
import com.brikit.contentflow.model.UserDelegate;
import com.brikit.contentflow.model.ao.ApprovalStepAO;
import com.brikit.contentflow.model.ao.PageWorkflowAO;
import com.brikit.contentflow.model.ao.ReviewerAO;
import com.brikit.contentflow.model.ao.WorkflowAO;
import com.brikit.core.ao.AbstractQuery;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import net.java.ao.Query;

public class PageWorkflowQuery
extends AbstractQuery {
    public PageWorkflowQuery(ActiveObjects activeObjects) {
        super(activeObjects);
    }

    protected Query activePageWorkflowsQuery(String spaceKey) {
        return Query.select().where("SPACE_KEY = ? and STATUS is null", new Object[]{spaceKey});
    }

    protected Query activePageWorkflowsQuery(WorkflowAO workflowAO) {
        return Query.select().where("WORKFLOW_AOID = ? and STATUS is null", new Object[]{workflowAO.getID()});
    }

    protected Query activePageWorkflowsQuery(WorkflowAO workflowAO, String spaceKey) {
        return Query.select().where("WORKFLOW_AOID = ? and SPACE_KEY = ? and STATUS is null", new Object[]{workflowAO.getID(), spaceKey});
    }

    protected int count(Query query) {
        return this.getActiveObjects().count(PageWorkflowAO.class, query);
    }

    public int countActivePageWorkflows(String spaceKey) {
        return this.count(this.activePageWorkflowsQuery(spaceKey));
    }

    public int countActivePageWorkflows(WorkflowAO workflowAO, String spaceKey) {
        Query query = BrikitString.isSet((String)spaceKey) ? this.activePageWorkflowsQuery(workflowAO, spaceKey) : this.activePageWorkflowsQuery(workflowAO);
        return this.count(query);
    }

    public PageWorkflowAO[] getActivePageWorkflows(String spaceKey) {
        return this.runQuery(this.activePageWorkflowsQuery(spaceKey));
    }

    public PageWorkflowAO[] getAllPageWorkflows(String spaceKey) {
        Query query = Query.select().where("SPACE_KEY = ?", new Object[]{spaceKey});
        return this.runQuery(query);
    }

    public PageWorkflowAO getPageWorkflowForPage(long pageId) {
        Query query = Query.select().where("PAGE_ID = ?", new Object[]{pageId}).order("ID DESC");
        return (PageWorkflowAO)new BrikitList((Object[])this.runQuery(query)).first();
    }

    public PageWorkflowAO getAnyPageWorkflowForWorkflowID(int workflowId) {
        Query query = Query.select().where("WORKFLOW_AOID = ?", new Object[]{workflowId}).limit(1);
        return (PageWorkflowAO)new BrikitList((Object[])this.runQuery(query)).first();
    }

    public PageWorkflowAO[] getPageWorkflowsReferencingApprovalStep(ApprovalStep approvalStep) {
        Query query = Query.select().where("CURRENT_APPROVAL_STEP_AOID = ?", new Object[]{approvalStep.getID()});
        return this.runQuery(query);
    }

    public PageWorkflowAO getPageWorkflowWithId(int id) {
        return (PageWorkflowAO)this.getActiveObjects().get(PageWorkflowAO.class, (Object)id);
    }

    public PageWorkflowAO[] getPageWorkflowsWaitingOnUser(ConfluenceUser aUser) {
        String userKey = Confluence.getUserKeyString((ConfluenceUser)aUser);
        UserDelegate userDelegate = UserDelegate.getUserDelegateForDelegate(this.getActiveObjects(), aUser);
        String delegatingUserKey = userDelegate == null ? userKey : Confluence.getUserKeyString((ConfluenceUser)userDelegate.getDelegatingUser());
        Query query = Query.select().alias(PageWorkflowAO.class, "PAGEWORKFLOW").alias(ApprovalStepAO.class, "APPROVALSTEP").alias(ReviewerAO.class, "REVIEWER").join(ApprovalStepAO.class, "APPROVALSTEP.WORKFLOW_AOID = PAGEWORKFLOW.WORKFLOW_AOID").join(ApprovalStepAO.class, "APPROVALSTEP.ID = PAGEWORKFLOW.CURRENT_APPROVAL_STEP_AOID").join(ReviewerAO.class, "REVIEWER.APPROVAL_STEP_AOID = APPROVALSTEP.ID").where("(REVIEWER.USER = ? OR REVIEWER.USER = ?) AND PAGEWORKFLOW.PAGE_ID > 0", new Object[]{userKey, delegatingUserKey});
        return this.runQuery(query);
    }

    protected PageWorkflowAO[] runQuery(Query query) {
        return query == null ? new PageWorkflowAO[]{} : (PageWorkflowAO[])this.getActiveObjects().find(PageWorkflowAO.class, query);
    }
}

