/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.brikit.contentflow.model.ao.PublishedPageAO;
import com.brikit.contentflow.model.query.PublishedPageQuery;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitDate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class PublishedPage
extends AbstractActiveObjectsModel {
    protected static int CREATE_PAGE_PUBLISHED_PLACEHOLDER_VERSION = -1;
    protected PublishedPageAO activeObject;

    public PublishedPage(ActiveObjects activeObjects, PublishedPageAO activeObject) {
        super(activeObjects);
        this.setActiveObject(activeObject);
    }

    public static PublishedPage create(ActiveObjects activeObjects, String pageIdAsString) {
        return PublishedPage.create(activeObjects, Confluence.getPageOrBlogPost((String)pageIdAsString));
    }

    public static PublishedPage create(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return PublishedPage.create(activeObjects, abstractPage, abstractPage.getVersion());
    }

    public static PublishedPage create(ActiveObjects activeObjects, AbstractPage abstractPage, int pageVersion) {
        PublishedPageAO publishedPageAO = (PublishedPageAO)activeObjects.create(PublishedPageAO.class, new DBParam[0]);
        publishedPageAO.setPageId(abstractPage.getId());
        publishedPageAO.setSpaceKey(Confluence.getSpaceKey((AbstractPage)abstractPage));
        PublishedPage publishedPage = new PublishedPage(activeObjects, publishedPageAO);
        publishedPage.setPublishedVersion(pageVersion);
        publishedPage.save();
        return publishedPage;
    }

    public static PublishedPage createForNewPage(ActiveObjects activeObjects, AbstractPage abstractPage) {
        PublishedPage previous = PublishedPage.getPublishedPageForPage(activeObjects, abstractPage);
        if (previous != null && previous.getPreviouslyPublishedVersion() == CREATE_PAGE_PUBLISHED_PLACEHOLDER_VERSION) {
            previous.delete();
        }
        return PublishedPage.create(activeObjects, abstractPage, CREATE_PAGE_PUBLISHED_PLACEHOLDER_VERSION);
    }

    protected static List<PublishedPage> fromActiveObjects(ActiveObjects activeObjects, PublishedPageAO[] publishedPageAOs) {
        ArrayList<PublishedPage> publishedPages = new ArrayList<PublishedPage>(publishedPageAOs.length);
        for (PublishedPageAO publishedPageAO : publishedPageAOs) {
            publishedPages.add(new PublishedPage(activeObjects, publishedPageAO));
        }
        return publishedPages;
    }

    public static List<PublishedPage> getAllPageWorkflows(ActiveObjects activeObjects, Space space) {
        PublishedPageQuery query = new PublishedPageQuery(activeObjects);
        return PublishedPage.fromActiveObjects(activeObjects, query.getAllPublishedPages(space.getKey()));
    }

    public static PublishedPage getPublishedPageForPage(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return PublishedPage.getPublishedPageForPage(activeObjects, abstractPage.getId());
    }

    public static PublishedPage getPublishedPageForPage(ActiveObjects activeObjects, long pageId) {
        PublishedPageAO publishedPageAO = PublishedPage.getPublishedPageAO(activeObjects, pageId);
        return publishedPageAO == null ? null : new PublishedPage(activeObjects, publishedPageAO);
    }

    protected static PublishedPageAO getPublishedPageAO(ActiveObjects activeObjects, long pageId) {
        PublishedPageQuery query = new PublishedPageQuery(activeObjects);
        return query.getPublishedPageForPage(pageId);
    }

    public void delete() {
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    public AbstractPage getAbstractPage() {
        return Confluence.getPageOrBlogPost((long)this.getPageId());
    }

    public PublishedPageAO getActiveObject() {
        return this.activeObject;
    }

    public Calendar getDateLastPublished() {
        Date date = this.getActiveObject().getDateLastPublished();
        return date == null ? null : BrikitDate.toCalendar((Date)date);
    }

    public int getID() {
        return this.getActiveObject().getID();
    }

    public long getPageId() {
        return this.getActiveObject().getPageId();
    }

    public int getPreviouslyPublishedVersion() {
        return this.getActiveObject().getPreviouslyPublishedVersion();
    }

    public int getPublishedVersion() {
        return this.getActiveObject().getPublishedVersion();
    }

    public Space getSpace() {
        return Confluence.getSpace((String)this.getSpaceKey());
    }

    public String getSpaceKey() {
        return this.getActiveObject().getSpaceKey();
    }

    public String getSpaceName() {
        return Confluence.getSpaceName((String)this.getSpaceKey());
    }

    public boolean isNewPageUnderAutomaticPublishingWorkflow() {
        return this.getPublishedVersion() == CREATE_PAGE_PUBLISHED_PLACEHOLDER_VERSION;
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setActiveObject(PublishedPageAO activeObject) {
        this.activeObject = activeObject;
    }

    public void setDateLastPublished(Calendar dateLastPublished) {
        this.setDateLastPublished(BrikitDate.toDate((Calendar)dateLastPublished));
    }

    public void setDateLastPublished(Date dateLastPublished) {
        this.getActiveObject().setDateLastPublished(dateLastPublished);
    }

    public void setPreviouslyPublishedVersion(int previouslyPublishedVersion) {
        this.getActiveObject().setPreviouslyPublishedVersion(previouslyPublishedVersion);
    }

    public void setPublishedVersion(int publishedVersion) {
        this.getActiveObject().setPublishedVersion(publishedVersion);
    }

    public void setSpaceKey(String spaceKey) {
        this.getActiveObject().setSpaceKey(spaceKey);
    }
}

