/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.jobs;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bandana.BandanaContext;
import com.atlassian.confluence.api.service.search.CQLSearchService;
import com.atlassian.confluence.setup.bandana.ConfluenceBandanaContext;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitString;
import javax.annotation.Nullable;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractContentFlowJob
implements JobRunner {
    public static final String JOB_USERNAME = "com.brikit.contentflow.job.username";
    protected ActiveObjects activeObjects;
    protected TransactionTemplate transactionTemplate;
    protected LocalNotificationService notificationService;
    protected CQLSearchService searchService;

    public AbstractContentFlowJob(@ConfluenceImport ActiveObjects activeObjects, @ConfluenceImport LocalNotificationService notificationService, @ConfluenceImport TransactionTemplate transactionTemplate, @ConfluenceImport CQLSearchService searchService) {
        this.activeObjects = activeObjects;
        this.notificationService = notificationService;
        this.transactionTemplate = transactionTemplate;
        this.searchService = searchService;
    }

    public static String getJobUsername() {
        String username = (String)Confluence.getBandanaManager().getValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, JOB_USERNAME);
        if (!BrikitString.isSet((String)username)) {
            username = Confluence.findAnyConfluenceAdministrator().getName();
        }
        return username;
    }

    public void insideTransaction() {
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        this.getTransactionTemplate().execute(new TransactionCallback(){

            public Object doInTransaction() {
                AbstractContentFlowJob.this.insideTransaction();
                return null;
            }
        });
        return null;
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public CQLSearchService getSearchService() {
        return this.searchService;
    }

    public LocalNotificationService getNotificationService() {
        return this.notificationService;
    }

    public TransactionTemplate getTransactionTemplate() {
        return this.transactionTemplate;
    }

    public static void setJobUsername(String username) {
        Confluence.getBandanaManager().setValue((BandanaContext)ConfluenceBandanaContext.GLOBAL_CONTEXT, JOB_USERNAME, (Object)username);
    }
}

