/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.jobs;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.mywork.service.LocalNotificationService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.brikit.contentflow.jobs.AbstractContentFlowJob;
import com.brikit.contentflow.model.PageActivity;
import com.brikit.contentflow.settings.PageActivitySettings;
import com.brikit.core.confluence.Confluence;
import javax.inject.Inject;
import org.springframework.stereotype.Component;

@Component(value="purgePageViewRecordsJob")
public class PurgePageViewRecordsJob
extends AbstractContentFlowJob {
    @Inject
    public PurgePageViewRecordsJob(@ConfluenceImport ActiveObjects activeObjects, @ConfluenceImport LocalNotificationService notificationService, @ConfluenceImport TransactionTemplate transactionTemplate) {
        super(activeObjects, notificationService, transactionTemplate);
    }

    @Override
    public void insideTransaction() {
        for (Space space : Confluence.getAllSpaces()) {
            if (!PageActivitySettings.isPageActivityEnabled(space)) continue;
            PageActivity.purgeActivity(this.getActiveObjects(), space);
        }
    }
}

