/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.servlet;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.contentflow.model.ContentFlowConfiguration;
import com.brikit.core.comalaworkflowsservice.ComalaAccessor;
import com.brikit.core.confluence.Confluence;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ComalaCompatibilityFilter
implements Filter {
    protected FilterConfig filterConfig;
    protected ActiveObjects activeObjects;

    public static AbstractPage getPage(HttpServletRequest httpRequest, String path) {
        AbstractPage abstractPage = null;
        if (path.startsWith("/pages/viewpage.action")) {
            abstractPage = Confluence.getPageOrBlogPost((String)httpRequest.getParameter("pageId"));
        }
        if (abstractPage == null && path.startsWith("/pages/viewpage.action")) {
            abstractPage = Confluence.getPage((String)httpRequest.getParameter("spaceKey"), (String)httpRequest.getParameter("title"));
        }
        return abstractPage;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        AbstractPage abstractPage;
        if (!(servletRequest instanceof HttpServletRequest) || !(servletResponse instanceof HttpServletResponse)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        if (!this.isComalaInstalled()) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)servletRequest;
        String path = httpRequest.getRequestURI();
        if (path.startsWith(Confluence.getContextPath())) {
            path = path.substring(Confluence.getContextPath().length());
        }
        if ((abstractPage = ComalaCompatibilityFilter.getPage(httpRequest, path)) == null || !ContentFlowConfiguration.canUseWorkflows(this.getActiveObjects(), abstractPage)) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        path = Confluence.getContextPath() + "/contentflow" + path + "?" + httpRequest.getQueryString();
        ((HttpServletResponse)servletResponse).sendRedirect(path);
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    protected FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        this.filterConfig = filterConfig;
    }

    public boolean isComalaInstalled() {
        return ComalaAccessor.getComala() != null;
    }

    public void setActiveObjects(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }
}

