/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.actions;

import com.atlassian.confluence.spaces.actions.AbstractSpaceAdminAction;
import com.brikit.contentflow.model.DocumentIdentifiers;
import com.brikit.contentflow.settings.DocumentIdentifierSettings;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitMap;
import com.brikit.core.util.BrikitString;
import java.util.List;

public class DocumentIdentifiersSpaceAction
extends AbstractSpaceAdminAction {
    protected String documentIdentifierPattern;
    protected String libraryCode;
    protected int nextDocumentNumber;
    protected boolean reindexing;

    public String doDefault() throws Exception {
        BrikitMap<String, String> libraryCodes = DocumentIdentifierSettings.getLibraryCodesByCode();
        String existingSpace = (String)libraryCodes.get((Object)this.getLibraryCode());
        if (BrikitString.isSet((String)existingSpace) && !this.getSpaceKey().equals(existingSpace)) {
            this.addActionError("Library code " + this.libraryCode + " is used by space " + Confluence.getSpace((String)existingSpace));
            return "error";
        }
        DocumentIdentifierSettings.setSpaceDocumentIdentifierPattern(this.getSpace(), this.getDocumentIdentifierPattern());
        DocumentIdentifierSettings.setSpaceLibraryCode(this.getSpace(), this.getLibraryCode());
        DocumentIdentifierSettings.setSpaceNextDocumentNumber(this.getSpace(), this.getNextDocumentNumber());
        return "success";
    }

    public String execute() throws Exception {
        this.setDocumentIdentifierPattern(DocumentIdentifierSettings.getSpaceDocumentIdentifierPattern(this.getSpace()));
        this.setLibraryCode(DocumentIdentifierSettings.getSpaceLibraryCode(this.getSpace()));
        this.setNextDocumentNumber(DocumentIdentifierSettings.getSpaceNextDocumentNumber(this.getSpace()));
        return "input";
    }

    public String getComposedDocumentIdentifier() {
        BrikitList numbers = new BrikitList(1);
        numbers.add((Object)this.getNextDocumentNumber());
        return DocumentIdentifiers.composeDocumentIdentifier(this.getLibraryCode(), this.getDocumentIdentifierPattern(), (List<Integer>)numbers, false);
    }

    public String getDocumentIdentifierPattern() {
        return this.documentIdentifierPattern;
    }

    public String getLibraryCode() {
        return this.libraryCode;
    }

    public int getNextDocumentNumber() {
        return Math.max(1, this.nextDocumentNumber);
    }

    public boolean isDocumentIdentifiersEnabled() {
        return DocumentIdentifierSettings.isDocumentIdentifiersEnabled(this.getLibraryCode(), this.getDocumentIdentifierPattern());
    }

    public boolean isReindexing() {
        return this.reindexing;
    }

    public String reindex() {
        this.setReindexing(true);
        DocumentIdentifiers.reindexForSpace(this.getKey());
        return "success";
    }

    public void setDocumentIdentifierPattern(String documentIdentifierPattern) {
        this.documentIdentifierPattern = documentIdentifierPattern;
    }

    public void setLibraryCode(String libraryCode) {
        this.libraryCode = libraryCode;
    }

    public void setNextDocumentNumber(int nextDocumentNumber) {
        this.nextDocumentNumber = nextDocumentNumber;
    }

    public void setReindexing(boolean reindexing) {
        this.reindexing = reindexing;
    }
}

