/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.develop;

import com.atlassian.confluence.setup.BootstrapManager;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.spring.container.ContainerManager;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.develop.BrikitDeveloperSettingsListener;
import com.brikit.core.develop.ExternalDevelopmentModeSettings;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitFile;
import java.io.File;
import java.util.List;

public class ExternalDevelopmentMode {
    protected static final String CONFLUENCE_INSTALL_DEVELOPER_DIRECTORY = "developer";
    protected static final String CONFLUENCE_INSTALL_PROPERTIES_DIRECTORY = "properties";
    protected static final String EXTERNAL_SYM_LINK_NAME = "theme-press";
    protected static final String NO_RENDER_SERVLET_PATH = "/plugins/servlet/themepress/brikitservlet";
    protected static Boolean developerMode;

    public static String confluenceInstallFileLocation(String pluginFolder) {
        if ("com.brikit.themepress:theme-base".equals(pluginFolder)) {
            pluginFolder = EXTERNAL_SYM_LINK_NAME;
        }
        return "developer/" + pluginFolder;
    }

    public static String externalFileLocation() {
        return ExternalDevelopmentModeSettings.getExternalLocation();
    }

    public static List getAvailableThemeDescriptors() {
        return ExternalDevelopmentMode.getThemeManager().getAvailableThemeDescriptors();
    }

    public static BootstrapManager getBoostrapManager() {
        return (BootstrapManager)ContainerManager.getComponent((String)"bootstrapManager");
    }

    public static String getContextPath() {
        return ExternalDevelopmentMode.getBoostrapManager().getWebAppContextPath();
    }

    public static File getThemeDevFolder() {
        return new File(Confluence.getConfluenceInstallLocation(), CONFLUENCE_INSTALL_DEVELOPER_DIRECTORY);
    }

    public static File getThemeDevSymLink() {
        return new File(ExternalDevelopmentMode.getThemeDevFolder(), EXTERNAL_SYM_LINK_NAME);
    }

    public static ThemeManager getThemeManager() {
        return (ThemeManager)ContainerManager.getComponent((String)"themeManager");
    }

    public static boolean hasValidExternalFiles() {
        File externalDirectory = new File(ExternalDevelopmentMode.externalFileLocation());
        return externalDirectory.isDirectory();
    }

    public static Boolean shouldUseExternalFiles() {
        boolean useExternal = ExternalDevelopmentMode.useExternalFilesSetting();
        if (useExternal) {
            ExternalDevelopmentMode.ensureThemeDevSymLink();
        }
        if (useExternal && !ExternalDevelopmentMode.hasValidExternalFiles()) {
            useExternal = false;
            BrikitLog.logWarning("Can't find external developer directory " + new File(ExternalDevelopmentModeSettings.getExternalLocation(), ExternalDevelopmentMode.externalFileLocation()) + "; using JAR files instead.");
            ExternalDevelopmentModeSettings.setUseThemeDevEnv(null);
        }
        return useExternal;
    }

    public static boolean useExternalFilesSetting() {
        return "on".equals(ExternalDevelopmentModeSettings.shouldUseThemeDevEnv());
    }

    public static void ensureThemeDevSymLink() {
        try {
            File symLocation = ExternalDevelopmentMode.getThemeDevFolder();
            BrikitFile.ensurePathExists(symLocation);
            File symLink = ExternalDevelopmentMode.getThemeDevSymLink();
            if (!symLink.exists()) {
                String source = ExternalDevelopmentMode.externalFileLocation();
                Process process = Runtime.getRuntime().exec(new String[]{"ln", "-s", source, symLink.getAbsolutePath()});
                process.waitFor();
                process.destroy();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static void removeThemeDevSymLink() {
        if (!ExternalDevelopmentMode.useExternalFilesSetting()) {
            return;
        }
        File symLink = ExternalDevelopmentMode.getThemeDevSymLink();
        if (symLink.exists()) {
            symLink.delete();
        }
    }

    public static String themeKeyOnly() {
        return "com.brikit.themepress:theme-base".substring("com.brikit.themepress:theme-base".indexOf(58) + 1);
    }

    public static String directURL(String aThemeKey) {
        return ExternalDevelopmentMode.getContextPath() + NO_RENDER_SERVLET_PATH;
    }

    public static boolean isDesigning() {
        return ExternalDevelopmentMode.isDeveloperMode() || !ExternalDevelopmentModeSettings.cachesEnabled();
    }

    public static boolean isDeveloperMode() {
        return new Boolean(ExternalDevelopmentMode.shouldUseExternalFiles());
    }

    static {
        ExternalDevelopmentModeSettings.addListener(new BrikitDeveloperSettingsListener(){

            @Override
            public void externalDevelopmentModeSettingsChanged() {
                developerMode = null;
            }
        });
    }
}

