(function ($) {

	BrikitColumnBrowser = function (browser, options) {
		options = options || {};
		this.$browser = $(browser);
		this.$browser.data("browser", this);
		this.fixedColumns = options.fixedColumns;
		this.initialize();
	};
	
	var prototype = BrikitColumnBrowser.prototype;
	
	prototype.$columns = function () {
		return this.$find(".column");
	};
	
	prototype.$find = function (selector) {
		return selector ? $(selector, this.$browser) : this.$browser;
	};

	prototype.$selectedColumns = function () {
		return this.$find(".column.selected");
	};
	
	prototype.$selectedEntries = function () {
		return this.$selectedColumns().last().find(".entry.selected");
	};

	prototype.append = function (column) {
		if (column instanceof BrikitColumn) this.$browser.append(column.$column);
	};
	
	// options can be a string or an object
	// 		if a string, create a column using that string for the header text
	// 		if an object, options can include:
	// 		headerText: the header text for the column
	// 		class: set the class attribute
	prototype.createColumn = function (options) {
		options = typeof(options) == "string" ? {headerText: options} : options;
		var $header = $("<header>").text(options.headerText);
		var $column = $("<div>").addClass("column").append($header.attr("title", options.headerText));
		if (options.class) $column.addClass(options.class);
		$header.brikitColumn(this, options);
		return $header.data("column");
	};
	
	prototype.data = function (name, data) {
		return this.$find().data(name, data);
	};
	
	prototype.entrySelectionChanged = function (event) {
		event.browser = this;
		
		if (this.fixedColumns) return;
		
		this.$selectedColumns().nextAll().detach();
		
		var selectedEntries = this.getSelectedEntries();
		var childColumn = selectedEntries.length == 1 ? selectedEntries.get(0).childColumn : null;
		if (childColumn) this.$browser.append(childColumn);
	};
	
	prototype.freeze = function (freeze) {
		this.$find().adjustClass("frozen", freeze);
	};
	
	prototype.getFirstColumn = function () {
		return this.$columns().first().data("column");
	};
	
	prototype.getSelectedEntries = function () {
		return this.$selectedEntries().map(function (i, $entry) { return $entry.data("entry"); });
	};
	
	prototype.initialize = function () {
		var self = this;
		
		self.$find(".column").brikitColumn(self);
		
		self.$browser.on("selection", ".column", function (event) { self.entrySelectionChanged(event); });
	};
	
	prototype.isFrozen = function () {
		return this.$find().hasClass("frozen");
	};
	
	prototype.on = function (eventType, callback) {
		this.$browser.on(eventType, ".entry", function (event) { callback(event); });
	};

	prototype.setEnablement = function () {
	};
	
	prototype.unselectColumns = function () {
		this.$columns().removeClass("selected");
	};
	
	$.fn.brikitColumnBrowser = function (options) {
	    return this.each(function() {
			new BrikitColumnBrowser(this, options);
	    }).data("browser");
	};

})(jQuery);
