(function ($) {

	ThemePress.PresentationSlide = function (pageId, json, bulkInitialize) {
		this.pageId = pageId;
		
		if (bulkInitialize) {
			this.initializing = true;
		}
		else if (json) {
			this.initializeFromJson(json);
		}
		else {
			this.richLink = false;
			this.title = "";
			this.image = false;
			this.spaceKey = false;
			this.parent = false;
			this.grandparentPageId = false;
			this.hoppingParents = [];
			this.children = [];
			this.blocks = false;
		
			this.initializing = false;
			this.initialize();
		}
	};
	
	var prototype = ThemePress.PresentationSlide.prototype;

	prototype.display = function () {
		var self = this;
		if (self.initializing) return setTimeout(function () {self.display();}, 100);
		ContextFinder.finder.contextFinderScroller().spinStop();
		ContextFinder.finder.showRichLink(self.richLink);
	};
	
	prototype.displayNextBlock = function () {
		var self = this;
		self.initializeBlocks();
		if (self.loadingBlocks) return setTimeout(function () {self.displayNextBlock();}, 100);
		
		var $blocksContainer = ContextFinder.finder.blocksContainer();
		
		var $nextBlock = $([]);
		
		var $availableBlocks = self.blocks.find(".brikit-content-block");
		var $currentBlock = $blocksContainer.find(".brikit-content-block");

		if ($currentBlock.length) {
			var $found = $availableBlocks.filter(function () { return $(this).attr("id") == $currentBlock.attr("id"); });
			var index = $availableBlocks.toArray().indexOf($found.get(0));
			$nextBlock = $availableBlocks.slice(index + 1).first();
		}
		else {
			$nextBlock = $availableBlocks.first();
		}
		
		if ($nextBlock.length) $blocksContainer.empty().append($nextBlock.first().clone().show());
		else ContextFinder.finder.configureContainerForRichLinks();
		
	};
	
	prototype.initialize = function () {
		var self = this;
		self.initializing = true;

		// Fetch my rich link
		$.get(
			ThemePress.contextPath + "/plugins/brikit/contextfinder/contextpage.action", 
			{ pageId: self.pageId }, 
			function (json, textStatus, jqXHR) {
				if (json.success) self.initializeFromJson(json);
				self.initializing = false;
			},
			"json"
		);
	};
	
	prototype.initializeBlocks = function () {
		var self = this;
		if (self.loadingBlocks || self.blocks) return;

		self.loadingBlocks = true;
		$.get(
			ThemePress.contextPath + "/plugins/brikit/contextfinder/pageblocks.action", 
			{ pageId: self.pageId }, 
			function (json, textStatus, jqXHR) {
				if (json.success) {
					var $blocks = $("<div>").addClass("blocks");
					$(json.blocks).each(function (i, obj) {
						$blocks.append(obj.block);
					});
					self.blocks = $blocks;
				}

				self.loadingBlocks = false;
			},
			"json"
		);
		
	};
	
	prototype.initializeFromJson = function (json) {
		this.richLink = $(".rich-link", json.richLink);
		this.title = json.title;
		this.image = json.image;
		this.spaceKey = json.spaceKey;
		this.parent = json.parent;
		this.grandparentPageId = ContextFinder.finder.parentIdOrPlaceholder(json.grandparentPageId, json.spaceKey);
		this.hoppingParents = json.hoppingParents;
		this.children = json.children;
		this.initializing = false;
	};
	
})(jQuery);
