/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.brikit.core.macros.BrikitBaseMacro;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.html.RichLinks;
import java.util.Map;

public class WrapMacro
extends BrikitBaseMacro {
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/wrap.vm";
    public static final String TAG_PARAM = "tag";
    public static final String BORDER_SIDE_PARAM = "border-side";
    public static final String ALIGN_PARAM = "align";
    public static final String FLOAT_PARAM = "float";
    public static final String DISPLAY_RICH_LINKS_PARAM = "display-rich-links";
    public static final String IGNORE_THUMBNAILS_PARAM = "ignoreThumbnails";
    public static final String BORDER_ALL = "all";

    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        String align;
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        if (macroContext.stringValue(TAG_PARAM).equalsIgnoreCase("span")) {
            body = BrikitString.removeOuterParagraph((String)body);
        }
        if (macroContext.booleanValue(DISPLAY_RICH_LINKS_PARAM)) {
            body = RichLinks.convertLinksInHTML(body, macroContext.booleanValue(IGNORE_THUMBNAILS_PARAM));
        }
        macroContext.velocityContextAdd((Object)"body", (Object)body);
        if (BORDER_ALL.equals(macroContext.stringValue(BORDER_SIDE_PARAM))) {
            macroContext.velocityContextAdd((Object)BORDER_SIDE_PARAM, null);
        }
        if (BrikitString.isSet((String)(align = macroContext.stringValue(ALIGN_PARAM, macroContext.stringValue(FLOAT_PARAM))))) {
            macroContext.velocityContextAdd((Object)ALIGN_PARAM, (Object)align);
        }
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

