/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.designer;

import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.brikit.core.confluence.BrikitDataStore;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;

public class ThemeDesignerAccess {
    public static void addArchitectTabAccessGroup(String group, String spaceKey) throws Exception {
        BrikitList<String> groups = ThemeDesignerAccess.architectTabAccessGroups(spaceKey);
        if (!Confluence.isValidConfluenceGroupName((String)group)) {
            throw new Exception(Confluence.getText((String)"brikit.config.invalid.group"));
        }
        if (groups.contains((Object)group)) {
            return;
        }
        groups.add((Object)group);
        ThemeDesignerAccess.saveArchitectTabAccessGroups(groups, spaceKey);
    }

    public static boolean hasArchitectTabAccess(String spaceKey) {
        BrikitList<String> groups = ThemeDesignerAccess.architectTabAccessGroups(spaceKey);
        return Confluence.canAdministerSpace((String)spaceKey) || Confluence.isGroupMember(groups);
    }

    public static void removeArchitectTabAccessGroup(String group, String spaceKey) {
        Space space = Confluence.getSpace((String)spaceKey);
        if (space == null) {
            return;
        }
        BrikitList<String> groups = ThemeDesignerAccess.architectTabAccessGroups(spaceKey);
        if (!groups.contains((Object)group)) {
            return;
        }
        groups.remove((Object)group);
        ThemeDesignerAccess.saveArchitectTabAccessGroups(groups, spaceKey);
    }

    protected static void saveArchitectTabAccessGroups(BrikitList<String> groups, String spaceKey) {
        Space space = Confluence.getSpace((String)spaceKey);
        if (space == null) {
            return;
        }
        BrikitDataStore.setString((Space)space, (String)"com.brikit.themepress.access.groups.tab.architect", (String)groups.join(","));
    }

    public static BrikitList<String> architectTabAccessGroups(String spaceKey) {
        Space space = Confluence.getSpace((String)spaceKey);
        if (space == null) {
            return new BrikitList();
        }
        return BrikitString.splitCommaSeparated((String)BrikitDataStore.getString((Space)space, (String)"com.brikit.themepress.access.groups.tab.architect"));
    }

    public static void addPageTabAccessGroup(String group, String spaceKey) throws Exception {
        BrikitList<String> groups = ThemeDesignerAccess.pageTabAccessGroups(spaceKey);
        if (!Confluence.isValidConfluenceGroupName((String)group)) {
            throw new Exception(Confluence.getText((String)"brikit.config.invalid.group"));
        }
        if (groups.contains((Object)group)) {
            return;
        }
        groups.add((Object)group);
        ThemeDesignerAccess.savePageTabAccessGroups(groups, spaceKey);
    }

    public static boolean hasPageTabAccess(AbstractPage abstractPage) {
        if (abstractPage == null) {
            return false;
        }
        BrikitList<String> groups = ThemeDesignerAccess.pageTabAccessGroups(Confluence.getSpaceKey((AbstractPage)abstractPage));
        return Confluence.canEdit((AbstractPage)abstractPage) && (groups.isEmpty() || Confluence.isGroupMember(groups) || Confluence.isConfluenceAdministrator());
    }

    public static boolean hasPageTabAccess(String pageIdAsString) {
        return ThemeDesignerAccess.hasPageTabAccess(Confluence.getPageOrBlogPost((String)pageIdAsString));
    }

    public static void removePageTabAccessGroup(String group, String spaceKey) {
        Space space = Confluence.getSpace((String)spaceKey);
        if (space == null) {
            return;
        }
        BrikitList<String> groups = ThemeDesignerAccess.pageTabAccessGroups(spaceKey);
        if (!groups.contains((Object)group)) {
            return;
        }
        groups.remove((Object)group);
        ThemeDesignerAccess.savePageTabAccessGroups(groups, spaceKey);
    }

    protected static void savePageTabAccessGroups(BrikitList<String> groups, String spaceKey) {
        Space space = Confluence.getSpace((String)spaceKey);
        if (space == null) {
            return;
        }
        BrikitDataStore.setString((Space)space, (String)"com.brikit.themepress.access.groups.tab.page", (String)groups.join(","));
    }

    public static BrikitList<String> pageTabAccessGroups(String spaceKey) {
        Space space = Confluence.getSpace((String)spaceKey);
        if (space == null) {
            return new BrikitList();
        }
        return BrikitString.splitCommaSeparated((String)BrikitDataStore.getString((Space)space, (String)"com.brikit.themepress.access.groups.tab.page"));
    }

    public static void addThemeTabAccessGroup(String group) throws Exception {
        BrikitList<String> groups = ThemeDesignerAccess.themeTabAccessGroups();
        if (!Confluence.isValidConfluenceGroupName((String)group)) {
            throw new Exception(Confluence.getText((String)"brikit.config.invalid.group"));
        }
        if (groups.contains((Object)group)) {
            return;
        }
        groups.add((Object)group);
        ThemeDesignerAccess.saveThemeTabAccessGroups(groups);
    }

    public static boolean hasThemeTabAccess() {
        return Confluence.isConfluenceAdministrator() || Confluence.isGroupMember(ThemeDesignerAccess.themeTabAccessGroups());
    }

    public static void removeThemeTabAccessGroup(String group) {
        BrikitList<String> groups = ThemeDesignerAccess.themeTabAccessGroups();
        if (!groups.contains((Object)group)) {
            return;
        }
        groups.remove((Object)group);
        ThemeDesignerAccess.saveThemeTabAccessGroups(groups);
    }

    protected static void saveThemeTabAccessGroups(BrikitList<String> groups) {
        BrikitDataStore.setString((String)"", (String)"com.brikit.themepress.access.groups.tab.theme", (String)groups.join(","));
    }

    public static BrikitList<String> themeTabAccessGroups() {
        return BrikitString.splitCommaSeparated((String)BrikitDataStore.getString((String)"", (String)"com.brikit.themepress.access.groups.tab.theme"));
    }
}

