(function ($) {
	
	if (ThemePress.Browser.mobile) return;

	ThemePress.ThemeTab = {
		
		designerFocusCookie: "com.brikit.designer.theme.focus",
		
		designableElementSelectors: [
			"#header-precursor #messageContainer",
			"#page-layout-master",
			"#header",
			".ia-fixed-sidebar",
			".brikit-toolbar",
			".brikit-canvas",
			".brikit-header",
			".brikit-header-content",
			".brikit-logo",
			".brikit-search",
			".brikit-menu",
			".brikit-menu-dropdown",
			".brikit-menu-panel",
			".brikit-breadcrumbs",
			".brikit-page-title",
			".brikit-page-metadata",
			".brikit-content-stack",
			".content-layer",
			".brikit-main-column",
			".brikit-left-column",
			".brikit-right-column",
			".brikit-block",
			"#likes-and-labels-container",
			"#comments-section",
			".brikit-footer",
			".brikit-footer-content"
			
		],

		ajaxDesignerCall: function (action, data, method) {
			if (ThemePress.ThemeTab.undoInProgress) return;
			ThemePress.ThemeTab.undoInProgress = true;
			method = method || "post";
            ThemePress.addToken(data);
			$[method](ThemePress.contextPath + "/plugins/brikit/designer/" + action + ".action", data, ThemePress.ThemeTab.designUpdateResponse, "json");
		},

		animatePropertyChange: function ($fieldHolder) {
			$fieldHolder.scrollToBeVisible(ThemePress.Designer.designerHolder(), {leaveRoomAtTop: 60}, function () {
				$fieldHolder.animate({ borderColor: "#408C94" }, 1500, function () {
					setTimeout( function () { $fieldHolder.animate({borderColor: "white"}, 2000); }, 2000 );
				});
			});
		},
		
		applyChange: function () {
			var value = $(this).val();
			if ($(this).attr("type") == "checkbox") value = this.checked ? "on" : "";
			ThemePress.ThemeTab.ajaxDesignerCall("apply", { themeName: ThemePress.currentTheme(), property: $(this).attr("name"), value: value });
		},
		
		applyChangeWithReturn: function (event) {
			var keypress = event.which;
			if (keypress == 13) {
				ThemePress.ThemeTab.applyChange.call(this);
				return false;
			}
		},
		
		autoSizeTextareas: function () {
			if (ThemePress.Designer.isThemeMode()) ThemePress.Designer.autoSizeTextareas(ThemePress.ThemeTab.focusedElementToggle());
		},
		
		changeTheme: function () {
			var themeName = $(this).data("theme");
			var spaceOnly = ThemePress.Designer.isArchitectMode();
			if (spaceOnly) {
				var message = "<p>Set <strong>" + themeName + "</strong> as the theme for this space only?</p>";
				ThemePress.Dialog2.confirm(message, { title: "Change Space Theme" }, function (dialog) {
					dialog.hide();
					ThemePress.ThemeTab.setTheme(themeName, spaceOnly);
				});
			}
			else {
				var message = "<p>Set <strong>" + themeName + "</strong> as the site's default theme?</p>";
				ThemePress.Dialog2.doubleConfirm(message, { title: "Change Site Default Theme", doubleConfirmMessage: "<u>Yes, change the theme for all spaces using the site default</u>."}, function (dialog) {
					dialog.hide();
					ThemePress.ThemeTab.setTheme(themeName, spaceOnly);
				});
			}
			return false;
		},

		copyTheme: function () {
			ThemePress.Dialog2.confirm("<form class='aui' onsubmit='return false;'><fieldset><div class='field-group'><label for='new-theme-name'>Name</label> <input id='new-theme-name' name='newThemeName' class='text' type='text' /><div class='description'>Spaces are not allowed.</div></div></fieldset></form><p><em>This action will <u>not</u> change the default theme.</em></p>", { title: "Copy Theme: " + ThemePress.ThemeTab.selectedTheme() }, function (dialog) {
				var newThemeName = $.trim($("#new-theme-name").val());
				if (/\s/g.test(newThemeName)) {
					alert("Spaces are not allowed in theme names.");
					return false;
				}
				dialog.hide();
                const data = { pageId: ThemePress.pageId, themeName: ThemePress.ThemeTab.selectedTheme(), newThemeName: newThemeName };
                ThemePress.post(ThemePress.contextPath + "/plugins/brikit/theme/copy.action", 
					data, function (result) {
						if ($(result).hasClass("errorMessage")) ThemePress.Dialog2.alert(result, { title: "Error Copying Theme" });
						else ThemePress.Designer.reloadDesigner();
					}
				);
			});
			return false;
		},
		
		designerModeDidChange: function () {
			ThemePress.ThemeTab.undoButton().toggle(ThemePress.Designer.isThemeMode());
			ThemePress.ThemeTab.redoButton().toggle(ThemePress.Designer.isThemeMode());
		},
		
		designerModeWillChange: function () {
			if (!ThemePress.Designer.designerInitialized) return;
			if (ThemePress.Designer.isThemeMode() && ThemePress.ThemeTab.focusState()) ThemePress.Focus.showFocusBlanket();
		},
		
		designUpdateResponse: function (data, textStatus, jqXHR) {

			if (data && data.reloadCSS) ThemePress.ThemeTab.reloadCSS(data.cacheKey);

			// If the data change needs to be reflected in the designer, do so
			var $field;
			var value;
			if (data.changed) {
				var json = $.parseJSON(data.changed);
				var keys = Object.keys(json);
				if (keys.length) {
					var property = keys[0];
					value = json[property];
					$field = ThemePress.Designer.designer("[name=" + property + "]");
				}
			}
			
			ThemePress.ThemeTab.updateUndoRedoMenuItems(data.undo, data.redo); 
			if ($field) ThemePress.ThemeTab.resetProperty($field, value, data, $field.hasClass("reload-page"));
			ThemePress.ThemeTab.undoInProgress = false;
		},
		
		downloadTheme: function () {
			$(this).attr("href", ThemePress.contextPath + "/plugins/brikit/theme/download.action?themeName=" + encodeURIComponent(ThemePress.ThemeTab.selectedTheme()) + ThemePress.atlTokenParam(true));
		},
		
		elementSelector: function (element) {
			return $(element).data("selector");
		},

		focus: function () {
			if (!ThemePress.Designer.openState()) return;

			if ($(this).hasClass("closed") || $(this).closest(".accordion-switch").hasClass("closed")) {
				ThemePress.Focus.hideFocusBlanket();
				ThemePress.ThemeTab.saveFocusState(null);
			}
			else {
				var selector = ThemePress.ThemeTab.elementSelector(this);
				var $selected = $(".designable[data-selector='" + selector + "']").first();
				ThemePress.ThemeTab.saveFocusState(selector);
				ThemePress.Focus.showFocusBlanket();
			}
	    },
	
		focusedElement: function () {
			return $(ThemePress.ThemeTab.focusState());
		},
		
		focusedElementToggle: function () {
			return ThemePress.Designer.designableElements(ThemePress.ThemeTab.focusState());
		},
	
		focusState: function () {
			return ThemePress.cookie(ThemePress.ThemeTab.designerFocusCookie);
		},

		imagePreview: function () {
			var $propertyField = $(this).closest(".property-field-group").find(".image-field");
			var updateImage = function (dialog, imageName) {
				$propertyField.val(imageName);
				ThemePress.ThemeTab.applyChange.call($propertyField);
				dialog.remove();
				if (!ThemePress.Designer.shouldReloadOnChange($propertyField)) ThemePress.Designer.reloadDesigner();
			};
			AJS.InlineDialog(
				$(this), 
				"imagePreview" + new Date().getTime(),
				ThemePress.contextPath + "/plugins/brikit/designer/selectimage.action?key=" + encodeURIComponent(ThemePress.spaceKey) +
					"&pageId=" + ThemePress.pageId + "&imageName=" + encodeURIComponent($(this).data("image")) + ThemePress.atlTokenParam(true), 
				{
					onHover: false, 
					width: 400, 
					arrowOffsetX: 8,
					offsetX: -10,
					showDelay: 0, 
					initCallback: function () {
						var $popup = $(this.popup);
						$popup.css({zIndex: 10000});
						// Make the tooltips use the fancy AUI decoration
						$(".image-list .image", $popup).tooltip({aria:true});
						$(".image-list").on("click", ".image", function () {
							updateImage($popup, $(this).data("image"));
						});
						// Zap the "remove" icons from images that are used by the theme
						var $imagesInUse = ThemePress.Designer.designForm().find("input.image-field").map(function () { return $(this).val() });
						$(".image-list .image .remove").filter(function () { return $.inArray($(this).closest(".image").data("image"), $imagesInUse) != -1; }).remove();
						// Wire the "remove" icons
						$(".image-list .image").on("click", ".remove", function () {
							var imageName = $(this).closest(".image").data("image");
							ThemePress.Dialog2.confirm("<p>Remove " + imageName + " from the theme?</p><p>This cannot be undone.</p>", { title: "Delete Image" }, function (dialog) {
								dialog.hide();
                                const data = {key: ThemePress.spaceKey, imageName: imageName};
                                ThemePress.post(ThemePress.contextPath + "/plugins/brikit/designer/removeimage.action", 
									data,
									function () { ThemePress.Designer.messageUser("Image removed", true); }
								);
							});
							return false;
						});
						
						// When the file upload filename changes, automagically upload and apply the file to the current image field
						$("form.uploader .upfile", $popup).change(function () { $(this).closest("form.uploader").submit(); });
						
						// Make the file upload form work via ajax (using the jquery.form plugin)
						$("form.uploader", $popup).ajaxForm(function () {
							var filename = $("form.uploader .upfile", $popup).val().split('\\').pop();
							updateImage($popup, filename);
						});
					}
				}
			);
		},
		
		// Called only after the designer is loaded into the page from the server
		initializeAfterLoad: function (speed) {
			// Set up accordion elements
			ThemePress.Designer.designableElements()
				// Turn on the accordion feature of the list so only one element is open at a time
				.brikitAccordion(false, true, ".clickable-control", ".designer-panel", function () { $(this).find(".designer-panel textarea").autoSizingTextarea(); })
				.accordionSpeed("fast");

			// Make each accordian element click to focus the designer on it
			ThemePress.Designer.designableElements().on("click", ".clickable-control", ThemePress.ThemeTab.focus);
			ThemePress.Designer.designableElements().find(".clickable-control").each(function () {
				var selector = ThemePress.ThemeTab.elementSelector(this);
				$(selector)
					.addClass("designable")
					.attr("data-selector", selector);
			});

			// Open the accordion element that was last open (if any)
			if (ThemePress.Designer.isThemeMode()) ThemePress.Designer.designableElements(ThemePress.ThemeTab.focusState()).click();

			// Add a class to the first table row in each accordion panel to help with styling
			ThemePress.Designer.designableElements().find("table").each(function () { $("tr", this).first().addClass("first"); });

			// Wire the Development Mode switches
			ThemePress.Designer.designer(".theme-designer-selector .aui-button").click(ThemePress.ThemeTab.toggleThemeDesigner);
			ThemePress.Designer.designer(".brikit-developer-selector .aui-button").click(ThemePress.ThemeTab.toggleDeveloperMode);
			ThemePress.Designer.designer("#brikitExternalDeveloperLocation").change(ThemePress.ThemeTab.saveDeveloperExternalLocation);

			// Set up the manage themes popup
			ThemePress.Designer.designer("a.theme-manager").each(ThemePress.ThemeTab.themeManager);
			
			// Set up the theme picker popup
			ThemePress.Designer.designer("a.theme-chooser").not(".display-only").each(ThemePress.ThemeTab.themePreview);
			ThemePress.Designer.designer("a.theme-chooser.display-only").click(function () {return false;});


			// Set up the custom code popups
			ThemePress.Designer.designer(".css-editor-link").each(ThemePress.Code.viewCSSFiles);
			ThemePress.Designer.designer(".js-editor-link").each(ThemePress.Code.viewJavascriptFiles);
			
			// Wire the text input fields and text areas to apply changes to the theme
			ThemePress.Designer.designableElements().on("keypress", "input:not(.group-multi-select-search-field)", ThemePress.ThemeTab.applyChangeWithReturn);
			ThemePress.Designer.designableElements().on("change", "input, textarea, select", ThemePress.ThemeTab.applyChange);

			// Initialize the color picker fields
			ThemePress.Designer.designableElements().find(".color").beColorPicker();
			
			// Set up the image preview popups
			ThemePress.Designer.designForm().find("a.image-thumbnail").each(ThemePress.ThemeTab.imagePreview);
			
			// Clear header cookies when defaults for showing header change
			ThemePress.Designer.designer("#brikitAllowHeader, #brikitShowHeaderByDefault").change(function () {
				ThemePress.zapCookie(ThemePress.Structure.headerCookie);
			});
			
			// Stop the designer form from submitting; it gets ajax-ed one field at a time
			ThemePress.Designer.designForm().submit(function () { return false; });
			
			ThemePress.ThemeTab.structureDidChange();
			
			// Wire the designer header menu items for the undo/redo stack
			ThemePress.ThemeTab.undoButton().clickIfNotDisabled(ThemePress.ThemeTab.undoChange);
			ThemePress.ThemeTab.redoButton().clickIfNotDisabled(ThemePress.ThemeTab.redoChange);
			ThemePress.ThemeTab.updateUndoStackStatus();
		},

		redoButton: function () {
			return $("#appheader-frame a.redo");
		},
		
		redoChange: function () {
			ThemePress.ThemeTab.ajaxDesignerCall("redo", { themeName: ThemePress.currentTheme() });
			return false;
		},
		
		reloadCSS: function (cacheKey) {
			if (!cacheKey) return alert("No cache key for reloading CSS. Try refreshing the page.");
		    $("#brikit-css-all").each(function () {
				var href = ThemePress.contextPath + "/plugins/servlet/themepress/cssbundle/" + cacheKey + "/combined.css" + ThemePress.atlTokenParam();
		        $(this).attr("href", href);
		    });
			// ThemePress.ThemeTab.updateDisplayLoop();	// Adjust display regularly to acccomodate sizing changes in the designer
		},
		
		removeTheme: function () {
			if (ThemePress.isDeveloperMode()) {
				ThemePress.Dialog2.alert("<p>Not available in Developer mode.</p>");
				return false;
			}

			var themeName = $(this).closest(".image").data("theme");
			
			var proceedCallback = function (dialog) {
                ThemePress.post(ThemePress.contextPath + "/plugins/brikit/theme/remove.action", 
                    {themeName: themeName}, 
					function () { ThemePress.Designer.messageUser("Theme removed", true); });
			};
			
			ThemePress.Dialog2.doubleConfirm("<p>Delete the <strong>" + themeName + "</strong> theme?</p>", { title: "Delete Theme", doubleConfirmMessage: "I understand this action is permanent." }, proceedCallback);
			return false;
		},

		reopenFieldsets: function () {
			if (ThemePress.Designer.isThemeMode()) ThemePress.Designer.reopenFieldsets(ThemePress.ThemeTab.focusedElementToggle());
		},
		
		resizeDesigner: function () {
			if (ThemePress.Designer.isThemeMode()) ThemePress.Designer.resizeDesigner();
		},
		
		resetProperty: function ($field, value, data, needsPageReload) {
			// Don't send a message telling the user what field they just changed, but do invoke the user message
			// in case they need to be alerted about a page refresh need
			var message = data.manual ? false :
						data.whatHappened + " " + $field.attr("name") + " to: " + (value ? value : "<cleared>");
			ThemePress.Designer.messageUser(message, needsPageReload);

			// Stop if the user changed the field manually
			if (data.manual) return;
			
			if ($field.hasClass("checkbox")) $field.adjustAttr("checked", "checked", "on" == value);
			else if (typeof(value) != "undefined") {
				if ($field.hasClass("color")) {
					var valueBeforeNaming = value;
					if (!$field.data("palette")) value = ThemePress.html.toNamedColor(value);
					$field.val(value);
					$field.setBackgroundColor(valueBeforeNaming && valueBeforeNaming.length ? valueBeforeNaming : "transparent");
				}
				else {
					$field.val(value);
				}
			}
			else $field.val("");

		},
		
		saveDeveloperExternalLocation: function () {
            ThemePress.post(ThemePress.contextPath + "/plugins/brikit/theme/setdevelopmentdirectory.action", {externalLocation: $(this).val()}, ThemePress.Designer.forceReload);
			return false;
		},

		saveOpenFieldsets: function () {
			if (ThemePress.Designer.isThemeMode()) ThemePress.Designer.saveOpenFieldsets(ThemePress.ThemeTab.focusedElementToggle());
		},
		
		saveFocusState: function (selector) {
			// Lose focus state after 60 minutes 
			ThemePress.cookie(ThemePress.ThemeTab.designerFocusCookie, selector, 60);
		},
		
		scrollToFocusedAccordion: function () {
			if (ThemePress.ThemeTab.focusState()) ThemePress.Designer.designableElements(ThemePress.ThemeTab.focusState()).scrollToBeVisible(ThemePress.Designer.designerHolder());
		},
		
		// Return the name of the theme selected in the manage themes panel (if showing)
		selectedTheme: function () {
			return $(".theme-list .selected").data("theme") || ThemePress.currentTheme();
		},
		
		setTheme: function (themeName, spaceOnly) {
            const data = { pageId: ThemePress.pageId, themeName: themeName, useSiteTheme: !spaceOnly };
            ThemePress.post(ThemePress.contextPath + "/plugins/brikit/theme/settheme.action", data, ThemePress.reloadBrowser);
		},
		
		structureDidChange: function ($changedElement) {
			$.each(ThemePress.ThemeTab.designableElementSelectors, function (index, selector) {
				ThemePress.Designer.designableElements(selector).adjustClass("invisible", $(selector).isHidden());
			});
		},
		
		themeChanged: function (event) {
			var themeName = ThemePress.ThemeTab.themeSelector().find("option:selected").val();
			location.href = ThemePress.contextPath + "/plugins/brikit/designer/"
			return false;
		},

		themeManager: function () {
			AJS.InlineDialog(
				$(this), 
				"themePreview",
				ThemePress.contextPath + "/plugins/brikit/theme/thememanager.action" + ThemePress.atlTokenParam(), 
				{
					onHover: false, 
					width: 400, 
					arrowOffsetX: 8,
					offsetX: -10,
					showDelay: 0, 
					initCallback: ThemePress.ThemeTab.themeManagerInit
				}
			);
		},

		themeManagerInit: function () {
			var $popup = $(this.popup);
			$popup.css({zIndex: 2999});

			// Make the tooltips use the fancy AUI decoration
			$(".image, a", $popup).tooltip({aria:true});

			// Zap the "remove" icons from the current theme
			$(".theme-list .image.current .remove").remove();

			// Wire the "remove" icons
			$(".theme-list .image").on("click", ".remove", ThemePress.ThemeTab.removeTheme);
			
			// Wire the theme icons to change the current theme
			$(".theme-list").on("click", ".image", ThemePress.ThemeTab.themeManagerSelection);
			
			$(".manage-themes .copy").click(ThemePress.ThemeTab.copyTheme);
			$(".manage-themes .download").click(ThemePress.ThemeTab.downloadTheme);
			
			$(".theme-list .group-multi-select").initializeGroupMultiSelect().each(function () {
				$(this).data("properties", { themeName: $(this).closest(".theme-link").data("theme") });
			});

			ThemePress.ThemeTab.themeUploaderInit($popup);
		},
		
		themeManagerSelection: function (event) {
			var themeLink = $(this);
			themeLink.closest(".theme-list").find(".selected").removeClass("selected");
			themeLink.addClass("selected");
			
			$(".theme-inspector img")
				.attr("src", themeLink.data("logo-src"))
				.attr("height", themeLink.data("logo-height"))
				.attr("width", themeLink.data("logo-width"))
				.show();
			$(".theme-inspector .description").html(themeLink.data("theme"));
			
			var $accessPanel = $("#theme-permissions-panel");
			var $oldPermissions = $(".theme-permissions", $accessPanel);
			if ($oldPermissions.length) {
				$(".theme-list .theme-link[data-theme='" + $oldPermissions.data("theme") + "']").append($oldPermissions.hide());
			}
			var $newPermissions = $(".theme-permissions", themeLink);
			$accessPanel.append($newPermissions.show());
			$("#theme-permissions-panel").show();

			return false;
		},
		
		themePreview: function () {
			var currentTheme = $(this).data("theme");
			var canEdit = $(this).closest(".theme-tab").length ? "&canEdit=true" : "";
			AJS.InlineDialog(
				$(this), 
				"themePreview",
				ThemePress.contextPath + "/plugins/brikit/theme/themechooser.action?key=" + encodeURIComponent(ThemePress.spaceKey) +
					"&pageId=" + ThemePress.pageId + "&themeName=" + encodeURIComponent(currentTheme) + canEdit + ThemePress.atlTokenParam(true), 
				{
					onHover: false, 
					width: 400, 
					arrowOffsetX: 8,
					offsetX: -10,
					showDelay: 0, 
					initCallback: ThemePress.ThemeTab.themePreviewInit
				}
			);
		},

		themePreviewInit: function () {
			var $popup = $(this.popup);
			$popup.css({zIndex: 2999});

			// Make the tooltips use the fancy AUI decoration
			$(".image, a", $popup).tooltip({aria:true});

			// Wire the theme icons to change the current theme
			$(".theme-list .image").not(".current").click(ThemePress.ThemeTab.changeTheme);
		},
		
		themeSelector: function () {
			return ThemePress.Designer.designer("#brikitThemeName");
		},
		
		themeUploaderInit: function ($popup) {
			// Make the upload button trigger the hidden file upload form
			$(".manage-themes .upload").click(function () {
				$("form.uploader .upfile").val("").click();
				return false;
			});

			// When the file upload filename changes, automagically upload and apply the file to the current image field
			$("form.uploader .upfile", $popup).change(function () { 
				// On submission of the theme uploader, confirm before firing
				var $form = $(this).closest("form.uploader");
				var fileName = $("form.uploader .upfile").val().split('\\').pop();
				if (!ThemePress.endsWith(fileName, ".zip")) {
					ThemePress.Dialog2.alert("<p>Only .zip files can be themes.</p>", { title: "Invalid File Type" });
					return false;
				}
				ThemePress.Dialog2.confirm("<p>Upload the theme contained in <strong>" + fileName + "</strong>?</p><p>This action will <u>not</u> change the site theme.</p>", { title: "Upload Theme" }, function (dialog) {
					dialog.hide();
					$form.submit();
				});
				return false;
			});
			
			// On submission of the theme uploader, check server response for errors
			// Make the file upload form work via ajax (using the jquery.form plugin)
			$("form.uploader", $popup).ajaxForm(function (result) {
				if ($(result).hasClass("errorMessage")) ThemePress.Dialog2.alert(result, { title: "Error Uploading Theme" });
				else ThemePress.Designer.reloadDesigner();
			});
		},
		
		toggleDeveloperMode: function () {
			var $previousSelection = ThemePress.Designer.designer(".brikit-developer-selector .aui-button[aria-pressed='true']");
			if ($(this).attr("aria-pressed")) return false;
			ThemePress.Designer.designer(".brikit-developer-selector .aui-button").removeAttr("aria-pressed");
			$(this).attr("aria-pressed", "true");
			ThemePress.post(ThemePress.contextPath + "/plugins/brikit/theme/" + $(this).data("mode") + "developer.action", {}, ThemePress.Designer.forceReload);
			return false;
		},
	
		toggleThemeDesigner: function () {
			var $previousSelection = ThemePress.Designer.designer(".theme-designer-selector .aui-button[aria-pressed='true']");
			if ($(this).attr("aria-pressed")) return false;
			ThemePress.Designer.designer(".theme-designer-selector .aui-button").removeAttr("aria-pressed");
			$(this).attr("aria-pressed", "true");
			
			if ($(this).data("caches") == "enable") {
				ThemePress.post(ThemePress.contextPath + "/plugins/brikit/theme/enablecaches.action", {}, ThemePress.Designer.forceReload);
			}
			else {
				var message = "<p><span class='aui-icon aui-icon-warning'>Warning</span> When enabled, Theme Press recalculates look-and-feel information after each change in the Theme Designer (and when doing a force-reload in most browsers).</p><p>These recalculations add to the performance load on the server.</p><p>For this reason, only enable Theme Designer in a test or development environment, not in production.</p>";

				var cancelCallback = function (dialog) {
					ThemePress.Designer.designer(".theme-designer-selector .aui-button").removeAttr("aria-pressed");
					$previousSelection.attr("aria-pressed", "true");
				};

				var proceedCallback = function (dialog) {
					ThemePress.post(ThemePress.contextPath + "/plugins/brikit/theme/disablecaches.action", {}, ThemePress.Designer.forceReload);
				};

				ThemePress.Dialog2.doubleConfirm(message, { title: "Enable Theme Designer" }, proceedCallback, cancelCallback);
			}
			return false;
		},
	
		undoButton: function () {
			return $("#appheader-frame a.undo");
		},
		
		undoChange: function () {
			ThemePress.ThemeTab.ajaxDesignerCall("undo", { themeName: ThemePress.currentTheme() });
			return false;
		},
		
		// Keep watching the focused element for size changes, etc. (can happen asynchronously as CSS reloads happen)
		updateDisplayLoop: function () {
			if (ThemePress.Designer.updateLoopInterval) clearInterval(ThemePress.Designer.updateLoopInterval);
			ThemePress.Designer.updateCount = 10;
			ThemePress.Designer.updateLoopInterval = setInterval( function () {
				ThemePress.ThemeTab.structureDidChange();
				ThemePress.Structure.structureDidChange();
				ThemePress.Focus.showFocusBlanket();
				ThemePress.Designer.updateCount -= 1;
				if (ThemePress.Designer.updateCount < 0) clearInterval(ThemePress.Designer.updateLoopInterval);
			}, 500);
		},
	
		// Update the menu items, using the JSON blobs undo and redo returned from the server during the last property update
		updateUndoRedoMenuItems: function (undo, redo) {
			var undoProperty = undo && Object.keys($.parseJSON(undo)).length ? Object.keys($.parseJSON(undo))[0] : false;
			var redoProperty = redo && Object.keys($.parseJSON(redo)).length ? Object.keys($.parseJSON(redo))[0] : false;
			ThemePress.ThemeTab.undoButton().adjustClass("disabled", !undoProperty).adjustAttr("disabled", "disabled", !undoProperty).attr("title", (undoProperty ? "Undo " + ThemePress.Designer.labelFor(undoProperty) + " (^u)" : "No Changes"));
			ThemePress.ThemeTab.redoButton().adjustClass("disabled", !redoProperty).adjustAttr("disabled", "disabled", !redoProperty).attr("title", (redoProperty ? "Redo " + ThemePress.Designer.labelFor(redoProperty) + " (^U)" : "No Changes"));
			ThemePress.ThemeTab.designerModeDidChange();
		},
		
		updateUndoStackStatus: function () {
			ThemePress.ThemeTab.ajaxDesignerCall("undostatus", { themeName: ThemePress.currentTheme() });
		}
		
	};
	
	ThemePress.toInit(function ($) {
		ThemePress.registerCookie(ThemePress.ThemeTab.designerFocusCookie);	
	});

	ThemePress.toFinalize(function ($) {		
		ThemePress.Events.addCallback("designerModeWillChange", ThemePress.ThemeTab.designerModeWillChange);
		ThemePress.Events.addCallback("structureDidChange", ThemePress.ThemeTab.structureDidChange);
		ThemePress.Events.addCallback("designerModeDidChange", ThemePress.ThemeTab.designerModeDidChange);
		ThemePress.Events.addCallback("accordionDidToggle", ThemePress.ThemeTab.reopenFieldsets);
		ThemePress.Events.addCallback("accordionDidToggle fieldsetContainerToggled", ThemePress.ThemeTab.saveOpenFieldsets);
		ThemePress.Events.addCallback("accordionDidToggle fieldsetContainerToggled", ThemePress.ThemeTab.autoSizeTextareas);
		ThemePress.Events.addCallback("fieldsetContainerToggled", ThemePress.ThemeTab.resizeDesigner);
	});

})(jQuery);
