/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.model;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.core.util.BrikitZipFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.activation.FileDataSource;

public class SpaceExporter {
    public static final String ZIP_FILE_EXT = ".zip";
    public static final String JSON_FILE_EXT = ".json";
    public static final String XML_FILE_EXT = ".xml";
    public static final String SPACE_JSON_FILE = "space.json";
    public static final String ATTACHMENTS_DIR = "attachments";
    public static final String SPACE_KEY_KEY = "spaceKey";
    public static final String SPACE_NAME_KEY = "spaceName";
    public static final String SPACE_DESCRIPTION_KEY = "spaceDescription";
    public static final String PAGE_ID_KEY = "pageId";
    public static final String PARENT_PAGE_TITLE_KEY = "parentPageTitle";
    public static final String POST_DATE_KEY = "postDate";
    public static final String TYPE_KEY = "type";
    public static final String TITLE_KEY = "title";
    public static final String LABELS_KEY = "labels";
    public static final String COMMENT_KEY = "comment";
    public static final String METADATA_KEY = "metadata";
    public static final String RESTRICTIONS_KEY = "restrictions";
    public static final String VIEW_USERS_KEY = "viewUsers";
    public static final String EDIT_USERS_KEY = "editUsers";
    public static final String VIEW_GROUPS_KEY = "viewGroups";
    public static final String EDIT_GROUPS_KEY = "editGroups";
    protected String exportName;
    protected File zipFile;
    protected File exportFolder;
    protected File spaceDetailsFile;
    protected boolean includePermissions;
    protected Space space;

    public SpaceExporter(File zipFile, Space existingSpace, boolean includePermissions, String exportName) {
        this.space = existingSpace;
        this.includePermissions = includePermissions;
        this.exportName = exportName;
        this.unpackZipFile(zipFile);
    }

    protected void createPage(File pageDir, boolean overwriteExisting) throws Exception {
        Page abstractPage;
        Page homePage = Confluence.getSpaceHomePage((Space)this.getSpace());
        File pageMeta = new File(pageDir, pageDir.getName() + JSON_FILE_EXT);
        File xmlFile = new File(pageDir, pageDir.getName() + XML_FILE_EXT);
        if (!pageMeta.exists() || !xmlFile.exists()) {
            BrikitLog.logWarning((String)("Unable to find metadata or content for page: " + pageDir.getName() + ". Ignoring page."));
            return;
        }
        JSONObject pageJSON = new JSONObject(BrikitFile.readFileUTF8((File)pageMeta));
        String title = pageJSON.getString(TITLE_KEY);
        String type = pageJSON.has(TYPE_KEY) ? pageJSON.getString(TYPE_KEY) : "page";
        boolean isPage = "page".equals(type);
        Date postDate = pageJSON.has(POST_DATE_KEY) ? BrikitDate.parseDate((String)"yyyy-MM-dd", (String)pageJSON.getString(POST_DATE_KEY), (TimeZone)Confluence.getSystemTimeZone()) : new Date();
        String parentPageTitle = pageJSON.has(PARENT_PAGE_TITLE_KEY) ? pageJSON.getString(PARENT_PAGE_TITLE_KEY) : null;
        Object object = abstractPage = isPage ? Confluence.getPage((Space)this.getSpace(), (String)title) : Confluence.getBlogPost((String)this.getSpace().getKey(), (String)title, (Date)postDate);
        if (!overwriteExisting && abstractPage != null) {
            return;
        }
        String storageFormat = BrikitFile.readFileUTF8((File)xmlFile);
        if (abstractPage == null) {
            Calendar createDate = BrikitDate.toCalendar((Date)postDate);
            if (isPage) {
                Page parentPage = BrikitString.isSet((String)parentPageTitle) ? Confluence.getPage((Space)this.getSpace(), (String)parentPageTitle) : null;
                abstractPage = Confluence.createPage((Space)this.getSpace(), (String)title, (String)storageFormat, (boolean)false, (Page)parentPage, (Calendar)createDate);
            } else {
                abstractPage = Confluence.createBlogPost((Space)this.getSpace(), (String)title, (String)storageFormat, (Calendar)createDate, (Calendar)Confluence.getSystemTimeNow());
            }
        } else {
            Confluence.savePage((AbstractPage)abstractPage, (String)storageFormat, (String)"Imported from space export", (boolean)false, (boolean)false);
        }
        String labelString = pageJSON.getString(LABELS_KEY);
        Confluence.syncLabels((AbstractPage)abstractPage, (String)labelString);
        if (pageJSON.has(METADATA_KEY)) {
            Confluence.applyPageMetadata((JSONArray)pageJSON.getJSONArray(METADATA_KEY), (AbstractPage)abstractPage);
        }
        if (this.shouldIncludePermissions()) {
            JSONObject restrictionsJSON = pageJSON.getJSONObject(RESTRICTIONS_KEY);
            String viewUsers = restrictionsJSON.has(VIEW_USERS_KEY) ? restrictionsJSON.getString(VIEW_USERS_KEY) : "";
            String editUsers = restrictionsJSON.has(EDIT_USERS_KEY) ? restrictionsJSON.getString(EDIT_USERS_KEY) : "";
            String viewGroups = restrictionsJSON.has(VIEW_GROUPS_KEY) ? restrictionsJSON.getString(VIEW_GROUPS_KEY) : "";
            String editGroups = restrictionsJSON.has(EDIT_GROUPS_KEY) ? restrictionsJSON.getString(EDIT_GROUPS_KEY) : "";
            Confluence.syncViewPermissionsUsers((AbstractPage)abstractPage, (List)BrikitList.fromJsonString((String)viewUsers));
            Confluence.syncEditPermissionsUsers((AbstractPage)abstractPage, (List)BrikitList.fromJsonString((String)editUsers));
            Confluence.syncViewPermissionsGroups((AbstractPage)abstractPage, (List)BrikitList.fromJsonString((String)viewGroups));
            Confluence.syncEditPermissionsGroups((AbstractPage)abstractPage, (List)BrikitList.fromJsonString((String)editGroups));
        }
        this.handleAttachments(pageDir, (AbstractPage)abstractPage);
    }

    protected void createOrUpdateSpace() throws Exception {
        JSONObject spaceJSON = new JSONObject(BrikitFile.readFileUTF8((File)this.getSpaceDetailsFile()));
        String spaceKey = spaceJSON.getString(SPACE_KEY_KEY);
        this.space = Confluence.getSpace((String)spaceKey);
        if (this.space != null) {
            BrikitLog.log((String)("Space importer called to create or update space, which already exists: " + spaceKey));
        }
        String spaceName = spaceJSON.getString(SPACE_NAME_KEY);
        String spaceDescription = spaceJSON.getString(SPACE_DESCRIPTION_KEY);
        if (this.space == null) {
            this.space = Confluence.createSpace((String)spaceKey, (String)spaceName, (String)spaceDescription, (boolean)false);
        }
        String labelString = spaceJSON.getString(LABELS_KEY);
        Confluence.addSpaceLabels((List)BrikitString.splitCommaSeparated((String)labelString), (Space)this.space);
        if (spaceJSON.has(METADATA_KEY)) {
            Confluence.applySpaceMetadata((JSONArray)spaceJSON.getJSONArray(METADATA_KEY), (Space)this.space);
        }
    }

    public void exportSpace() throws Exception {
        this.initializeExport();
        this.exportSpaceDetails(this.getSpace());
        for (Page page : Confluence.getPermittedChildren((Space)this.getSpace())) {
            this.exportPage((AbstractPage)page, true, null);
        }
        for (BlogPost blogpost : Confluence.getAllBlogPosts((Space)this.getSpace())) {
            this.exportPage((AbstractPage)blogpost, false, null);
        }
        this.finalizeExport();
    }

    protected void exportPage(AbstractPage abstractPage, boolean includeChildren, File pageDir) throws IOException {
        if (pageDir == null) {
            pageDir = new File(this.getExportFolder(), abstractPage.getIdAsString());
        }
        BrikitFile.ensurePathExists((File)pageDir);
        JSONObject json = this.pageDetails(abstractPage);
        File jsonFile = new File(pageDir, abstractPage.getIdAsString() + JSON_FILE_EXT);
        BrikitFile.writeFileUTF8((String)json.toString(), (File)jsonFile);
        this.writeStorageFormat(abstractPage, pageDir);
        this.writeAttachments(abstractPage, pageDir);
        if (includeChildren && Confluence.isPage((AbstractPage)abstractPage)) {
            for (Page child : Confluence.getPermittedChildren((Page)((Page)abstractPage))) {
                this.exportPage((AbstractPage)child, includeChildren, new File(pageDir, child.getIdAsString()));
            }
        }
    }

    public void exportPages(List<String> titles) throws Exception {
        this.initializeExport();
        for (String title : titles) {
            Page page = Confluence.getPage((Space)this.getSpace(), (String)title);
            this.exportPage((AbstractPage)page, false, null);
        }
        this.finalizeExport();
    }

    protected void exportSpaceDetails(Space space) throws IOException {
        JSONObject json = this.spaceDetails(space);
        File jsonFile = new File(this.getExportFolder(), SPACE_JSON_FILE);
        BrikitFile.writeFileUTF8((String)json.toString(), (File)jsonFile);
    }

    protected void finalizeExport() throws Exception {
        BrikitZipFile.createZipFile((File)this.getExportFolder(), (File)this.getZipFile());
        BrikitFile.removeFile((File)this.getExportFolder());
    }

    protected JSONObject generateAttachmentDetails(Attachment attachment) {
        String comment = Confluence.getComment((Attachment)attachment);
        String labels = Confluence.getLabelString((Attachment)attachment);
        if (!BrikitString.isSet((String)comment) && !BrikitString.isSet((String)labels)) {
            return null;
        }
        JSONObject json = new JSONObject();
        json.put(COMMENT_KEY, (Object)comment);
        json.put(LABELS_KEY, (Object)labels);
        return json;
    }

    protected File getExportFolder() {
        if (this.exportFolder == null) {
            this.exportFolder = BrikitFile.getBrikitFile((String)this.getExportName());
        }
        return this.exportFolder;
    }

    public String getExportName() {
        return this.exportName;
    }

    public Space getSpace() {
        return this.space;
    }

    protected File getSpaceDetailsFile() {
        if (this.spaceDetailsFile == null) {
            this.spaceDetailsFile = new File(this.getExportFolder(), SPACE_JSON_FILE);
        }
        return this.spaceDetailsFile;
    }

    public File getZipFile() {
        if (this.zipFile == null) {
            this.zipFile = BrikitFile.getConfluenceTempDirectoryPath((String)(this.getExportName() + ZIP_FILE_EXT));
        }
        return this.zipFile;
    }

    protected void handleAttachmentMeta(File attachmentsDir, File attachFile, Attachment attachment) throws Exception {
        String comment;
        File attachmentMeta = new File(attachmentsDir, attachFile.getName() + JSON_FILE_EXT);
        if (!attachmentMeta.exists()) {
            return;
        }
        JSONObject attachmentJSON = new JSONObject(BrikitFile.readFileUTF8((File)attachmentMeta));
        String labelsString = attachmentJSON.getString(LABELS_KEY);
        if (BrikitString.isSet((String)labelsString)) {
            Confluence.syncLabels((Attachment)attachment, (String)labelsString);
        }
        if (BrikitString.isSet((String)(comment = attachmentJSON.getString(COMMENT_KEY)))) {
            Confluence.setComment((Attachment)attachment, (String)comment);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleAttachments(File pageDir, AbstractPage newPage) throws Exception {
        File attachmentsDir = new File(pageDir, ATTACHMENTS_DIR);
        if (attachmentsDir.exists()) {
            for (File attachFile : attachmentsDir.listFiles()) {
                if (attachFile.getName().endsWith(JSON_FILE_EXT)) continue;
                FileDataSource ds = new FileDataSource(attachFile.getAbsolutePath());
                Attachment attachment = Confluence.getAttachment((AbstractPage)newPage, (String)attachFile.getName());
                Attachment previousVersion = null;
                if (attachment == null) {
                    attachment = new Attachment(attachFile.getName(), ds.getContentType(), attachFile.length(), null);
                } else {
                    previousVersion = (Attachment)attachment.clone();
                }
                newPage.addAttachment(attachment);
                try (InputStream inputStream = ds.getInputStream();){
                    Confluence.getAttachmentManager().saveAttachment(attachment, previousVersion, inputStream);
                }
                this.handleAttachmentMeta(attachmentsDir, attachFile, attachment);
            }
        }
    }

    public void importSpace(boolean overwriteExisting) throws Exception {
        if (this.getSpaceDetailsFile().exists()) {
            this.createOrUpdateSpace();
        }
        this.importPagesInDirectory(this.getExportFolder(), overwriteExisting);
    }

    protected void importPagesInDirectory(File directory, boolean overwriteExisting) throws Exception {
        for (File pageDir : directory.listFiles()) {
            if (!pageDir.isDirectory() || ATTACHMENTS_DIR.equals(pageDir.getName())) continue;
            this.createPage(pageDir, overwriteExisting);
            this.importPagesInDirectory(pageDir, overwriteExisting);
        }
    }

    protected void initializeExport() throws IOException {
        BrikitFile.removeFile((File)this.getZipFile());
        BrikitFile.removeFile((File)this.getExportFolder());
        BrikitFile.ensurePathExists((File)this.getExportFolder());
    }

    protected JSONObject pageDetails(AbstractPage abstractPage) {
        Page parentPage;
        JSONObject json = new JSONObject();
        json.put(PAGE_ID_KEY, abstractPage.getId());
        if (Confluence.isPage((AbstractPage)abstractPage) && (parentPage = Confluence.getParent((Page)((Page)abstractPage))) != null) {
            json.put(PARENT_PAGE_TITLE_KEY, (Object)Confluence.getTitle((AbstractPage)parentPage));
        }
        json.put(TYPE_KEY, (Object)abstractPage.getType());
        json.put(POST_DATE_KEY, (Object)BrikitDate.formatDateTime((Date)abstractPage.getCreationDate(), (TimeZone)Confluence.getSystemTimeZone(), (String)"yyyy-MM-dd", (boolean)true));
        json.put(TITLE_KEY, (Object)abstractPage.getTitle());
        json.put(LABELS_KEY, (Object)Confluence.getLabelString((AbstractPage)abstractPage));
        json.put(METADATA_KEY, (Object)Confluence.getPageMetadata((AbstractPage)abstractPage, Arrays.asList("com.brikit.*")));
        if (this.shouldIncludePermissions()) {
            JSONObject restrictions = new JSONObject();
            restrictions.put(VIEW_USERS_KEY, (Object)Confluence.getViewPermissionsUserString((AbstractPage)abstractPage));
            restrictions.put(EDIT_USERS_KEY, (Object)Confluence.getEditPermissionsUserString((AbstractPage)abstractPage));
            restrictions.put(VIEW_GROUPS_KEY, (Object)Confluence.getViewPermissionsGroupString((AbstractPage)abstractPage));
            restrictions.put(EDIT_GROUPS_KEY, (Object)Confluence.getEditPermissionsGroupString((AbstractPage)abstractPage));
            json.put(RESTRICTIONS_KEY, (Object)restrictions);
        }
        return json;
    }

    public boolean shouldIncludePermissions() {
        return this.includePermissions;
    }

    protected JSONObject spaceDetails(Space space) {
        JSONObject json = new JSONObject();
        json.put(SPACE_KEY_KEY, (Object)space.getKey());
        json.put(SPACE_NAME_KEY, (Object)Confluence.getSpaceName((String)space.getKey()));
        json.put(SPACE_DESCRIPTION_KEY, (Object)Confluence.getSpaceDescription((String)space.getKey()));
        json.put(LABELS_KEY, (Object)Confluence.getLabelString((Space)space));
        json.put(METADATA_KEY, (Object)Confluence.getSpaceMetadata((Space)space, Arrays.asList("atlassian.confluence.*", "com.brikit.*")));
        return json;
    }

    protected void unpackZipFile(File zipFile) {
        BrikitFile.removeFile((File)this.getExportFolder());
        if (zipFile == null) {
            return;
        }
        try {
            BrikitZipFile zip = new BrikitZipFile(zipFile, this.getExportFolder());
            zip.extractAll();
        }
        catch (Exception ex) {
            BrikitLog.logError((String)("Unable to read zip file:" + zipFile), (Exception)ex);
        }
    }

    protected void writeAttachments(AbstractPage aPage, File destinationDir) throws IOException {
        File attachmentDirectory = new File(destinationDir, ATTACHMENTS_DIR);
        List attachments = Confluence.getAttachments((AbstractPage)aPage);
        if (!attachments.isEmpty()) {
            BrikitFile.ensurePathExists((File)attachmentDirectory);
            for (Attachment attachment : Confluence.getAttachments((AbstractPage)aPage)) {
                File outputFile = new File(attachmentDirectory, attachment.getFileName());
                InputStream inputStream = Confluence.getAttachmentManager().getAttachmentData(attachment);
                if (inputStream == null) {
                    BrikitLog.logWarning((String)("Couldn't find attachment during export: " + attachment + " on page: " + aPage));
                    continue;
                }
                BrikitFile.writeInputStream((InputStream)inputStream, (File)outputFile);
                JSONObject json = this.generateAttachmentDetails(attachment);
                if (json == null) continue;
                File jsonFile = new File(attachmentDirectory, attachment.getFileName() + JSON_FILE_EXT);
                BrikitFile.writeFileUTF8((String)json.toString(), (File)jsonFile);
            }
        }
    }

    protected void writeStorageFormat(AbstractPage aPage, File destinationDir) throws IOException {
        File outputFile = new File(destinationDir, aPage.getIdAsString() + XML_FILE_EXT);
        BrikitFile.writeFileUTF8((String)Confluence.getBodyAsString((ContentEntityObject)aPage), (File)outputFile);
    }
}

