(function ($) { 

	ThemePress.RotateContentAnimations = {
		
		fade: function (wrapper, oldBlock, newBlock, callback) {
			oldBlock.fadeOut("slow", function() {
				newBlock.fadeIn("slow", callback); 
			});
		},
	
		instant: function (wrapper, oldBlock, newBlock, callback) {
			oldBlock.hide();
			newBlock.show();
			callback();
		},
	
		scrollDown: function (wrapper, oldBlock, newBlock, callback) {
			var newTop = parseInt(oldBlock.css("top")) + oldBlock.outerHeight();
			newBlock.css({top: newTop}).show();
			wrapper.animate({"top": -newTop + "px"}, "slow", callback);
		},

		scrollLeft: function (wrapper, oldBlock, newBlock, callback) {
			var newLeft = parseInt(oldBlock.css("left")) - oldBlock.outerWidth();
			newBlock.css({left: newLeft}).show();
			wrapper.animate({"left": -newLeft + "px"}, "slow", callback);
		},

		scrollRight: function (wrapper, oldBlock, newBlock, callback) {
			var newLeft = parseInt(oldBlock.css("left")) + oldBlock.outerWidth();
			newBlock.css({left: newLeft}).show();
			wrapper.animate({"left": -newLeft + "px"}, "slow", callback);
		},

		scrollUp: function (wrapper, oldBlock, newBlock, callback) {
			var newTop = parseInt(oldBlock.css("top")) - oldBlock.outerHeight();
			newBlock.css({top: newTop}).show();
			wrapper.animate({"top": -newTop + "px"}, "slow", callback);
		}

	};
	
	ThemePress.RotateContentAnimations.slideDown = ThemePress.RotateContentAnimations.scrollUp;
	ThemePress.RotateContentAnimations.slideUp = ThemePress.RotateContentAnimations.scrollDown;
	ThemePress.RotateContentAnimations.slideLeft = ThemePress.RotateContentAnimations.scrollRight;
	ThemePress.RotateContentAnimations.slideRight = ThemePress.RotateContentAnimations.scrollLeft;
	
	ThemePress.RotateContent = {
	
		busy: false,
		pause: false,
		animationFunction: false,
		timeouts: [],
	
		animateNext: function (element) {
			if (ThemePress.RotateContent.isManual(element)) return;
			
			ThemePress.RotateContent.updateControlSelection(element);
			ThemePress.RotateContent.schedule(function() { ThemePress.RotateContent.rotateContent(element); }, ThemePress.RotateContent.delay(element));
		},
		
		// Call the animation function on rotateContentElement to display the block (or the block with blockOrBlockId)
		animateToDisplayBlock: function (rotateContentElement, blockOrBlockId, animation) {
			if (typeof(blockOrBlockId) == "number") blockOrBlockId = ThemePress.RotateContent.blockWithId(rotateContentElement, blockOrBlockId);
			animation = animation || ThemePress.RotateContent.animation(rotateContentElement);
			var wrapper = rotateContentElement.find(".animation-wrapper");
			var oldBlock = ThemePress.RotateContent.currentBlock(rotateContentElement);
			var newBlock = blockOrBlockId;
			animation.call(this, wrapper, oldBlock, newBlock, function () {
				oldBlock.removeClass("showing");
				newBlock.addClass("showing");
				ThemePress.RotateContent.animateNext(rotateContentElement);
			});
		},

		// Return the animation function relevant to rotateContentElement
		animation: function (rotateContentElement) {
			if (!ThemePress.RotateContent.animationFunction) {
				var animation = rotateContentElement.data("animation") || "fade";
				ThemePress.RotateContent.animationFunction = ThemePress.RotateContentAnimations[animation];
			}
			return ThemePress.RotateContent.animationFunction;
		},
		
		blockWithId: function (rotateContentElement, blockId) {
			return rotateContentElement.find(".brikit-content-block[data-content-block='" + blockId + "']");
		},
		
		// Return the block that's currently showing
		currentBlock: function (element) {
			return $(element).find(".brikit-content-block.showing");
		},

		// Return the id of the block that's currently showing
		currentBlockId: function (element) {
			return ThemePress.RotateContent.currentBlock(element).data("content-block");
		},

		// Get element's attribute for the delay, or "data-delay" if not specified. Defaults to six seconds if no delay is found.
		delay: function (element, attribute) {
			var delay = element.attr(attribute || "data-delay");
			return typeof(delay) == "undefined" || !delay || delay == 0 ? 6000 : delay;
		},
	
		enableAnimations: function () {
			jQuery.fx.off = false;
		},
		
		initialize: function (element) {
			var blocks = $(".brikit-content-block", element);
			var containingBlock = element.closest(".brikit-content-block");
			var height = containingBlock.height();
			element.height(height);
			var width = containingBlock.width();
            var closestContainer = function () { return containingBlock.closest(".brikit-content-column, .brikit-content-layer, .brikit-content-layers"); }
            while (width == 0 && closestContainer().length) {
                containingBlock = closestContainer();
                width = containingBlock.width();
            }
			blocks.outerHeight(height).outerWidth(width).css({
				position: "absolute", top: 0, left: 0, margin: "0"
			}).hide();
			var choice = element.data("nonRandom") ? 0 : Math.floor(Math.random() * blocks.length);
			$(blocks.get(choice)).addClass("showing").show();
		},

		initializeControls: function (element) {
			var $controls = element.next(".rotate-content-control");
			$controls.find("li").click(ThemePress.RotateContent.selectBlock);
			ThemePress.RotateContent.updateControlSelection(element);
			
			$("." + element.attr("id") + ".rotate-content-scroll-button").click(ThemePress.RotateContent.moveBlock);
			
			// Pause animation when mouse is over rotating container or the controls
			if (!ThemePress.RotateContent.isManual(element)) {
				element.hover(ThemePress.RotateContent.pauseAnimations, ThemePress.RotateContent.resumeAnimations);
				$controls.hover(ThemePress.RotateContent.pauseAnimations, ThemePress.RotateContent.resumeAnimations);
			}
		},
		
		isManual: function (rotateContentElement) {
			return $(".rotate-content-scroll-button." + rotateContentElement.attr("id")).length;
		},
    
		isSequential: function (rotateContentElement) {
			return rotateContentElement.data("non-random");
		},
    
		// Move to the block before or after the one that's currently showing, depending on which button was clicked
		moveBlock: function () {
			var $element = $("#" + $(this).data("element"));
			var $current = ThemePress.RotateContent.currentBlock($element);
			var $next, animation;
			if ($(this).hasClass("right")) {
				$next = $current.next(".brikit-content-block").length ? $current.next(".brikit-content-block") : $(".brikit-content-block", $element).first();
				animation = ThemePress.RotateContentAnimations.scrollRight;
			}
			else {
				$next = $current.prev(".brikit-content-block").length ? $current.prev(".brikit-content-block") : $(".brikit-content-block", $element).last();
				animation = ThemePress.RotateContentAnimations.scrollLeft;
			}

			ThemePress.RotateContent.rotateContent($element, $next, animation);
		},

		pauseAnimations: function () {
			ThemePress.RotateContent.pause = true;
		},
	
		resumeAnimations: function () {
			ThemePress.RotateContent.pause = false;
		},
	
	    rotateContent: function (element, $next, animation) {
			element = $(element);
			
			var elementId = element.attr("id");
			
			// PRESS-1945: If the mobile menu is showing, animation sizing goes nuts, so wait and try again
			if ($("html.mobile-menu-active").length) return setTimeout(function() {ThemePress.RotateContent.rotateContent(element, $next, animation);}, 1000);
			
			// Wait a bit for previous call to finish to avoid collisions (ZEN-1023)
			if (ThemePress.RotateContent.busy || ThemePress.RotateContent.pause) return setTimeout(function() {ThemePress.RotateContent.rotateContent(element, $next, animation);}, 100);
			else ThemePress.RotateContent.busy = true;

			// Remove the highlight from the controls while in transition
			$("#" + elementId + "-control .selected").removeClass("selected");
			
			// Animation names a function that does the animation
			var $old = ThemePress.RotateContent.currentBlock(element);
			var oldId = ThemePress.RotateContent.currentBlockId(element);
			
			if (!$next) {
				if (ThemePress.RotateContent.isSequential(element)) {
					$next = element.find(".brikit-content-block.showing").next(".brikit-content-block");
					if (!$next.length) $next = element.find(".brikit-content-block").first();
				}
				else {
					var newId = oldId;
					var $blocks = element.find(".brikit-content-block");
					while (newId == oldId && $blocks.length > 1) {
						var choice = Math.floor(Math.random() * $blocks.length);
						$next = $($blocks.get(choice));
						newId = $next.data("content-block");
					}
				}
			}
			
			if ($next) ThemePress.RotateContent.animateToDisplayBlock(element, $next, animation);

			ThemePress.RotateContent.busy = false;
    		
	    },
		
		rotateControls: function (rotateContentElement) {
			return rotateContentElement.next(".rotate-content-control");
		},
		
		schedule: function (method, delay) {
			var timeoutId = window.setTimeout(method, delay);
			ThemePress.RotateContent.timeouts.push(timeoutId);
		},

		selectContentControl: function (rotateContentElement, blockId) {
			ThemePress.RotateContent.rotateControls(rotateContentElement).find("li").removeClass("selected");
			ThemePress.RotateContent.rotateControls(rotateContentElement).find("li[data-block-id='" + blockId + "']").addClass("selected");
		},

		selectBlock: function () {
			ThemePress.RotateContent.stopAnimations();
			ThemePress.RotateContent.enableAnimations();
			var $this = $(this);
			var element = $this.parents(".rotate-content-control").prev(".rotate-content");
			ThemePress.RotateContent.animateToDisplayBlock(element, $this.data("block-id"));
			ThemePress.RotateContent.resumeAnimations();
		},
	
		stopAnimations: function () {
			$(ThemePress.RotateContent.timeouts).each( function () { window.clearTimeout(this); });
			jQuery.fx.off = true;
			ThemePress.RotateContent.pauseAnimations();
		},

		updateControlSelection: function (element) {
			var currentBlockId = ThemePress.RotateContent.currentBlockId(element);
			var $controls = element.next(".rotate-content-control");
			$controls.find("li.selected").removeClass("selected");
			$controls.find("li[data-block-id=" + currentBlockId + "]").addClass("selected");
		}
    
	};

})(jQuery);

ThemePress.toInit( function ($) {

	// Set the random content displays in motion
	$(".rotate-content").each(function() {
		var element = $(this);
		
		if (!ThemePress.RotateContent.isManual(element)) {
			ThemePress.RotateContent.schedule(function() { ThemePress.RotateContent.rotateContent(element); }, ThemePress.RotateContent.delay(element, "data-initial-delay"));
		}
		
		ThemePress.RotateContent.initialize(element);
		
		// Listen for user-control of the animated pages
		ThemePress.RotateContent.initializeControls(element);
	});
});
