(function ($) {

	ThemePress.SpinningBlock = {
		
		initialize: function () {
			var $back = $(this);
			var flipUp = $back.hasClass("flip-up");
			var block = $back.closest(".brikit-content-block").addClass("spinning-block");
			var blockHasFlexibleHeight = block.attr("style").indexOf("height:") == -1;
			var $front = $(".block-front", block);
			var wrapper = block.closest(".column-wrapper");
			var perspective = (flipUp ? block.height() : block.width()) * 3;
			wrapper.css({"-webkit-perspective": perspective, "-moz-perspective": perspective, "-ms-perspective": perspective, "perspective": perspective});
			var rotator = $("<span>").addClass("aui-icon aui-icon-small aui-iconfont-undo rotator").text("Rotate");
			var hoverActivated = $back.hasClass("on-hover");
			if (flipUp) block.addClass("flip-up");
			else block.addClass("flip-left");
	
			var spinBlock = function (event) {
				if (block.hasClass("spinning")) return;
				block.addClass("spinning");

				$(".brikit-content-block.spin-half .aui-icon.rotator").click();

				var backward = block.hasClass("spin-half");
				if (backward) block.removeClass("spin-full");
				else block.addClass("spin-half");

				if (blockHasFlexibleHeight) block.css("height", (backward ? $front.height() : $back.height()) + "px");
		
				setTimeout(function () {
					$front.toggle();
					$back.toggle();
					if (backward) block.removeClass("spin-half");
					else block.addClass("spin-full");
					setTimeout(function () { block.removeClass("spinning"); }, 250);
				}, 250);
			};
	
			var spinOver = function (event) {
				if (block.hasClass("spinning")) return;
				block.removeClass("spin-half spin-full");
				spinBlock(event);
			};
	
			var spinBack = function (event) {
				if (block.hasClass("spinning")) return;
				block.addClass("spin-half spin-full");
				spinBlock(event);
			};
	
			if (hoverActivated) {
				wrapper.hover(spinOver, spinBack);
			}
			else {
				block.append(rotator);
				rotator.click(spinBlock);
			}
	
		},
		
		stopTourGuideCookie: function (value) {
			ThemePress.registerCookie("com.brikit.themepress.stop.spinning.block.tour");
			return ThemePress.cookie("com.brikit.themepress.stop.spinning.block.tour", value);
		},
		
		showTourGuide: function () {
			if (ThemePress.SpinningBlock.stopTourGuideCookie()) return;
			
			var $block = $(".brikit-content-block .block-back").first().closest(".brikit-content-block");
			var $rotator = $block.find(".rotator");
			var $tour = $block.find(".rotator-help");
			if (!$rotator.length || !$tour.length) return;
			
			setTimeout(function () {
				ThemePress.SpinningBlock.tourGuideDialog = AJS.InlineDialog($rotator, "spinning-block-dialog-" + new Date().getTime(),
					function (content, trigger, showPopup) {
						var $off = $("<input>").addClass("checkbox").attr("id", "tour-got-it").attr("type", "checkbox");
						var $offLabel = $("<label>").attr("for", "tour-got-it").text("Don't show this again");
						var $form = $("<form>").addClass("aui").append($off).append(" ").append($offLabel);
						$tour.append($form);
						content.html($tour);
						$off.change(function () { ThemePress.SpinningBlock.stopTourGuideCookie(true); ThemePress.SpinningBlock.tourGuideDialog.fadeOut(); });
						showPopup();
					},
					{
						width: "auto",
						height: "auto",
						hideDelay: null,
						fadeTime: 300,
						noBind: true,
						initCallback: function () { $(this.popup).css({zIndex: 15000}); }
					}
				);
				ThemePress.SpinningBlock.tourGuideDialog.show();
			}, 1000);
			
			
		}
		
	};

	ThemePress.toInit( function ($) {
		$(".brikit-content-block .block-back").each(ThemePress.SpinningBlock.initialize);
		ThemePress.SpinningBlock.showTourGuide();
	});
	
})(jQuery);
