/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.util.HTMLPairType;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.themepress.util.ThemePress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ChooseTimezoneMacro
extends BrikitNoBodyMacro {
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/choose-timezone.vm";

    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        macroContext.velocityContextAdd((Object)"availableTimeZones", this.getAvailableTimeZones());
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    public List<HTMLPairType> getAvailableTimeZones() {
        ArrayList<HTMLPairType> result = new ArrayList<HTMLPairType>();
        TimeZone defaultTimeZone = Confluence.getSettingsManager().getGlobalSettings().getTimeZone();
        result.add(new HTMLPairType(defaultTimeZone.getID(), ThemePress.timeZoneCaptionDefaut(defaultTimeZone)));
        List timeZones = TimeZone.getSortedTimeZones();
        for (Object timeZone : timeZones) {
            TimeZone tz = (TimeZone)timeZone;
            if (tz.equals((Object)defaultTimeZone)) continue;
            result.add(new HTMLPairType(tz.getID(), ThemePress.timeZoneCaption(tz)));
        }
        return result;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

