/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.user.Group;
import com.atlassian.user.User;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.confluence.UserFullNameSortOrder;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.macros.BrikitNoBodyMacro;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitNumber;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class UserGroupNavigatorMacro
extends BrikitNoBodyMacro {
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/user-group-navigator.vm";
    protected static final String SORT_ORDER_PARAM = "sort-order";
    protected static final String INCLUDE_INDIVIDUAL_EDITORS = "include-individual-editors";
    protected static final String SORT_NAME_VALUE = "name";
    protected static final String SORT_GROUP_VALUE = "group";
    protected static final String THUMBNAIL_HEIGHT_PARAM = "thumbnail-height";
    protected static final String THUMBNAIL_WIDTH_PARAM = "thumbnail-width";
    protected static final String THUMBNAIL_MARGIN_PARAM = "thumbnail-margin";

    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        BrikitList users = new BrikitList();
        for (String groupName : macroContext.commaSeparatedListValue("groups")) {
            Group group = Confluence.getGroup((String)groupName);
            if (group == null) {
                throw new MacroExecutionException("Unknown group: " + groupName);
            }
            BrikitList groupUsers = Confluence.getGroupMembers((Group)group, (boolean)false);
            Collections.sort(groupUsers, new UserFullNameSortOrder());
            users.ensureContains((List)groupUsers);
        }
        if (macroContext.booleanValue(INCLUDE_INDIVIDUAL_EDITORS)) {
            for (User user : Confluence.getUsersWithSpacePermissions((Space)macroContext.getSpace())) {
                if (!Confluence.hasSpacePermissionAsUser((String)"EDITSPACE", (Space)macroContext.getSpace(), (User)user) || users.contains((Object)user)) continue;
                users.add((Object)user);
            }
        }
        if (SORT_NAME_VALUE.equals(macroContext.stringValue(SORT_ORDER_PARAM))) {
            Collections.sort(users, new UserFullNameSortOrder());
        }
        macroContext.velocityContextAdd((Object)"users", (Object)users);
        macroContext.velocityContextAdd((Object)THUMBNAIL_HEIGHT_PARAM, (Object)BrikitNumber.parseInteger((String)macroContext.stringValue(THUMBNAIL_HEIGHT_PARAM, "256")));
        macroContext.velocityContextAdd((Object)THUMBNAIL_WIDTH_PARAM, (Object)BrikitNumber.parseInteger((String)macroContext.stringValue(THUMBNAIL_WIDTH_PARAM, "256")));
        macroContext.velocityContextAdd((Object)THUMBNAIL_MARGIN_PARAM, (Object)BrikitNumber.parseInteger((String)macroContext.stringValue(THUMBNAIL_MARGIN_PARAM, "0")));
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    public boolean isInline() {
        return true;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

