/**
 * NOTE: This file gets imported through the standard add-on web-resources method to all Confluence screens, 
 * even when Theme Press is not set as the site theme. This is done to support the video lessons after initial install.
 * THIS MEANS THAT THIS FILE IS NOT REACHABLE BY THEME PRESS DEVELOPER MODE.
 */
(function ($) {
	BrikitVideoTours = {

		learnDialog: function () {
			if (!BrikitVideoTours.$learnDialog) {
				BrikitVideoTours.$learnDialog = new AJS.ConfluenceDialog({
	                id: 'learn-theme-press-dialog',
	                closeOnOutsideClick: false,
					keypressListener: function () { return false; }
	            });
	            
				var header = "Brikit Theme Press Learning Center"//	AJS.I18n.getText("aboutpage.section.title");
		        BrikitVideoTours.$learnDialog.addHeader(header);
		        BrikitVideoTours.$learnDialog.addCancel("Close", function() {
		            BrikitVideoTours.$learnDialog.hide();
					BrikitVideoTours.$learnDialog.remove();
					BrikitVideoTours.$learnDialog = null;
		        });

				// Use contextPath instead of ThemePress.contextPath because we can rely on Brikit being set as the theme
				$.get(contextPath + "/plugins/brikit/lesson/learn.action", BrikitVideoTours.learningVideos, "json");
			}
			
			return BrikitVideoTours.$learnDialog;
		},
		
		learningVideos: function (data, textStatus, jqXHR) {
			if (data.success) {
				$(data.videos).each(function () {
					BrikitVideoTours.learnDialog().addPanel(this.title, this.html, "youtube-" + this.id);
				});
				BrikitVideoTours.learnDialog().gotoPanel("0");
			}
			else {
				alert(data.message);
			}
			
		},
		
		learnThemePress: function (event) {
	        $(document).focus(); // This closes the system.help pulldown menu
			event.preventDefault();
			BrikitVideoTours.learnDialog().show();
		}
				
	};

	$(document).ready(function ($) {
		$("#brikit-learn-theme-press-link").click(BrikitVideoTours.learnThemePress)
	});
	
})(jQuery);

