/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.actions;

import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import com.brikit.themepress.actions.ThemePressActionSupport;
import com.brikit.themepress.settings.SpaceCategorySettings;
import java.io.File;
import java.util.Collections;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

public class UploadSpaceCategorySettingsAction
extends ThemePressActionSupport {
    @Override
    public String execute() throws Exception {
        for (String parameterName : Collections.list(this.getMultiPartRequest().getFileParameterNames())) {
            UploadedFile[] files = this.getMultiPartRequest().getFiles(parameterName);
            for (int i = 0; i < files.length; ++i) {
                UploadedFile uploadedFile;
                if (files[i] == null || !(uploadedFile = files[i]).isFile()) continue;
                File pluginFile = (File)uploadedFile.getContent();
                String filename = this.getMultiPartRequest().getFileNames(parameterName)[i];
                BrikitLog.log("Uploading: " + pluginFile.getAbsolutePath());
                try {
                    SpaceCategorySettings.uploadSettings(pluginFile);
                    this.setResult(filename);
                    continue;
                }
                catch (Exception ex) {
                    BrikitLog.logError("Unable to read settings in " + filename, ex);
                    this.addActionError(BrikitString.isSet(ex.getMessage()) ? ex.getMessage() : "Unable to read " + filename);
                    return "error";
                }
            }
        }
        return "success";
    }

    public void validate() {
        super.validate();
        if (!Confluence.isConfluenceAdministrator()) {
            this.addActionError(this.getText("brikit.config.insufficient.permissions"));
        }
    }
}

