/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.confluence;

import com.atlassian.confluence.setup.struts.ConfluenceVelocityManager;
import com.atlassian.confluence.velocity.ContextUtils;
import com.brikit.core.log.BrikitLog;
import java.util.Date;
import java.util.Map;
import org.apache.velocity.context.Context;

public class BrikitVelocityContext {
    protected static Map<String, Object> defaultVelocityContext;
    protected static long lastVelocityContextUpdate;
    protected static final long VC_UPDATE_INTERVAL = 900000L;

    protected static void checkDefaultVelocityContextExpiration() {
        if (new Date().getTime() - lastVelocityContextUpdate > 900000L) {
            BrikitLog.logDebug("BrikitVelocityContext default velocity context expired.");
            BrikitVelocityContext.resetDefaultVelocityContext();
        }
    }

    public static synchronized Map<String, Object> getDefaultVelocityContext() {
        BrikitVelocityContext.checkDefaultVelocityContextExpiration();
        if (defaultVelocityContext == null) {
            BrikitLog.logDebug("Caching a new default velocity context.");
            Context context = ConfluenceVelocityManager.getConfluenceVelocityContext();
            defaultVelocityContext = ContextUtils.toMap((Context)context);
        }
        return defaultVelocityContext;
    }

    public static synchronized void resetDefaultVelocityContext() {
        defaultVelocityContext = null;
        lastVelocityContextUpdate = new Date().getTime();
    }

    static {
        lastVelocityContextUpdate = 0L;
    }
}

