/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.themepress.toolkit.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitBaseMacro;
import com.brikit.core.macros.BrikitMacroContext;
import java.util.Map;

public class ImageMapMacro
extends BrikitBaseMacro {
    public static final String TEMPLATE_NAME = "theme-press/templates/macros/image-map.vm";

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        String variable = this.localSafeId("dynamicMap");
        macroContext.velocityContextAdd("dynamicMap", variable);
        String image = macroContext.stringValue("0");
        if (image == null) {
            throw new MacroExecutionException("No image specified.");
        }
        macroContext.velocityContextAdd("image", image);
        AbstractPage attachmentPage = macroContext.pageFromValue("attachment-page", null);
        if (attachmentPage == null && macroContext.hasStringValue("attachment-page")) {
            throw new MacroExecutionException("Unable to locate the specified attachment page '" + macroContext.stringValue("attachment-page") + "'.");
        }
        if (attachmentPage == null) {
            attachmentPage = macroContext.getPage();
        }
        if (!Confluence.pageHasAttachment(attachmentPage, image)) {
            throw new MacroExecutionException("Image '" + image + "' is not found attached to the specified page '" + attachmentPage.getTitle() + "'.");
        }
        macroContext.velocityContextAdd("attachmentPage", attachmentPage);
        String fixedBody = body.replaceAll("dynamicMapVariableWillReplaceThis", variable);
        macroContext.velocityContextAdd("body", fixedBody);
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }
}

