/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.search;

import com.atlassian.confluence.macro.query.BooleanQueryFactory;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Attachment;
import com.atlassian.confluence.search.service.ContentTypeEnum;
import com.atlassian.confluence.search.service.SpaceCategoryEnum;
import com.atlassian.confluence.search.v2.ISearch;
import com.atlassian.confluence.search.v2.InvalidSearchException;
import com.atlassian.confluence.search.v2.SearchQuery;
import com.atlassian.confluence.search.v2.SearchResults;
import com.atlassian.confluence.search.v2.SearchSort;
import com.atlassian.confluence.search.v2.query.AttachmentTypeQuery;
import com.atlassian.confluence.search.v2.query.BooleanQuery;
import com.atlassian.confluence.search.v2.query.ContentTypeQuery;
import com.atlassian.confluence.search.v2.query.DateRangeQuery;
import com.atlassian.confluence.search.v2.query.InSpaceQuery;
import com.atlassian.confluence.search.v2.query.LabelQuery;
import com.atlassian.confluence.search.v2.query.SpaceCategoryQuery;
import com.atlassian.confluence.search.v2.sort.CreatedSort;
import com.atlassian.confluence.search.v2.sort.TitleSort;
import com.atlassian.confluence.spaces.Space;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitLabel;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.set.ListOrderedSet;

public class ContentSearch {
    public static final String SPACE_FILTER_CATEGORY = "specified categories";
    public static final String SPACE_FILTER_KEYS = "specified keys";
    public static final String SPACE_FILTER_GLOBAL_SPACES = "all global spaces";
    public static final String SPACE_FILTER_ALL_SPACES = "all spaces";
    public static final String ORDER_MOST_RECENT = "most recent";

    public static ContentTypeQuery contentTypeQuery(List<ContentTypeEnum> contentTypes) {
        return contentTypes == null || contentTypes.isEmpty() ? null : new ContentTypeQuery(contentTypes);
    }

    public static AttachmentTypeQuery imageAttachmentTypeQuery() {
        return new AttachmentTypeQuery(Attachment.Type.IMAGE);
    }

    public static SpaceCategoryQuery spaceCategoryQuery(String spaceFilter) {
        if (SPACE_FILTER_GLOBAL_SPACES.equals(spaceFilter)) {
            return new SpaceCategoryQuery(SpaceCategoryEnum.GLOBAL, Confluence.getLabelManager());
        }
        return null;
    }

    public static DateRangeQuery dateRangeQuery(Date from, Date to) {
        return new DateRangeQuery(from, to, true, true, DateRangeQuery.DateRangeQueryType.MODIFIED);
    }

    public static InSpaceQuery inSpaceQuery(String spaceKey) {
        return BrikitString.isSet(spaceKey) ? new InSpaceQuery(spaceKey) : null;
    }

    public static InSpaceQuery inSpaceQuery(String spaceFilter, List<String> spaceKeysOrCategories) {
        return ContentSearch.inSpaceQuery(spaceFilter, spaceKeysOrCategories, null);
    }

    public static InSpaceQuery inSpaceQuery(String spaceFilter, List<String> spaceKeysOrCategories, String defaultSpaceKey) {
        if (BrikitString.isSet(spaceFilter) && !SPACE_FILTER_ALL_SPACES.equals(spaceFilter) && !SPACE_FILTER_GLOBAL_SPACES.equals(spaceFilter)) {
            if (SPACE_FILTER_CATEGORY.equals(spaceFilter)) {
                ArrayList<Space> spaces = spaceKeysOrCategories.isEmpty() ? new ArrayList<Space>() : Confluence.spacesWithCategories(spaceKeysOrCategories, new ArrayList<String>());
                spaceKeysOrCategories = Confluence.spaceKeysFromSpaces(spaces);
            } else if (spaceKeysOrCategories.isEmpty()) {
                if (BrikitString.isSet(defaultSpaceKey)) {
                    spaceKeysOrCategories.add(defaultSpaceKey);
                } else {
                    return null;
                }
            }
            return new InSpaceQuery(new HashSet<String>(spaceKeysOrCategories));
        }
        return null;
    }

    public static LabelQuery labelQuery(String label) {
        return BrikitString.isSet(label) ? new LabelQuery(label) : null;
    }

    public static SearchQuery labelsQuery(List<String> labels, boolean matchAllLabels, List<String> excludeLabels) {
        SearchQuery includeQuery;
        if (labels.isEmpty()) {
            return null;
        }
        ListOrderedSet queries = new ListOrderedSet();
        for (String label : labels) {
            queries.add(new LabelQuery(label));
        }
        SearchQuery searchQuery = includeQuery = matchAllLabels ? BooleanQuery.composeAndQuery((Set)queries) : BooleanQuery.composeOrQuery((Set)queries);
        if (excludeLabels == null || excludeLabels.isEmpty()) {
            return includeQuery;
        }
        HashSet<SearchQuery> includeQueries = new HashSet<SearchQuery>();
        includeQueries.add(includeQuery);
        HashSet<LabelQuery> excludeQueries = new HashSet<LabelQuery>();
        for (String label : excludeLabels) {
            excludeQueries.add(new LabelQuery('\"' + label + '\"'));
        }
        return new BooleanQuery(includeQueries, null, excludeQueries);
    }

    public static Map<String, String> labelTitles(AbstractPage abstractPage, String labels, String labelNameMapping) {
        HashMap<String, String> labelTitles = new HashMap<String, String>();
        for (String label : BrikitString.split(Confluence.getLabelString(abstractPage))) {
            labelTitles.put(label, BrikitLabel.humanize(label));
        }
        for (String label : BrikitString.splitCommaSeparated(labels)) {
            labelTitles.put(label, BrikitLabel.humanize(label));
        }
        for (String labelPair : BrikitString.splitCommaSeparated(labelNameMapping)) {
            BrikitList<String> pair = new BrikitList<String>((List<String>)BrikitString.split(labelPair, "="));
            if (pair.size() == 2) {
                labelTitles.put(pair.first(), pair.last());
                continue;
            }
            if (pair.size() != 1) continue;
            labelTitles.put(pair.first(), BrikitString.titleize(pair.first()));
        }
        return labelTitles;
    }

    protected static SearchResults runSearch(BooleanQuery query, SearchSort searchSort, Set<String> fieldsToFetch, Integer offset, Integer limit) throws InvalidSearchException {
        com.atlassian.confluence.search.v2.ContentSearch search = offset == null ? new com.atlassian.confluence.search.v2.ContentSearch((SearchQuery)query, searchSort) : new com.atlassian.confluence.search.v2.ContentSearch((SearchQuery)query, searchSort, offset.intValue(), limit.intValue());
        return Confluence.getSearchManager().search((ISearch)search, fieldsToFetch);
    }

    public static SearchResults searchByDate(Set<String> fieldsToFetch, SpaceCategoryQuery spaceCategoryQuery, InSpaceQuery inSpaceQuery, ContentTypeQuery contentTypeQuery, DateRangeQuery dateRangeQuery, Integer offset, Integer limit, SearchSort searchSort) throws InvalidSearchException {
        return ContentSearch.searchByDateAndLabel(fieldsToFetch, spaceCategoryQuery, inSpaceQuery, contentTypeQuery, dateRangeQuery, null, offset, limit, searchSort);
    }

    public static SearchResults searchByDateAndLabel(Set<String> fieldsToFetch, SpaceCategoryQuery spaceCategoryQuery, InSpaceQuery inSpaceQuery, ContentTypeQuery contentTypeQuery, DateRangeQuery dateRangeQuery, SearchQuery labelQuery, Integer offset, Integer limit, SearchSort searchSort) throws InvalidSearchException {
        BooleanQueryFactory queryFactory = new BooleanQueryFactory();
        if (spaceCategoryQuery != null) {
            queryFactory.addMust((SearchQuery)spaceCategoryQuery);
        }
        if (labelQuery != null) {
            queryFactory.addMust(labelQuery);
        }
        if (dateRangeQuery != null) {
            queryFactory.addMust((SearchQuery)dateRangeQuery);
        }
        if (contentTypeQuery != null) {
            queryFactory.addMust((SearchQuery)contentTypeQuery);
        }
        if (inSpaceQuery != null) {
            queryFactory.addMust((SearchQuery)inSpaceQuery);
        }
        BooleanQuery query = queryFactory.toBooleanQuery();
        return ContentSearch.runSearch(query, searchSort, fieldsToFetch, offset, limit);
    }

    public static SearchResults searchImagesByDateAndLabel(Set<String> fieldsToFetch, SpaceCategoryQuery spaceCategoryQuery, InSpaceQuery inSpaceQuery, DateRangeQuery dateRangeQuery, SearchQuery labelQuery, Integer offset, Integer limit, SearchSort searchSort) throws InvalidSearchException {
        BooleanQueryFactory queryFactory = new BooleanQueryFactory();
        ArrayList<ContentTypeEnum> contentTypes = new ArrayList<ContentTypeEnum>();
        contentTypes.add(ContentTypeEnum.ATTACHMENT);
        queryFactory.addMust((SearchQuery)ContentSearch.contentTypeQuery(contentTypes));
        queryFactory.addMust((SearchQuery)ContentSearch.imageAttachmentTypeQuery());
        if (spaceCategoryQuery != null) {
            queryFactory.addMust((SearchQuery)spaceCategoryQuery);
        }
        if (labelQuery != null) {
            queryFactory.addMust(labelQuery);
        }
        if (dateRangeQuery != null) {
            queryFactory.addMust((SearchQuery)dateRangeQuery);
        }
        if (inSpaceQuery != null) {
            queryFactory.addMust((SearchQuery)inSpaceQuery);
        }
        BooleanQuery query = queryFactory.toBooleanQuery();
        return ContentSearch.runSearch(query, searchSort, fieldsToFetch, offset, limit);
    }

    public static SearchSort searchSort(String order) {
        return ORDER_MOST_RECENT.equalsIgnoreCase(order) ? CreatedSort.DESCENDING : TitleSort.ASCENDING;
    }
}

