/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.confluence;

import com.atlassian.mail.MailException;
import com.atlassian.mail.MailFactory;
import com.atlassian.mail.server.SMTPMailServer;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitString;

public class Email
extends com.atlassian.mail.Email {
    protected boolean isFromRequired = false;
    protected String extraData;

    protected static SMTPMailServer getSmtpMailServer() throws MailException {
        return MailFactory.getServerManager().getDefaultSMTPMailServer();
    }

    public Email() {
        super("hack");
        this.setTo(null);
    }

    public void fromCurrentUser() {
        if (!Confluence.isAnonymousUser()) {
            this.setFrom(Confluence.getConfluenceUser().getEmail());
            this.setFromName(Confluence.getConfluenceUser().getFullName());
        }
    }

    public String getExtraData() {
        return this.extraData;
    }

    public boolean isFromRequired() {
        return this.isFromRequired;
    }

    public boolean isHtml() {
        return this.getMimeType().equalsIgnoreCase("text/html");
    }

    public void send() throws Exception {
        if (!(BrikitString.isSet(this.getTo()) || BrikitString.isSet(this.getCc()) || BrikitString.isSet(this.getBcc()))) {
            throw new IllegalArgumentException("TO: is missing");
        }
        if (this.isFromRequired() && !BrikitString.isSet(this.getFrom())) {
            throw new IllegalArgumentException("FROM: is missing");
        }
        try {
            String body = this.getBody();
            if (BrikitString.isSet(this.getExtraData())) {
                body = body + "\n\n-----------------------\nAdditional Information:\n\n" + this.getExtraData();
            }
            this.setBody(body);
            Email.getSmtpMailServer().send((com.atlassian.mail.Email)this);
        }
        catch (Exception ex) {
            System.out.println("Error sending email:");
            ex.printStackTrace();
            throw ex;
        }
    }

    public void setExtraData(String aExtraData) {
        this.extraData = aExtraData;
    }

    public void setFromRequired(boolean aFromRequired) {
        this.isFromRequired = aFromRequired;
    }

    public void setHtml(boolean isHtml) {
        this.setMimeType(isHtml ? "text/html" : "text/plain");
    }
}

