(function ($) {
	
	TargetedSearch.SearchLink = function (element) {
		this.element = $(element);
		this.uniqueId = this.element.data("id");
		this.initialize();
		this.resultsCache = {};
	};
	
	Object.assign(TargetedSearch.SearchLink.prototype, {

		find: function (selector) {
			return selector ? $(selector, this.element) : this.element;
		},

		initialize: function () {
			this.form = $(".targeted-search-form[data-id=" + this.uniqueId + "]");
			this.filters = $(".selected-filters[data-id=" + this.uniqueId + "]");

			this.searchForm = new TargetedSearch.SearchForm(this.form, this.find(".search-results-list"));
			this.selectedFilters = new TargetedSearch.SelectedFilters(this.filters, this.searchForm, this);

			this.selectedFilters.updateSearchFiltersFromSelections();

			var $link = this.find("a");
			$link.click(this.openSearchPanel.bind(this));
		},
		
		openSearchPanel: function (event) {
			event.preventDefault();
            TargetedSearch.SearchPanel.openSearch(this.searchForm.serialize());
		}

	});
	
	TargetedSearch.toFinalize(function ($) {
		$(".targeted-search-link-macro").each(function () { new TargetedSearch.SearchLink(this); });
	});
	
})(jQuery);