(function ($) {


	// Set up the core javascript to be available to each product by the name of its choice
	this[brikitProduct] = this[brikitProduct] || {};
	
	// To simplify brikit-core, reference core javascript using BrikitCore
	var BrikitCore = this[brikitProduct];
	
	// Allow BrikitCore to be extended using BrikitCore.extend({x: aFunc, y: bFunc})
	BrikitCore.extend = function (obj) {
       for (var i in obj) {
          if (obj.hasOwnProperty(i)) this[i] = obj[i];
       }
    };

	/* I18n variables used by brikit-core JavaScript. These must be maintained by hand, they are not auto-generated. */
	BrikitCore.i18n = {
		
		// Make sure the i18n object can be extended by Theme Press and third-party add-ons
		extend: BrikitCore.extend,
		
		"com.brikit.core.no.browser.cookies.found" : "No browser cookies found.",
		"com.brikit.core.cleared.browser.cookies" : "Cleared browser cookies:",

		"com.brikit.core.alert" : "Alert",
		"com.brikit.core.ok" : "OK",
		"com.brikit.core.confirm" : "Confirm",
		"com.brikit.core.cancel" : "Cancel",
		"com.brikit.core.close" : "Close",
		"com.brikit.core.no.results.found" : "No results found",
		"com.brikit.core.i.understand.the.above" : "I understand the above",
		"com.brikit.core.you.do.not.seem.confident.about.this" : "You don't seem confident about this.",
		"com.brikit.core.if.you.are.check.the.box.and.try.again" : "If you are, check the box and try again.",
		"com.brikit.core.are.you.sure" : "Are You Sure?",

		"com.brikit.core.to.get.help.ask.your" : "To get help, ask your",
		"com.brikit.core.site.administrator" : "site administrator",
		"com.brikit.core.to.open.a.ticket.on" : " to open a ticket on",
		"com.brikit.core.brikit.support.system" : "Brikit's support system",
		"com.brikit.core.with.the.following" : " with the following:",
		"com.brikit.core.what.you.were.doing" : "what you were doing",
		"com.brikit.core.the.time.it.occurred" : "the time it occurred",
		"com.brikit.core.a.copy.of.all.the.information.below" : "a copy of <strong>all</strong> the information below",
		"com.brikit.core.a.copy.of.the.application.logs.if.possible" : "a copy of the application logs (if possible).",
		"com.brikit.core.we.will.respond.as.promptly.as.possible" : "We will respond as promptly as possible. Thank you!",
		"com.brikit.core.a.system.error.has.occurred" : "A system error has occurred. Our apologies!",
		"com.brikit.core.failed.to.load.designer" : "Failed to load designer"
	};
	
	// BrikitCore variables
	BrikitCore.extend({

        $: AJS.$,

        bind: AJS.bind,

        toInitializeFunctions: [],

		// Alias AJS.toInit to wrap Confluence API
		toInit: function(aFunction) {
            BrikitCore.toInitializeFunctions.push(aFunction);
        },

		toFinalizeFunctions: [],
		
		contextPath: AJS.Confluence.getContextPath(),
		baseURL: AJS.Meta.get("base-url"),
		spaceKey: AJS.Meta.get("space-key"),
		spaceName: AJS.Meta.get("space-name"),
		pageId: AJS.Meta.get("page-id"),
		pageTitle: AJS.Meta.get("page-title"),
		parentPageId: AJS.Meta.get("parent-page-id"),
		grandparentPageId: AJS.Meta.get("grandparent-page-id"),
		contentId: AJS.Meta.get("content-id"), // Populated when creating a new page
		contentType: AJS.Meta.get("content-type"),
		isBlog: AJS.Meta.get("content-type") == "blogpost",
		confluenceVersion: AJS.Meta.get("version-number"),
		username: AJS.Meta.get("remote-user"),
        atlToken: AJS.Meta.get('atl-token'),
		
		url: [location.protocol, "//", location.host, location.pathname].join(""),
		urlPath: location.pathname,
		urlParams: {} // Initialized below
        
	});
	
	// Decode url parameters for easy access later
	var match,
	    pl     = /\+/g,  // Regex for replacing addition symbol with a space
	    search = /([^&=]+)=?([^&]*)/g,
	    decode = function (s) { return decodeURIComponent(s.replace(pl, " ")); },
	    query  = window.location.search.substring(1);

	while (match = search.exec(query)) BrikitCore.urlParams[decode(match[1])] = decode(match[2]);

	// BrikitCore functions
	BrikitCore.extend({

        // Add the security token as a atl_token property to data (which is an {})
        addToken: function (data) {
            data.atl_token = BrikitCore.atlToken;
            return data;
        },
        
        addTokenToDataIfNeeded: function (url, data) {
            if (!url.includes("atl_token=") && !data.atl_token) {
                return typeof(data) === "string" ? data + BrikitCore.atlTokenParam(true) : BrikitCore.addToken(data);
            }
        },
        
		// Append a parameter to the given url
		addUrlParameter: function (url, name, value) {
			return url + (url.indexOf("?") == -1 ? "?" : "&") + encodeURIComponent(name) + "=" + encodeURIComponent(value);
		},
        
        appendAtlTokenInputField: function ($form) {
			const $input = $("<input>").attr("type", "hidden").attr("name", "atl_token").val(BrikitCore.atlToken);
			$form.append($input);
        },
        
        atlTokenParam: function (notFirst) {
            return (notFirst ? "&" : "?") + "atl_token=" + BrikitCore.atlToken;
        },
        
		// Examine the Ajax result fields, and display a cleaned up error message in a dialog titled with alertTitle (or
		// a default title if none). Return true if an error was detected, or false if not.
		ajaxResponseError: function (responseText, textStatus, XMLHttpRequest, alertTitle) {
			if (textStatus == "error") {
				var $message = $("#PageContent", responseText);
				if ($message.length) {
					// Adjust the standard Confluence server error by removing the Atlassian header
					$message.find("#sysErrPanel").remove();
				}
				else {
					// Unknown error -- wrap in a div to ensure it displays
					$message = $("<div>").append(responseText);
				}
				// Insert a Brikit message at the top
				var preamble = "<p>" + BrikitCore.getText("com.brikit.core.to.get.help.ask.your") + 
					" <a href='" + BrikitCore.contextPath + "/contactadministrators.action'>" + 
					BrikitCore.getText("com.brikit.core.site.administrator") + 
					"</a>" +
					BrikitCore.getText("com.brikit.core.to.open.a.ticket.on") + 
					" <a href='http://brikit.atlassian.net'>" + 
					BrikitCore.getText("com.brikit.core.brikit.support.system") + 
					"</a>" +
					BrikitCore.getText("com.brikit.core.with.the.following") + 
					"</p>" +
					"<ol><li>" + BrikitCore.getText("com.brikit.core.what.you.were.doing") + "</li>" +
					"<li>" + BrikitCore.getText("com.brikit.core.the.time.it.occurred") + "</li>" +
					"<li>" + BrikitCore.getText("com.brikit.core.a.copy.of.all.the.information.below") + "</li>" +
					"<li>" + BrikitCore.getText("com.brikit.core.a.copy.of.the.application.logs.if.possible") + "</li></ol>" +
					"<p>" + BrikitCore.getText("com.brikit.core.we.will.respond.as.promptly.as.possible") + "</p>";
				var $composedAlert = $("<div>");
				AJS.messages.generic($composedAlert, {title: BrikitCore.getText("com.brikit.core.a.system.error.has.occurred"), body: preamble});
				$(".icon-close", $composedAlert).remove();
				$composedAlert.append("<br /><br />").append($message);
				
				BrikitCore.Dialog2.alert($composedAlert, {title: alertTitle || BrikitCore.getText("com.brikit.core.failed.to.load.designer"), size: "medium"});
				return true;
			}
			return false;
		},

		anonymousUser: function () {
			return BrikitCore.meta("anonymous-user");
		},
		
		auiIcon: function (iconName, extraClasses) {
			var $icon = $("<span>").addClass("aui-icon aui-icon-small aui-iconfont-" + iconName);
			if (extraClasses) $icon.addClass(extraClasses);
			return $icon;
		},
		
		auiLabelLozengeHTML: function (dataId, displayText, classes, closeable) {
			return $("<span class='aui-label " + classes + (closeable ? " aui-label-closeable" : "") + "' " +
				"data-id='" + dataId + "'>" +
				displayText +
				(closeable ? "<span class='aui-icon aui-icon-close' tabindex='0'></span>" : "") +
				"</span>");
		},
		
		// Creates an aui-spinner, adds it to element (if specified), and returns the spinner
		auiSpinner: function (element, filled) {
			var $spinner = $("<aui-spinner size='small'>");
			if (element) $(element).append($spinner);
			if (filled) $spinner.attr("filled", true);
			return $spinner;
		},
		
		// Makes dropdown menus and inline dialogs disappear
		clickOnDocument: function () {
			$(document).focus();
		},

        // page is the CQL content json object representing a page
        contentFlowDocumentId: function (page) {
            if (page.content) page = page.content;
            return page.metadata && page.metadata.properties && page.metadata.properties.documentId ? page.metadata.properties.documentId.value : "";
        },

        contentFlowPageDocumentNumber: function (page) {
            if (page.content) page = page.content;
            return page.metadata && page.metadata.properties && page.metadata.properties.pageDocumentNumber ? page.metadata.properties.pageDocumentNumber.value : "";
        },
        
        contentFlowPageTitleWithDocumentId: function (page) {
            if (page.content) page = page.content;
            return page.metadata && page.metadata.properties && page.metadata.properties.title ? page.metadata.properties.title.value : "";
        },
        
		// See https://davidwalsh.name/javascript-debounce-function
		debounce: function (func, wait, immediate) {
			var timeout;
			return function() {
				var context = this, args = arguments;
				var later = function() {
					timeout = null;
					if (!immediate) func.apply(context, args);
				};
				var callNow = immediate && !timeout;
				clearTimeout(timeout);
				timeout = setTimeout(later, wait);
				if (callNow) func.apply(context, args);
			};
		},
		
		// Decode encoded URI components, including dealing with plus signs for spaces
		decodeURIComponent: function (name) {
			return decodeURIComponent(name.replace(/\+/g, " "));
		},
	
		// Encode URI components, including dealing with plus signs for spaces
		encodeURIComponent: function (name) {
			return BrikitCore.encodeURISpaceAsPlus(encodeURIComponent(name));
		},

		encodeURISpaceAsPlus: function (name) {
			return name.replace(/%20/g, "+");
		},

		encodeHTMLEntities: function (name) {
            return name.replace(/&/g, '&amp;').replace(/</g, '&lt;').replace(/>/g, '&gt;').replace(/"/g, '&quot;');
		},
	
		// Return true if string ends with suffix
		endsWith: function (string, suffix) {
		    return string.indexOf(suffix, string.length - suffix.length) != -1;
		},

	    fireInitializeFunctions: function () {
                $(BrikitCore.toInitializeFunctions).each(function () { AJS.toInit(this);
            });
        },

		// Fire the queued functions to run after all the regular initializers are finished
		fireFinalizeFunctions: function () {
			    $(BrikitCore.toFinalizeFunctions).each(function () { AJS.toInit(this);
			});
		},
		
		getText: function (propertiesKey, values) {
			var property = BrikitCore.i18n[propertiesKey];
			if (!property) return propertiesKey;

			values = values instanceof Array ? values : $(arguments).toArray().slice(1);
			$(values).each(function (i, value) {
				property = property.replace("{" + i + "}", value);
			});

			return property;
		},
		
        isConfluenceQuestionsPage: function () {
            return $("body.cq-body").length;
        },
		
		// This compares Confluence current version with the given version
        // Returns true if the version to compare is equal or greater and false otherwise
        isConfluenceVersionAtLeast: function (version) {
            var i, diff;
                var regExStrip0 = /(\.0+)+$/;
                var currentVersion = BrikitCore.confluenceVersion.replace(regExStrip0, '').split('.');
                var compareVersion = version.replace(regExStrip0, '').split('.');
                var l = Math.min(currentVersion.length, compareVersion.length);

                for (i = 0; i < l; i++) {
                    diff = parseInt(currentVersion[i], 10) - parseInt(compareVersion[i], 10);
                    if (diff) {
                        return diff >= 0;
                    }
                }
                return currentVersion.length - compareVersion.length >= 0;
        },

        isContentFlowInstalled: function () {
            return typeof(ContentFlow) != "undefined";
        },
        
        isUserProfilePage: function () {
            return $("body.profile").length;
        },
		
		logDebug: function (message) {
			if (BrikitCore.debug) console.log(">>>>>>>>>>>>>> " + new Date().getTime() + " " + message);
		},
		
		// Return the content value for the named meta tag in the DOM
		meta: function (name) {
			return $("meta[name=" + name + "]").attr("content");
		},
		
		post: function (url, data, callback, dataType) {
			$.ajax({
	            url: url, 
	            data: BrikitCore.addTokenToDataIfNeeded(url, data), 
				success: callback,
	            error: callback,
				dataType: dataType,
				type: "POST",
				timeout: 120000
	        });
		},
		
		reloadBrowser: function (delay) {
			if (typeof(delay) == "undefined") location.reload(true);
			else setTimeout(function () { location.reload(true); }, delay);
		},
		
		// If target is in DOM and is visible, then move element to it
		relocateElement: function (element, target) {
			BrikitCore.toInit( function ($) {
				if ($(target).isHidden()) return;
				$(target).first().append($(element));
			});
		},
		
		// Based on ideas from https://davidwalsh.name/javascript-debounce-function
		slowDown: function (func, wait, immediate) {
			var timeout;
			var started;
			return function() {
				var context = this;
				var args = arguments;
				var later = function() {
					timeout = null;
					started = 0;
					func.apply(context, args);
				};
				if (!started) started = new Date().getTime();
				var callNow = immediate && !timeout || (new Date().getTime() - started) > wait;
				clearTimeout(timeout);
				if (callNow) later();
				else timeout = setTimeout(later, wait);
			};
		},

		// Queue aFunction to run after all the regular initializers are finished
		toFinalize: function(aFunction) {
		    BrikitCore.toFinalizeFunctions.push(aFunction);
		}				
		
	});
	
})(jQuery);
