(function ($) { 

	TargetedSearch.ContentQuery = function (element) {
		this.element = $(element);
		this.initialize();
	};
	
	Object.assign(TargetedSearch.ContentQuery.prototype, {

		filterAdded: TargetedSearch.InteractiveSearch.prototype.filterAdded,
		filterRemoved: TargetedSearch.InteractiveSearch.prototype.filterRemoved,
		filterPickers: TargetedSearch.InteractiveSearch.prototype.filterPickers,
        initializeFilterGroupPickers: TargetedSearch.InteractiveSearch.prototype.initializeFilterGroupPickers,
        markFilterPicker: TargetedSearch.InteractiveSearch.prototype.markFilterPicker,

        filtersInRow: function ($row, groupName) {
            return $row.find("li", "td.filter-group-" + groupName);
        },
        
		find: function (selector) {
			return selector ? $(selector, this.element) : this.element;
		},

		initialize: function () {
			var self = this;
            
			this.find(".targeted-search-form").first().each(function () { self.searchForm = new TargetedSearch.SearchForm(this, self.find(".search-results-list"), self); });
			this.find(".selected-filters").first().each(function () { self.selectedFilters = new TargetedSearch.SelectedFilters(this, self.searchForm, self); });

            this.initializeFilterGroupPickers(this.element, this.selectedFilters);
                        
			this.loader = this.moreResultsLoader();
		},
	
        labelsInRow: function ($row, groupName) {
            return this.filtersInRow($row, groupName).toArray().map(function (f) { return $(f).data("label") });
        },
        
		moreResultsLoader: function () {
			return this.searchResults().data("more-results-loader");
		},
        
		resultsLoaded: function (resultsData) {
			return true;
		},
        
        resultRows: function () {
            return this.find(".results-table tbody tr");
        },
        
        selectedFilterGroups: function () {
            const groups = {};
			$.each(this.selectedFilters.selectedFilters(), function (i, f) {
                const label = $(f).data("id");
                const groupName = this.find(".content-query").data("label-filter-group-name-safe-x" + $(f).data("id"));
                groups[groupName] = groups[groupName] || []
                groups[groupName].push(label);
			}.bind(this));
            return groups;
        },
        
        rowMatchesSelectedFilters: function (row, selectedGroups) {
            let match = true;
            let $row = $(row);
			$.each(Object.keys(selectedGroups), function (i, group) {
			    const rowLabels = this.labelsInRow($row, group);
                const groupLabels = selectedGroups[group];
                const groupMatched = $(groupLabels).filter(function (i, label) { return rowLabels.includes((label)) }).length;
                match = match && groupMatched;
			}.bind(this));
            return match;
        },
		
		searchCriteriaChanged: function () {
            const selectedGroups = this.selectedFilterGroups();
            $(this.resultRows()).each(function (i, row) {
                let match = this.rowMatchesSelectedFilters(row, selectedGroups)
                $(row).adjustClass('not-selectable', !match);
                $(row).showIf(match);
            }.bind(this));
		},
		
		searchResults: function (selector) {
			var $results = this.find(".search-results-list");
			return selector ? $(selector, $results) : $results;
		}
		
	});
		
	TargetedSearch.toInit(function ($) {
		$(".content-query-macro").each(function () { new TargetedSearch.ContentQuery(this); });
	});

})(jQuery);
