/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.model;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.brikit.core.confluence.BrikitDataStore;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.model.Filter;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class CascadingLabel {
    protected static final String CASCADING_LABELS = "cascadingLabels";
    protected static final String DELIMITER = ",";

    public static void addCascadingLabelToPage(AbstractPage page, String labelString) {
        if (!(page instanceof Page)) {
            return;
        }
        HashSet<String> labels = new HashSet<String>();
        labels.addAll((Collection<String>)CascadingLabel.cascadingLabelsForPage(page));
        labels.addAll((Collection<String>)BrikitString.split((String)labelString));
        BrikitList labelList = new BrikitList(labels);
        CascadingLabel.saveCascadingLabels(page, (BrikitList<String>)labelList);
    }

    public static boolean canCascadeLabels(String spaceKey) {
        return Confluence.canAdministerSpace((String)spaceKey) || Confluence.isGroupMember(CascadingLabel.userGroupsWithCascadePermission());
    }

    public static BrikitList<Filter> cascadingFiltersForPage(AbstractPage page) {
        BrikitList filters = new BrikitList();
        for (String label : CascadingLabel.cascadingLabelsForPage(page)) {
            Filter filter = Filter.getFilterByLabel(label);
            if (filter == null) continue;
            filters.add((Object)filter);
        }
        return filters;
    }

    public static void cascadingLabelsChangedOnPage(AbstractPage page, List<String> labels) {
        if (!(page instanceof Page)) {
            return;
        }
        for (String label : labels) {
            CascadingLabel.labelAddedToPage(page, label);
        }
    }

    public static BrikitList<String> cascadingLabelsForPage(AbstractPage page) {
        return Confluence.getContentPropertyList((ContentEntityObject)page, (String)CASCADING_LABELS);
    }

    protected static void convertCascadingLabelsMetaData(AbstractPage page) {
        if (!(page instanceof Page)) {
            return;
        }
        String metadata = Confluence.getMetaData((ContentEntityObject)page, (String)CASCADING_LABELS);
        if (!BrikitString.isSet((String)metadata)) {
            return;
        }
        Confluence.saveContentProperty((ContentEntityObject)page, (String)CASCADING_LABELS, (List)BrikitString.split((String)metadata, (String)DELIMITER));
        Confluence.removeMetaData((ContentEntityObject)page, (String)CASCADING_LABELS);
    }

    public static boolean hasCascadingLabelsForPage(AbstractPage page) {
        return !CascadingLabel.cascadingLabelsForPage(page).isEmpty();
    }

    public static BrikitList<Filter> inheritedLabelsForPage(AbstractPage page) {
        BrikitList filters = new BrikitList();
        if (!(page instanceof Page)) {
            return filters;
        }
        for (Page ancestor : Confluence.getAncestors((AbstractPage)page)) {
            if (ancestor.equals((Object)page)) continue;
            filters.addAll(CascadingLabel.cascadingFiltersForPage((AbstractPage)ancestor));
        }
        return filters;
    }

    public static BrikitList<String> inheritedLabelsAsStringsForPage(AbstractPage page) {
        BrikitList labels = new BrikitList();
        for (Filter filter : CascadingLabel.inheritedLabelsForPage(page)) {
            labels.add((Object)filter.getLabel());
        }
        return labels;
    }

    public static void labelAddedToPage(AbstractPage page, String label) {
        if (!(page instanceof Page)) {
            return;
        }
        if (CascadingLabel.cascadingLabelsForPage(page).contains((Object)label)) {
            AddPageToIndexerRunnable thread = new AddPageToIndexerRunnable((Page)page);
            new Thread(thread).start();
        }
    }

    public static void labelRemovedFromPage(AbstractPage page, String label) {
        if (!(page instanceof Page)) {
            return;
        }
        if (CascadingLabel.cascadingLabelsForPage(page).contains((Object)label)) {
            CascadingLabel.removeCascadingLabelFromPage(page, label);
            AddPageToIndexerRunnable thread = new AddPageToIndexerRunnable((Page)page);
            new Thread(thread).start();
        }
    }

    public static void removeCascadingLabelFromPage(AbstractPage page, String label) {
        if (!(page instanceof Page)) {
            return;
        }
        BrikitList<String> labels = CascadingLabel.cascadingLabelsForPage(page);
        while (labels.contains((Object)label)) {
            labels.remove((Object)label);
        }
        CascadingLabel.saveCascadingLabels(page, labels);
    }

    public static void saveCascadingLabels(AbstractPage page, BrikitList<String> labels) {
        Confluence.saveContentProperty((ContentEntityObject)page, (String)CASCADING_LABELS, labels);
        CascadingLabel.cascadingLabelsChangedOnPage(page, labels);
    }

    public static void saveUserGroupsWithCascadePermission(List<String> usergroups) {
        BrikitDataStore.setString((String)"", (String)"cascadingLabelUserGroups", (String)new BrikitList(usergroups).join(DELIMITER));
    }

    public static List<String> userGroupsWithCascadePermission() {
        return BrikitString.split((String)BrikitDataStore.getString((String)"", (String)"cascadingLabelUserGroups"), (String)DELIMITER);
    }

    protected static class AddPageToIndexerRunnable
    implements Runnable {
        protected Page page;

        public AddPageToIndexerRunnable(Page page) {
            this.page = page;
        }

        @Override
        public void run() {
            for (Page descendant : Confluence.getDescendants((Page)this.page)) {
                Confluence.addAbstractPageToIndexQueueForUpdate((AbstractPage)descendant, (boolean)false);
            }
        }
    }
}

