/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.actions;

import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.targetedsearch.actions.AbstractTargetedSearchAdminAction;
import com.brikit.targetedsearch.model.FilterGroup;
import com.brikit.targetedsearch.model.Folksonomy;
import com.brikit.targetedsearch.model.TargetedSearch;
import java.util.Collections;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class ManageFolksonomyAction
extends AbstractTargetedSearchAdminAction {
    protected String label;

    public List<String> getFolksonomy() {
        BrikitList<String> folksonomy = Folksonomy.getFolksonomyCopy();
        Collections.sort(folksonomy);
        return folksonomy;
    }

    public List<FilterGroup> getFilterGroups() {
        return FilterGroup.getFilterGroups();
    }

    public String getLabel() {
        return this.label;
    }

    @PermittedMethods(value={HttpMethod.POST})
    public String ignoreLabel() {
        JSONObject json = new JSONObject();
        if (!Folksonomy.isOnList(this.getLabel())) {
            json.put("error", (Object)this.getText("com.brikit.targetedsearch.label.not.in.folksonomy", Collections.singletonList(this.getLabel())));
        } else {
            Folksonomy.delete(this.getLabel());
            json.put("success", true);
        }
        this.setResult(json.toString());
        return "success";
    }

    @StrutsParameter
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void validate() {
        if (!TargetedSearch.canEditTaxonomy()) {
            this.addActionError(Confluence.getText((String)"config.insufficient.permissions"));
        }
    }
}

