/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.model;

import com.atlassian.json.jsonorg.JSONArray;
import com.brikit.core.confluence.BrikitBandanaManager;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.model.Filter;
import com.brikit.targetedsearch.model.FilterGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SearchSettings {
    public static final String TARGETED_SEARCH_CONFIG_KEY = "com.brikit.targetedsearch.config";
    public static final String FOLKSONOMY_KEY = "com.brikit.targetedsearch.folksonomy";
    public static final String RICH_LINKS_DISABLED_KEY = "com.brikit.targetedsearch.rich.links.disabled";
    public static final String REPLACE_DEFAULT_SEARCH_KEY = "com.brikit.targetedsearch.replace.search";
    public static final String ALLOW_DUPLICATE_FILTER_NAMES = "com.brikit.targetedsearch.allow.duplicate.filter.names";
    public static final String FOLKSONOMY_GROUP_NAME = "::FOLKSONOMY::";
    public static final int MAX_QUICK_SEARCH_RESULTS = 15;
    public static final int MAX_SEARCH_RESULTS = 200;

    public static boolean allowDuplicateFilterNames() {
        return BrikitBandanaManager.getBooleanEntry(null, ALLOW_DUPLICATE_FILTER_NAMES);
    }

    protected static JSONArray getTargetedSearchData() {
        String rawSettings = BrikitBandanaManager.getEntry(null, TARGETED_SEARCH_CONFIG_KEY);
        if (!BrikitString.isSet(rawSettings)) {
            return new JSONArray();
        }
        try {
            return new JSONArray(rawSettings);
        }
        catch (Exception e) {
            BrikitLog.logError("Unable to parse persisted settings: " + rawSettings, e);
            return new JSONArray();
        }
    }

    public static JSONArray getFolksonomy() {
        String raw = BrikitBandanaManager.getEntry(null, FOLKSONOMY_KEY);
        if (!BrikitString.isSet(raw)) {
            return new JSONArray();
        }
        try {
            return new JSONArray(raw);
        }
        catch (Exception ex) {
            BrikitLog.logError("Unable to parse persisted folksonomy: " + raw, ex);
            return new JSONArray();
        }
    }

    public static boolean isRichLinksDisabled() {
        return BrikitBandanaManager.getBooleanEntry(null, RICH_LINKS_DISABLED_KEY);
    }

    protected static void saveFolksonomy(JSONArray folksonomyData) {
        BrikitBandanaManager.saveEntry(null, FOLKSONOMY_KEY, folksonomyData.toString());
    }

    public static void setAllowDuplicateFilterNames(boolean toggle) {
        BrikitBandanaManager.saveEntry(null, ALLOW_DUPLICATE_FILTER_NAMES, toggle);
    }

    protected static void saveSettings(JSONArray settingsData) {
        BrikitBandanaManager.saveEntry(null, TARGETED_SEARCH_CONFIG_KEY, settingsData.toString());
        FilterGroup.resetCaches();
    }

    public static void setRichLinksDisabled(boolean toggle) {
        BrikitBandanaManager.saveEntry(null, RICH_LINKS_DISABLED_KEY, toggle);
    }

    public static Map<String, List<String>> sortFilterLabelsByFilterGroup(List<String> filterLabels) {
        HashMap<String, List<String>> selectedFilterGroups = new HashMap<String, List<String>>();
        if (filterLabels == null) {
            return selectedFilterGroups;
        }
        for (String filterLabel : filterLabels) {
            String filterGroupName;
            Filter filter = Filter.getFilterByLabel(filterLabel);
            String string = filterGroupName = filter == null ? FOLKSONOMY_GROUP_NAME : filter.getParent().getDisplayName();
            if (!selectedFilterGroups.containsKey(filterGroupName)) {
                selectedFilterGroups.put(filterGroupName, new ArrayList());
            }
            ((List)selectedFilterGroups.get(filterGroupName)).add(filterLabel);
        }
        return selectedFilterGroups;
    }
}

