/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.targetedsearch.macros;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Attachment;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.macros.BrikitMacroContext;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.brikit.targetedsearch.macros.AbstractFacetAwareMacro;
import java.util.List;
import java.util.Map;

public class UploadAttachmentButtonMacro
extends AbstractFacetAwareMacro {
    protected static final String APPLY_LABELS_KEY = "labels";
    public static final String TEMPLATE_NAME = "targeted-search/templates/upload-attachment-button.vm";

    @Override
    public String execute(Map parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        BrikitMacroContext macroContext = new BrikitMacroContext(parameters, body, conversionContext);
        String buttonName = macroContext.stringValue("image-name");
        if (BrikitString.isSet(buttonName)) {
            String ext = BrikitFile.fileExtension(buttonName);
            macroContext.velocityContextAdd("buttonName", BrikitFile.nameWithoutExtension(buttonName));
            macroContext.velocityContextAdd("ext", BrikitString.isSet(ext) ? ext : "png");
        }
        macroContext.velocityContextAdd("hasPermission", Confluence.hasCreatePermission(macroContext.getPage(), Attachment.class));
        macroContext.velocityContextAdd("uniqueId", this.localSafeId("upload-attachment-button-"));
        List<String> labels = macroContext.commaSeparatedListValue(APPLY_LABELS_KEY);
        BrikitList<String> labelsList = new BrikitList<String>(this.convertUserInputToLabels(labels, false));
        macroContext.velocityContextAdd(APPLY_LABELS_KEY, labelsList.join());
        return this.renderTemplate(TEMPLATE_NAME, macroContext);
    }

    @Override
    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

