/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.BlogPost;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.spaces.Space;
import com.brikit.contentflow.model.LastSpaceView;
import com.brikit.contentflow.model.PageActivity;
import com.brikit.contentflow.model.ao.SpaceActivityAO;
import com.brikit.contentflow.model.query.SpaceActivityQuery;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitMap;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class SpaceActivity
extends AbstractActiveObjectsModel {
    public static Comparator<SpaceActivity> DateOrder = new Comparator<SpaceActivity>(){

        @Override
        public int compare(SpaceActivity spaceActivity1, SpaceActivity spaceActivity2) {
            return spaceActivity1.getDate().compareTo(spaceActivity2.getDate());
        }
    };
    public static Comparator<SpaceActivity> SpaceOrder = new Comparator<SpaceActivity>(){

        @Override
        public int compare(SpaceActivity spaceActivity1, SpaceActivity spaceActivity2) {
            Space space1 = Confluence.getSpace((String)spaceActivity1.getSpaceKey());
            Space space2 = Confluence.getSpace((String)spaceActivity2.getSpaceKey());
            String spaceName1 = space1 == null ? "" : space1.getName();
            String spaceName2 = space2 == null ? "" : space2.getName();
            int result = spaceName1.compareToIgnoreCase(spaceName2);
            return result == 0 ? spaceActivity1.getDate().compareTo(spaceActivity2.getDate()) : result;
        }
    };
    protected SpaceActivityAO activeObject;

    protected SpaceActivity(ActiveObjects activeObjects, SpaceActivityAO activeObject) {
        super(activeObjects);
        this.setActiveObject(activeObject);
    }

    public static SpaceActivity create(ActiveObjects activeObjects, String spaceKey, Calendar date) {
        date = BrikitDate.dateOnly((Calendar)date);
        SpaceActivityAO SpaceActivityAO2 = (SpaceActivityAO)activeObjects.create(SpaceActivityAO.class, new DBParam[0]);
        SpaceActivityAO2.setSpaceKey(spaceKey);
        SpaceActivityAO2.setDate(date.getTime());
        SpaceActivity spaceActivity = new SpaceActivity(activeObjects, SpaceActivityAO2);
        spaceActivity.save();
        return spaceActivity;
    }

    public static void createBaselineActivityRecords(ActiveObjects activeObjects, String spaceKey) {
        Space space = Confluence.getSpace((String)spaceKey);
        if (space == null) {
            return;
        }
        for (Page page : Confluence.getAllPages((Space)space)) {
            PageActivity.createBaselineActivityRecord(activeObjects, page.getId());
        }
        for (BlogPost blogPost : Confluence.getAllBlogPosts((Space)space)) {
            PageActivity.createBaselineActivityRecord(activeObjects, blogPost.getId());
        }
    }

    public static void createBaselineActivityRecordsForSpace(ActiveObjects activeObjects, String spaceKey) {
        if (SpaceActivity.hasSpaceActivity(activeObjects, spaceKey)) {
            return;
        }
        Calendar lastViewed = SpaceActivity.lastViewed(activeObjects, spaceKey);
        if (lastViewed == null) {
            lastViewed = BrikitDate.getCalendar((int)1970, (int)1, (int)1);
        }
        SpaceActivity spaceActivity = SpaceActivity.create(activeObjects, spaceKey, lastViewed);
        spaceActivity.incrementViewCount();
    }

    public static void createBaselineActivityRecordsForAllSpaces(ActiveObjects activeObjects) {
        for (Space space : Confluence.getAllSpaces()) {
            SpaceActivity.createBaselineActivityRecordsForSpace(activeObjects, space.getKey());
        }
    }

    protected static List<SpaceActivity> fromActiveObjects(ActiveObjects activeObjects, SpaceActivityAO[] SpaceActivityAOs) {
        ArrayList<SpaceActivity> spaceActivities = new ArrayList<SpaceActivity>(SpaceActivityAOs.length);
        for (SpaceActivityAO SpaceActivityAO2 : SpaceActivityAOs) {
            spaceActivities.add(new SpaceActivity(activeObjects, SpaceActivityAO2));
        }
        return spaceActivities;
    }

    public static SpaceActivity getOrCreateSpaceActivity(ActiveObjects activeObjects, String spaceKey, Calendar date) {
        SpaceActivity spaceActivity = SpaceActivity.getSpaceActivity(activeObjects, spaceKey, date = BrikitDate.dateOnly((Calendar)date));
        if (spaceActivity == null) {
            spaceActivity = SpaceActivity.create(activeObjects, spaceKey, date);
        }
        return spaceActivity;
    }

    public static SpaceActivity getSpaceActivity(ActiveObjects activeObjects, String spaceKey, Calendar date) {
        SpaceActivityQuery query = new SpaceActivityQuery(activeObjects);
        SpaceActivityAO SpaceActivityAO2 = query.getSpaceActivity(spaceKey, date);
        return SpaceActivityAO2 == null ? null : new SpaceActivity(activeObjects, SpaceActivityAO2);
    }

    public static List<SpaceActivity> getSpaceActivityHistory(ActiveObjects activeObjects, String spaceKey, int daysOfHistory) {
        Calendar end = BrikitDate.getToday();
        Calendar start = BrikitDate.addDays((Calendar)end, (int)(-daysOfHistory));
        return SpaceActivity.getSpaceActivityHistory(activeObjects, spaceKey, start, end);
    }

    public static List<SpaceActivity> getSpaceActivityHistory(ActiveObjects activeObjects, String spaceKey, Calendar start, Calendar end) {
        SpaceActivityQuery query = new SpaceActivityQuery(activeObjects);
        return SpaceActivity.fromActiveObjects(activeObjects, query.getSpaceActivityHistory(spaceKey, start, end));
    }

    public static boolean hasSpaceActivity(ActiveObjects activeObjects, String spaceKey) {
        return SpaceActivity.latestSpaceActivity(activeObjects, spaceKey) != null;
    }

    public static void increaseViewCount(ActiveObjects activeObjects, String spaceKey, Calendar date, int views) {
        SpaceActivity.getOrCreateSpaceActivity(activeObjects, spaceKey, date).increaseViewCount(views);
    }

    public static void incrementViewCount(ActiveObjects activeObjects, String spaceKey, Calendar date) {
        SpaceActivity.increaseViewCount(activeObjects, spaceKey, date, 1);
    }

    public static Calendar lastViewed(ActiveObjects activeObjects, String spaceKey) {
        ContentEntityObject ceo;
        SpaceActivityQuery query = new SpaceActivityQuery(activeObjects);
        Date date = query.lastViewed(spaceKey);
        if (date == null && (ceo = (ContentEntityObject)new BrikitList(Confluence.getPageManager().getRecentlyModifiedEntities(spaceKey, 1)).first()) != null) {
            date = ceo.getLastModificationDate();
        }
        return date == null ? null : BrikitDate.toCalendar((Date)date);
    }

    public static SpaceActivity latestSpaceActivity(ActiveObjects activeObjects, String spaceKey) {
        SpaceActivityQuery query = new SpaceActivityQuery(activeObjects);
        SpaceActivityAO lastActivityAO = query.latestSpaceActivity(spaceKey);
        return lastActivityAO == null ? null : new SpaceActivity(activeObjects, lastActivityAO);
    }

    public void delete() {
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    public Space getSpace() {
        return Confluence.getSpace((String)this.getSpaceKey());
    }

    public SpaceActivityAO getActiveObject() {
        return this.activeObject;
    }

    public Calendar getDate() {
        return BrikitDate.toCalendar((Date)this.getActiveObject().getDate());
    }

    public int getID() {
        return this.getActiveObject().getID();
    }

    public String getSpaceKey() {
        return this.getActiveObject().getSpaceKey();
    }

    public static BrikitMap<String, Integer> getSpaceViewCounts(ActiveObjects activeObjects, int days) {
        Calendar end = BrikitDate.getToday();
        Calendar start = BrikitDate.addDays((Calendar)end, (int)(-1 * days));
        BrikitMap counts = new BrikitMap();
        for (Space space : Confluence.getAllSpaces()) {
            String spaceKey = space.getKey();
            for (SpaceActivity spaceActivity : SpaceActivity.getSpaceActivityHistory(activeObjects, spaceKey, start, end)) {
                Integer count = (Integer)counts.get((Object)spaceKey);
                count = (count == null ? 0 : count) + spaceActivity.getViewCount();
                counts.put((Object)spaceKey, (Object)count);
            }
        }
        return counts;
    }

    public int getViewCount() {
        return this.getActiveObject().getViewCount();
    }

    public void increaseViewCount(int views) {
        this.getActiveObject().setViewCount(this.getActiveObject().getViewCount() + views);
        this.getActiveObject().save();
        Calendar spaceLastViewed = this.getActiveObject().getViewCount() > 0 ? this.getDate() : SpaceActivity.lastViewed(this.getActiveObjects(), this.getSpaceKey());
        LastSpaceView.spaceViewed(this.activeObjects, this.getSpaceKey(), spaceLastViewed);
    }

    public void incrementViewCount() {
        this.increaseViewCount(1);
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setActiveObject(SpaceActivityAO activeObject) {
        this.activeObject = activeObject;
    }

    public void setDate(Calendar date) {
        this.setDate(date.getTime());
    }

    public void setDate(Date date) {
        this.getActiveObject().setDate(date);
    }
}

