/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.listeners;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostRemoveEvent;
import com.atlassian.confluence.event.events.content.blogpost.BlogPostViewEvent;
import com.atlassian.confluence.event.events.content.page.PageMoveEvent;
import com.atlassian.confluence.event.events.content.page.PageRemoveEvent;
import com.atlassian.confluence.event.events.content.page.PageViewEvent;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.spring.scanner.annotation.imports.ConfluenceImport;
import com.brikit.contentflow.model.PageActivity;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.listeners.BrikitActiveObjectsAwareEventListener;
import com.brikit.core.util.BrikitDate;
import javax.inject.Inject;
import javax.inject.Named;

@Named
public class PageActivityListener
extends BrikitActiveObjectsAwareEventListener {
    @Inject
    public PageActivityListener(@ConfluenceImport EventPublisher eventPublisher, @ConfluenceImport ActiveObjects activeObjects) {
        super(eventPublisher, activeObjects);
    }

    @EventListener
    public void blogPostRemoveEvent(BlogPostRemoveEvent event) {
        PageActivity.removeViewCounts(this.getActiveObjects(), event.getBlogPost().getId());
    }

    @EventListener
    public void blogPostViewEvent(BlogPostViewEvent event) {
        PageActivity.pageViewed(this.getActiveObjects(), event.getBlogPost().getId(), BrikitDate.getToday());
    }

    @EventListener
    public void pageMoveEvent(PageMoveEvent event) {
        String toSpaceKey;
        String fromSpaceKey = event.getOldSpace().getKey();
        if (fromSpaceKey.equalsIgnoreCase(toSpaceKey = Confluence.getSpaceKey((AbstractPage)event.getPage()))) {
            return;
        }
        PageActivity.transferViewCounts(this.getActiveObjects(), event.getPage().getId(), fromSpaceKey, toSpaceKey);
    }

    @EventListener
    public void pageRemoveEvent(PageRemoveEvent event) {
        PageActivity.removeViewCounts(this.getActiveObjects(), event.getPage().getId());
    }

    @EventListener
    public void pageViewEvent(PageViewEvent event) {
        PageActivity.pageViewed(this.getActiveObjects(), event.getPage().getId(), BrikitDate.getToday());
    }
}

