/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.actions;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.DefaultConversionContext;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.velocity.htmlsafe.HtmlSafe;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.contentflow.model.Publisher;
import com.brikit.core.confluence.Confluence;
import java.util.List;

@AnonymousSiteAccess
public class ViewPageAction
extends com.atlassian.confluence.pages.actions.ViewPageAction {
    private static final String INITIAL_PAGE_PLACEHOLDER = "com.brikit.contentflow.initial.page.placeholder";
    private String pageXHtmlContent;
    private List externalReferences;
    protected ActiveObjects activeObjects;

    @PermittedMethods(value={HttpMethod.GET, HttpMethod.POST})
    @XsrfProtectionExcluded
    public String execute() throws Exception {
        if (this.getPage() != null && this.getPage().getSpace() == null && this.getPage().isLatestVersion()) {
            this.addActionError(Confluence.getText((String)"error.corrupt.page", (Object[])new Object[]{"" + this.getPage().getId(), this.getPage().getBodyContent().getBody()}));
            return "error";
        }
        AbstractPage publishedPage = Publisher.getVersionToDisplay(this.getActiveObjects(), this.getPage(), this.showPublished());
        if (publishedPage == null) {
            this.setPageXHtmlContent("<p class=\"content-flow-initial-page-placeholder\">" + Confluence.getText((String)INITIAL_PAGE_PLACEHOLDER) + "</p>");
            return this.getPage().getType();
        }
        AbstractPage page = (AbstractPage)Confluence.getXhtmlContent().convertWikiBodyToStorage((ContentEntityObject)publishedPage);
        this.setPageXHtmlContent(this.viewRenderer.render(page.getBodyAsString(), (ConversionContext)new DefaultConversionContext(Confluence.getRenderContext((AbstractPage)this.getPage()))));
        this.setExternalReferences(page.toPageContext().getExternalReferences());
        this.addToHistory((ContentEntityObject)this.getPage());
        return this.getPage().getType();
    }

    public boolean showPublished() {
        return Publisher.isPublishedVersionRequested();
    }

    public List getExternalReferences() {
        return this.externalReferences;
    }

    @HtmlSafe
    public String getPageXHtmlContent() {
        return this.pageXHtmlContent;
    }

    public WebInterfaceContext getWebInterfaceContext() {
        DefaultWebInterfaceContext result = DefaultWebInterfaceContext.copyOf((WebInterfaceContext)super.getWebInterfaceContext());
        if (this instanceof ViewPageAction) {
            result.setParameter("viewMode", (Object)Boolean.TRUE);
        }
        return result;
    }

    protected void setExternalReferences(List externalReferences) {
        this.externalReferences = externalReferences;
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public void setActiveObjects(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    protected void setPageXHtmlContent(String pageXHtmlContent) {
        this.pageXHtmlContent = pageXHtmlContent;
    }
}

