/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.actions;

import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.contentflow.actions.ContentFlowActionSupport;
import com.brikit.contentflow.settings.PublishDateManager;
import com.brikit.core.util.BrikitDate;
import java.text.ParseException;
import java.util.Calendar;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class PublishDateMetadataAction
extends ContentFlowActionSupport {
    protected String publishDate;

    @Override
    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        Calendar publishDate = PublishDateManager.getPublishDate(this.getPage());
        if (publishDate != null) {
            this.setPublishDate(BrikitDate.formatSimpleDate((Calendar)publishDate));
        }
        return super.execute();
    }

    public String getPublishDate() {
        return this.publishDate;
    }

    @PermittedMethods(value={HttpMethod.POST})
    public String savePublishDate() {
        try {
            PublishDateManager.setPublishDate(this.getPage(), this.getPublishDate());
        }
        catch (ParseException ex) {
            this.addActionError(this.getText("com.brikit.contentflow.invalidate.publish.date.format"));
            return "error";
        }
        return "success";
    }

    @StrutsParameter
    public void setPublishDate(String publishDate) {
        this.publishDate = publishDate;
    }
}

