/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.actions;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.xwork.HttpMethod;
import com.atlassian.xwork.PermittedMethods;
import com.brikit.contentflow.actions.ContentFlowActionSupport;
import com.brikit.contentflow.model.ContentFlow;
import com.brikit.contentflow.model.ContentFlowConfiguration;
import com.brikit.contentflow.model.PageStatus;
import com.brikit.contentflow.model.PageWorkflow;
import com.brikit.contentflow.model.Publisher;
import com.brikit.core.confluence.Confluence;

public class PageInfoBannerAction
extends ContentFlowActionSupport {
    PluginLicenseManager pluginLicenseManager;

    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    protected void addMenuItem(JSONArray menuItems, String titleKey, String cssClass) {
        JSONObject menuItem = new JSONObject();
        menuItem.put("type", (Object)"link");
        menuItem.put("content", (Object)Confluence.getText((String)titleKey));
        menuItem.put("class", (Object)(cssClass + " page-info-status-item"));
        menuItems.put((Object)menuItem);
    }

    protected void addMenuItemForAlternateView(JSONArray menuItems) {
        if (this.canSwitchToPublishedVersion()) {
            this.addMenuItem(menuItems, "com.brikit.contentflow.view.published.title", "view-published-version");
        }
        if (this.canSwitchToUnpublishedVersion()) {
            this.addMenuItem(menuItems, "com.brikit.contentflow.view.draft.title", "view-draft-version");
        }
    }

    protected boolean canSwitchToPublishedVersion() {
        return Publisher.canSwitchToPublishedVersion(this.getActiveObjects(), this.getPage());
    }

    protected boolean canSwitchToUnpublishedVersion() {
        return Publisher.canSwitchToUnpublishedVersion(this.getActiveObjects(), this.getPage());
    }

    @Override
    @PermittedMethods(value={HttpMethod.GET})
    public String execute() {
        AbstractPage page;
        JSONObject json = new JSONObject();
        if (!ContentFlow.isLicensed(this.getPluginLicenseManager())) {
            json.put("status", (Object)"Unlicensed");
            json.put("classes", (Object)"unlicensed");
            JSONArray menuItems = new JSONArray();
            this.addMenuItem(menuItems, "Brikit Content Flow is unlicensed", "unlicensed-link");
            json.put("menuItems", (Object)menuItems);
            return this.setJSONSuccess(json);
        }
        ActiveObjects ao = this.getActiveObjects();
        boolean displayingDraft = Publisher.displayingDraft(ao, page = this.getPage());
        String status = displayingDraft ? "com.brikit.contentflow.view.unpublished.name" : "com.brikit.contentflow.view.published.name";
        PageStatus pageStatus = PageStatus.getPageStatusForPage(this.getActiveObjects(), this.getPage());
        status = pageStatus != null ? pageStatus.getName() : Confluence.getText((String)status);
        json.put("status", (Object)status);
        String classes = "";
        JSONArray menuItems = new JSONArray();
        if (this.hasPageWorkflow()) {
            if (displayingDraft) {
                if (this.getPageWorkflow().currentUserNeedsToApprove()) {
                    this.addMenuItem(menuItems, "com.brikit.contentflow.notification.approve.reject.title", "approve-workflow-trigger");
                    classes = classes + "needs-your-approval";
                    json.put("tooltip", (Object)Confluence.getText((String)"com.brikit.contentflow.page.needs.your.review"));
                    if (this.getPageWorkflow().currentUserCanRemove()) {
                        this.addMenuItem(menuItems, "com.brikit.contentflow.remove.workflow.title", "remove-workflow-link");
                    }
                } else {
                    if (PageWorkflow.userCanViewWorkflow(ao, page)) {
                        this.addMenuItem(menuItems, "com.brikit.contentflow.view.workflow.title", "view-workflow-trigger");
                    }
                    if (this.getPageWorkflow().currentUserCanRemove()) {
                        this.addMenuItem(menuItems, "com.brikit.contentflow.remove.workflow.title", "remove-workflow-link");
                    }
                }
            } else if (PageWorkflow.userCanViewWorkflow(ao, page)) {
                this.addMenuItem(menuItems, "com.brikit.contentflow.view.workflow.title", "view-workflow-trigger");
            }
            this.addMenuItemForAlternateView(menuItems);
        } else if (Confluence.canEdit((AbstractPage)page) && ContentFlowConfiguration.canUseWorkflows(ao, page)) {
            this.addMenuItem(menuItems, "com.brikit.contentflow.apply.workflow.title", "apply-workflow-trigger");
        }
        json.put("menuItems", (Object)menuItems);
        json.put("classes", (Object)classes);
        json.put("pageUrl", (Object)Confluence.getUrlPath((ContentEntityObject)this.getPage()));
        return this.setJSONSuccess(json);
    }
}

