/*
	NOTE
	This class is only used (and assumes it is being used) within edit-dialog.js (in an editing, not viewing, context)
*/
(function ($) {
	
	ContentFlowWorkflowPanel = function (dialog) {
		this.dialog = dialog;
		this.panel = dialog.find("#workflow-details");
		this.initialize();
	};
		
	ContentFlowWorkflowPanel.prototype = {
		// TODO: addFlowDialog poss obsolete;  test delete (after stable code)
		addFlowDialog: "",
		createApprovalStepDialog: "",
		createNewFlowDialog: "",
		newFlow: "",
		
		addApprovalStep: function () {
			ContentFlow.$(".add-workflow-step-hint").hide();
			
			var $lastStep = ContentFlow.$(".approval-step").last();
			var $newStep = this.newStepModel.clone();
            this.initializePageStatusField($newStep.find(".add-page-status-field"));

			$lastStep.after($newStep);

			$newStep.find(".autocomplete-user-or-group").attr("autocomplete", "off").removeAttr("data-autocomplete-user-or-group-bound");
			Confluence.Binder.autocompleteUserOrGroup();

			this.adjustWarnings();
			this.formValueChanged();

			// Move the hide/fade to here because of a problem rendering in Firefox (FLOW-53)
			var self = this;
			$newStep.hide().fadeIn(function () {
				self.focusReviewStep($newStep);
			});

			return false;
		},
		
		addApprovalStepButton: function () {
			return ContentFlow.$("#add-approval-step-button");
		},

		addPageStatusField: function () {
			return this.currentApprovalStep().find(".add-page-status-field");
		},

		addReviewerField: function () {
			return this.currentApprovalStep().find(".add-reviewer-field");
		},
		
		addReviewerSelected: function (event, data) {
			event.preventDefault();
			event.stopPropagation();

			var content = data.content;
			var isUser = content.type == "user";
			var username = isUser ? content.username : content.name;
			
			// If user or group not found, stop
			if (!username) return;
			
			// Check that the user isn't already on the step
			var $step = $(event.target).closest(".approval-step");
			var approvalStep = new ContentFlow.ApprovalStep($step);
			var $existingMatch = isUser ? $step.find(".reviewer-entry[data-username='" + username + "']") : $step.find(".reviewer-entry[data-groupname='" + username + "']");
			if ($existingMatch.length) {
				ContentFlow.highlight($existingMatch);
				return false;
			}
			
	        jQuery.ajax({
	            url: ContentFlow.contextPath + "/plugins/contentflow/renderreviewer.action",
				data: {
					username: username,
					user: isUser
				},
	            success: function(response) {	
	                this.reviewerList(self.currentApprovalStep()).append(response).find(".warning").remove();					
					this.clearReviewerSearch();					
					Confluence.Binder.userHover();					
					this.formValueChanged();
	            }.bind(this),
	            error: function (xhRequest, textStatus, errorThrown) {	
	                ContentFlow.alertError("An error occurred while handling the new reviewer.", errorThrown);
	            }
	        });
		},
		
		adjustVisibility: function () {
			this.adjustWarnings();
		},

		adjustWarnings: function () {
			var self = this;
			self.footerHint().removeClass("needs-warning");
			ContentFlow.$(".approval-step").each(function () {
				if (!$(".reviewer-entry", this).length) self.footerHint().addClass("needs-warning");
			});
		},

		approvalStepAddPageStatus: function (event, target) {
			var pageStatusId = this.addPageStatusField().select2('data').id;
            var pageStatusName = this.addPageStatusField().select2('data').text;
			
			var $label = $("<span>").adjustClass("aui-label", pageStatusName).adjustClass("no-page-status", !pageStatusName).text(pageStatusName);
			this.approvalStepPageStatus(this.currentApprovalStep()).find(".approval-step-page-status").attr("data-id", pageStatusId).empty().append($label);
			this.formValueChanged();
		},
		
		approvalStepPageStatus: function (step) {
			return $(step).find(".page-status");
		},
		
		clearReviewerSearch: function () {
			this.addReviewerField().val("");
		},
		
		currentApprovalStep: function () {
			return ContentFlow.$(".approval-step.focused");
		},
		
		currentApprovalStepPageStatus: function () {
			return this.approvalStepPageStatus(this.currentApprovalStep()).find(".aui-label");
		},
		
		currentApprovalStepPageStatusText: function () {
			return $.trim(this.currentApprovalStepPageStatus().first().text());
		},
		
		find: function(selector) {
			return selector ? $(selector, this.panel) : this.panel;
		},
			
		focusReviewStep: function (newStep) {
			self = this;
			ContentFlow.$(".approval-step").removeClass("focused adding-label");
			// class 'focused' works in conjunction with other css classes to toggle 
			// visibility of some widgets (e.g. add-page-status field)
			if (self.isEditing() && !$(newStep).hasClass("editor-step")) $(newStep).addClass("focused");
			self.adjustVisibility();
			return false;
		},
		
		footerActions: function () {
			return this.dialog.find(".aui-dialog2-footer-actions");
		}, 
		
		footerHint: function () {
			return this.dialog.find(".aui-dialog2-footer-hint");
		}, 
		
		formValueChanged: function (e) {
			this.isDirty = true;
			this.adjustVisibility();
			this.dialog.adjustVisibility();
		},
		
		// TODO:  Obsolete code?  Who calls?
	    handleValidateNewFlowName: function (data, textStatus, jqXHR) {

	        if (data.success) {
	            this.createNewFlowDialog.hide();
	            this.getCreateApprovalStepDialog().show();

	        } else {
	            newFlow = "";
	            var message = data.message;

	            if ($("#new-flow-name-field", ContentFlow.currentDialog).find("div.error").length == 0)
	                $("#new-flow-name-field", ContentFlow.currentDialog).append("<div class='error'>" + message + "</div>");
	        }

	        return false;
	    },

		// TODO:  Obsolete code?  Who calls?
	    handleValidateNewReviewerName: function (data, textStatus, jqXHR) {

	        if (data.success) {

	            $("#add-approval-step-reviewers", ContentFlow.currentDialog).append($("<li></li>")
	                .html(data.reviewer_name)
	                .addClass('#new-reviewer-name'));

	            $("#new-reviewer-name", ContentFlow.currentDialog).val("");

	            if ($("#new-approval-step-reviewers", ContentFlow.currentDialog).find("div.error").length != 0)
	                $("#new-approval-step-reviewers", ContentFlow.currentDialog).find("div.error").remove();

	        } else {
	            var message = data.message;
	            if ($("#new-approval-step-reviewers", ContentFlow.currentDialog).find("div.error").length == 0)
	                $("#new-approval-step-reviewers", ContentFlow.currentDialog).append("<div class='error'>" + message + "</div>");
	        }

	        return false;
	    },
		
		initialize: function () {

			// Rewire user logo links so they don't have the popup/hover panel nonsense in the editor
			this.find(".reviewer-list .userLogoLink")
				.removeClass("userLogoLink").addClass("reviewerLogoLink")
				.find("[title]").removeAttr("title");
				
			// Insert add-step button and style it
			var $addStepButton = $("<button id='add-approval-step-button' class='aui-button aui-button-primary button-panel-button'>").text(ContentFlow.getText("com.brikit.contentflow.step"));
			$addStepButton.prepend($("<span>").addClass("aui-icon aui-icon-small aui-iconfont-add"));
			this.footerActions().prepend($addStepButton);
		
			// Click bind the add-approval-step button
			$addStepButton.click( function (e) { this.addApprovalStep(); }.bind(this) );
		
			// Insert "empty step removal" caution
			var $warning = $("<p>").addClass("approval-step-warning");
			$warning.text(" " + ContentFlow.getText("com.brikit.contentflow.empty.steps.will.be.removed"));
			$warning.prepend($("<span>").addClass("aui-icon aui-icon-small aui-iconfont-info"));
			this.footerHint().append($warning);

			var self = this;	
			this.find()			
				.on("click.brikit-content-flow", 	".approval-step.modifiable",		function () { self.focusReviewStep(this); })
				.on("click.brikit-content-flow", 	".remove-reviewer-button", 			function (e) { self.removeReviewer(e, this); })
			
				.on("selected.autocomplete-user-or-group", 	".add-reviewer", 			this.addReviewerSelected.bind(this))
		
				// .on("click.brikit-content-flow", 	".approval-step .add-page-status-field", 	function (e) { e.stopPropagation(); })
				.on("change", 						".approval-step .add-page-status-field", 	function (e) { self.approvalStepAddPageStatus(e, this); })
				// we're re-using the Confluence userLogoLink (in reviewerLogoLink), but don't want its click-thru behavior:
				.on("click.brikit-content-flow", 	".reviewer-list .reviewerLogoLink", function () { $(this).closest(".approval-step").click(); return false; })

				.on("click", 				".workflow-labels .aui-label .aui-icon-close",	function (e) { self.workflowPageStatusRemove(e, this); })
				.on("keydown", 				".workflow-labels .add-page-status-field", 			function (e) { self.workflowAddPageStatusPressed(e, this); }.bind(self));

			this.find(".reviewer-entry.editor .reviewer-name").tooltip({aria:true});
            
            // Before initializing the select2 field, create a copy of the last step to be the model for future steps
			this.newStepModel = ContentFlow.$(".approval-step").last()
					.clone()
					.attr("data-approval-step-id", "0")
					.addClass("modifiable")
					.removeClass("aui-progress-tracker-step-current editor-step");
			this.reviewerList(this.newStepModel).empty();
			this.approvalStepPageStatus(this.newStepModel).find(".aui-label").remove();
            this.newStepModel.find(".add-page-status-field option[selected]").removeAttr("selected");
            
            this.initializePageStatusField(this.find(".page-status .add-page-status-field"));
			Confluence.Binder.autocompleteUserOrGroup();
			this.adjustVisibility();
		},
        
        initializePageStatusField: function ($field) {
          $field.auiSelect2({
              placeholder: ContentFlow.getText('com.brikit.contentflow.select.page.status'),
              allowClear: true
          })  
        },
        
		isEditing: function () {
			return ContentFlow.$("#manage-content-flow-form").hasClass("editing");
		},
		
		publishOnApprovalChanged: function () {
			this.formValueChanged();
		},
		
		removeReviewer: function (event, target) {
			event.preventDefault();
			$(target).tooltip({aria:false}); // Clears any floating tooltips
			$(target).closest(".reviewer-entry").remove();
			this.adjustWarnings();
			this.formValueChanged();
			return false;
		},

		reviewerList: function (step) {
			return $(step).find(".reviewer-list");
		},
	
		validateInput: function (showErrors) {
			// Will default to Editor single-step, so no validation needed
			return true;
		},
		
		workflowAddPageStatusPressed: function (event, target) {
			// if return key pressed...
            if (event.keyCode == 13) { 
				var labelString = $(target).val();
				if (!ContentFlow.isValidLabel(labelString)) {
					alert(ContentFlow.getText("com.brikit.contentflow.invalid.label"));
					return false;
				}
				var $labels = $(target).closest(".workflow-labels");
				
				// Check that the label isn't already on the step
				var $existingLabel = $labels.find(".aui-label").filter(function () { return $(this).text() == labelString });
				if ($existingLabel.length) {
					ContentFlow.highlight($existingLabel);
					return false;
				};				
				
				var $label = $("<span>").addClass("aui-label aui-label-closeable").text(labelString);
				$label.append($("<span>").addClass("aui-icon aui-icon-close"));
				$labels.append($label);
				$(target).val("");
				this.formValueChanged();
				$(target).focus();
                return false;
            }
            return true;
			
		},
		
		workflowPageStatusRemove: function (event, target) {
			event.stopPropagation();

			var $label = $(target).closest(".aui-label");
			var $labels = $(target).closest(".workflow-labels");
			$labels.find(".add-page-status-field").val($label.text()).focus();
			$label.remove();
			this.formValueChanged();
		}

        // workflowLabels: function (step) {
        //     return $(step).find(".approval-step-page-status");
        // }
		
	};

})(jQuery);
