/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model.query;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.brikit.contentflow.model.WorkflowVisibility;
import com.brikit.contentflow.model.ao.WorkflowAO;
import com.brikit.core.ao.AbstractQuery;
import net.java.ao.Query;

public class WorkflowQuery
extends AbstractQuery {
    public WorkflowQuery(ActiveObjects activeObjects) {
        super(activeObjects);
    }

    public WorkflowAO[] getAllWorkflows() {
        return (WorkflowAO[])this.getActiveObjects().find(WorkflowAO.class);
    }

    public WorkflowAO[] getAvailableWorkflows(String spaceKey) {
        Query query = Query.select().where("VISIBILITY = ? or (VISIBILITY = ? and SPACE_KEY = ?)", new Object[]{WorkflowVisibility.GLOBAL.name(), WorkflowVisibility.SPACE.name(), spaceKey});
        return this.runQuery(query);
    }

    public WorkflowAO[] getGlobalWorkflows() {
        return this.getWorkflowsWithVisibility(WorkflowVisibility.GLOBAL);
    }

    public WorkflowAO[] getSpaceCategoryWorkflows() {
        return this.getWorkflowsWithVisibility(WorkflowVisibility.SPACE_CATEGORIES);
    }

    public WorkflowAO getWorkflowWithId(int id) {
        return (WorkflowAO)this.getActiveObjects().get(WorkflowAO.class, (Object)id);
    }

    public WorkflowAO[] getWorkflowsByName(String name) {
        Query query = Query.select().where("NAME = ?", new Object[]{name});
        return this.runQuery(query);
    }

    public WorkflowAO[] getWorkflowsByNameExcludingID(String name, int excludeID) {
        Query query = Query.select().where("ID != ? and NAME IS NOT NULL and NAME = ?", new Object[]{excludeID, name});
        return this.runQuery(query);
    }

    public WorkflowAO[] getWorkflowsWithVisibility(WorkflowVisibility visibility) {
        Query query = Query.select().where("VISIBILITY = ?", new Object[]{visibility.name()});
        return this.runQuery(query);
    }

    protected WorkflowAO[] runQuery(Query query) {
        return query == null ? new WorkflowAO[]{} : (WorkflowAO[])this.getActiveObjects().find(WorkflowAO.class, query);
    }
}

