/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model.query;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.brikit.contentflow.model.ao.SpaceActivityAO;
import com.brikit.core.ao.AbstractQuery;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitList;
import java.util.Calendar;
import java.util.Date;
import net.java.ao.Query;

public class SpaceActivityQuery
extends AbstractQuery {
    public SpaceActivityQuery(ActiveObjects activeObjects) {
        super(activeObjects);
    }

    protected int countQuery(Query query) {
        return query == null ? 0 : this.getActiveObjects().count(SpaceActivityAO.class, query);
    }

    public SpaceActivityAO[] getAllSpaceActivityHistory(String spaceKey) {
        Query query = Query.select().where("SPACE_KEY = ?", new Object[]{spaceKey});
        return this.runQuery(query);
    }

    public SpaceActivityAO[] getSpaceActivityHistory(String spaceKey, Calendar start, Calendar end) {
        return this.getSpaceActivityHistory(spaceKey, start.getTime(), end.getTime());
    }

    public SpaceActivityAO[] getSpaceActivityHistory(String spaceKey, Date start, Date end) {
        start = BrikitDate.dateOnly((Date)start);
        end = BrikitDate.dateOnly((Date)end);
        Query query = Query.select().where("SPACE_KEY = ? AND DATE >= ? AND DATE <= ?", new Object[]{spaceKey, start, end});
        return this.runQuery(query);
    }

    public SpaceActivityAO getSpaceActivity(String spaceKey, Calendar date) {
        return this.getSpaceActivity(spaceKey, date.getTime());
    }

    public SpaceActivityAO getSpaceActivity(String spaceKey, Date date) {
        date = BrikitDate.dateOnly((Date)date);
        Query query = Query.select().limit(1).where("SPACE_KEY = ? AND DATE = ?", new Object[]{spaceKey, date});
        return (SpaceActivityAO)new BrikitList((Object[])this.runQuery(query)).first();
    }

    public Date lastViewed(String spaceKey) {
        Query query = Query.select().limit(1).where("SPACE_KEY = ? AND VIEW_COUNT > 0", new Object[]{spaceKey}).order("DATE DESC");
        SpaceActivityAO lastActivity = (SpaceActivityAO)new BrikitList((Object[])this.runQuery(query)).first();
        return lastActivity == null ? null : lastActivity.getDate();
    }

    public SpaceActivityAO latestSpaceActivity(String spaceKey) {
        Query query = Query.select().limit(1).where("SPACE_KEY = ? AND VIEW_COUNT > 0", new Object[]{spaceKey}).order("DATE DESC");
        return (SpaceActivityAO)new BrikitList((Object[])this.runQuery(query)).first();
    }

    protected SpaceActivityAO[] runQuery(Query query) {
        return query == null ? new SpaceActivityAO[]{} : (SpaceActivityAO[])this.getActiveObjects().find(SpaceActivityAO.class, query);
    }
}

