/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.actions;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.user.ConfluenceUser;
import com.brikit.contentflow.model.ContentFlowConfiguration;
import com.brikit.contentflow.model.Workflow;
import com.brikit.contentflow.upgrade.InstallAutomaticWorkflowTask;
import com.brikit.core.confluence.Confluence;
import java.util.List;

public class GlobalWorkflowsAction
extends ConfluenceActionSupport {
    protected ActiveObjects activeObjects;
    protected List<Workflow> workflows;

    public String execute() throws Exception {
        this.workflows = null;
        return "success";
    }

    public String generateDefaultWorkflow() {
        ConfluenceUser user = Confluence.getConfluenceUser();
        if (user == null || !user.getEmail().contains("brikit")) {
            System.out.println("Attempted unauthorized use of generateDefaultWorkflow");
            return "error";
        }
        InstallAutomaticWorkflowTask installer = new InstallAutomaticWorkflowTask();
        installer.setActiveObjects(this.getActiveObjects());
        try {
            installer.doUpgrade();
            return "success";
        }
        catch (Exception e) {
            e.printStackTrace();
            return "error";
        }
    }

    public ActiveObjects getActiveObjects() {
        return this.activeObjects;
    }

    public List<Workflow> getAvailableWorkflows() {
        if (this.workflows == null) {
            this.workflows = Workflow.getGlobalWorkflows(this.getActiveObjects());
        }
        return this.workflows;
    }

    public ContentFlowConfiguration getConfiguration() {
        return ContentFlowConfiguration.getGlobalConfiguration(this.getActiveObjects());
    }

    public void setActiveObjects(ActiveObjects activeObjects) {
        this.activeObjects = activeObjects;
    }

    public void validate() {
        super.validate();
        if (!Confluence.isConfluenceAdministrator()) {
            this.addActionError(this.getText("config.insufficient.permissions"));
        }
    }
}

