/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.actions;

import com.atlassian.confluence.pages.AbstractPage;
import com.brikit.contentflow.actions.ContentFlowActionSupport;
import com.brikit.contentflow.model.ArchivedPage;
import com.brikit.core.confluence.Confluence;
import java.util.List;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

public class BulkRestoreAction
extends ContentFlowActionSupport {
    protected List<String> pageIds;

    @Override
    public String execute() throws Exception {
        boolean keepGoing = true;
        while (keepGoing) {
            keepGoing = false;
            for (String pageIdString : this.getPageIds()) {
                ArchivedPage archivedPage = ArchivedPage.getArchivedPageForPage(this.getActiveObjects(), pageIdString);
                if (archivedPage == null) continue;
                AbstractPage parent = archivedPage.getOriginalParentPage();
                if (parent != null && (parent.isDeleted() || !archivedPage.getOriginalSpaceKey().equals(Confluence.getSpaceKey((AbstractPage)parent)))) {
                    keepGoing = true;
                    continue;
                }
                archivedPage.unarchive();
            }
        }
        return "success";
    }

    public List<String> getPageIds() {
        return this.pageIds;
    }

    @StrutsParameter
    public void setPageIds(List<String> pageIds) {
        this.pageIds = pageIds;
    }
}

