/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.brikit.contentflow.model.ContentFlowConfiguration;
import com.brikit.contentflow.model.ContentFlowUtils;
import com.brikit.contentflow.model.WorkflowVisibility;
import com.brikit.contentflow.model.ao.ArchivePolicyAO;
import com.brikit.contentflow.model.query.ArchivePolicyQuery;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitDate;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class ArchivePolicy
extends AbstractActiveObjectsModel {
    protected static final String NAME_KEY = "name";
    protected static final String VISIBILITY_KEY = "visibility";
    protected static final String SPACE_CATEGORIES_KEY = "spaceCategories";
    protected static final String SPACE_KEY = "spaceKey";
    protected static final String REVIEW_AFTER_KEY = "reviewAfter";
    protected static final String ARCHIVE_AFTER_KEY = "archiveAfter";
    protected static final String AFTER_DAYS_IN_REVIEW = "AFTER_DAYS_IN_REVIEW";
    protected static final String DAYS_AFTER_PUBLISHED = "DAYS_AFTER_PUBLISHED";
    protected static final String DAYS_AFTER_LAST_VIEW = "DAYS_AFTER_LAST_VIEW";
    protected static final int DEFAULT_REVIEW_DAYS = 180;
    protected static final int DEFAULT_ARCHIVE_DAYS = 90;
    protected ArchivePolicyAO activeObject;

    public ArchivePolicy(ActiveObjects activeObjects, ArchivePolicyAO activeObject) {
        super(activeObjects);
        this.activeObject = activeObject;
    }

    public static ArchivePolicy create(ActiveObjects activeObjects, String name) {
        ArchivePolicyAO archivePolicyAO = (ArchivePolicyAO)activeObjects.create(ArchivePolicyAO.class, new DBParam[0]);
        archivePolicyAO.setName(name);
        ArchivePolicy archivePolicy = new ArchivePolicy(activeObjects, archivePolicyAO);
        archivePolicy.save();
        return archivePolicy;
    }

    public static ArchivePolicy createForSpace(ActiveObjects activeObjects, String spaceKey) {
        ArchivePolicyAO archivePolicyAO = (ArchivePolicyAO)activeObjects.create(ArchivePolicyAO.class, new DBParam[0]);
        archivePolicyAO.setSpaceKey(spaceKey);
        ArchivePolicy archivePolicy = new ArchivePolicy(activeObjects, archivePolicyAO);
        archivePolicy.save();
        return archivePolicy;
    }

    public static String ensureNameIsUnique(ActiveObjects activeObjects, String name, int archivePolicyID) {
        String originalName = name;
        int adjuster = 1;
        while (!ArchivePolicy.getArchivePoliciesByNameExcludingID(activeObjects, name, archivePolicyID).isEmpty()) {
            name = originalName + " " + ++adjuster;
        }
        return name;
    }

    public static ArchivePolicy forPage(ActiveObjects activeObjects, AbstractPage abstractPage) {
        ContentFlowConfiguration configuration = ContentFlowConfiguration.forPage(activeObjects, abstractPage);
        return configuration == null ? null : configuration.getArchivePolicy();
    }

    public static ArchivePolicy forPage(ActiveObjects activeObjects, long pageId) {
        return ArchivePolicy.forPage(activeObjects, Confluence.getPageOrBlogPost((long)pageId));
    }

    protected static List<ArchivePolicy> fromActiveObjects(ActiveObjects activeObjects, ArchivePolicyAO[] archivePolicyAOs) {
        ArrayList<ArchivePolicy> archivePolicies = new ArrayList<ArchivePolicy>(archivePolicyAOs.length);
        for (ArchivePolicyAO archivePolicyAO : archivePolicyAOs) {
            archivePolicies.add(new ArchivePolicy(activeObjects, archivePolicyAO));
        }
        return archivePolicies;
    }

    public static List<ArchivePolicy> getArchivePoliciesByNameExcludingID(ActiveObjects activeObjects, String name, int excludeID) {
        ArchivePolicyQuery query = new ArchivePolicyQuery(activeObjects);
        return ArchivePolicy.fromActiveObjects(activeObjects, query.getArchivePoliciesByNameExcludingID(name, excludeID));
    }

    public Calendar calculateReviewDeadline(AbstractPage abstractPage) {
        Date lastModified = abstractPage.getLastModificationDate();
        return BrikitDate.addDays((Calendar)BrikitDate.toCalendar((Date)lastModified), (int)this.getArchiveAfterDaysInReview());
    }

    public void delete() {
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    public ArchivePolicyAO getActiveObject() {
        return this.activeObject;
    }

    public int getArchiveAfterDaysInReview() {
        int days = this.getActiveObject().getArchiveAfterDaysInReview();
        return days < 1 ? 90 : days;
    }

    public String getArchivePolicy() {
        return this.getActiveObject().getArchivePolicy();
    }

    public Space getArchiveSpace() {
        return Confluence.getSpace((String)this.getArchiveSpaceKey());
    }

    public String getArchiveSpaceKey() {
        return this.getActiveObject().getArchiveSpaceKey();
    }

    public int getID() {
        return this.getActiveObject().getID();
    }

    public String getName() {
        return this.getActiveObject().getName();
    }

    public int getReviewDaysAfterPublished() {
        int days = this.getActiveObject().getReviewDaysAfterPublished();
        return days < 1 ? 180 : days;
    }

    public String getReviewPolicy() {
        return this.getActiveObject().getReviewPolicy();
    }

    public String getReviewLabel() {
        return this.getActiveObject().getReviewLabel();
    }

    public List<String> getSpaceCategories() {
        return BrikitString.splitCommaSeparated((String)this.getSpaceCategoriesString());
    }

    public String getSpaceCategoriesString() {
        return this.getActiveObject().getSpaceCategories();
    }

    public String getSpaceKey() {
        return this.getActiveObject().getSpaceKey();
    }

    public WorkflowVisibility getVisibility() {
        String visibility = this.getVisibilityString();
        return BrikitString.isSet((String)visibility) ? WorkflowVisibility.valueOf(visibility) : WorkflowVisibility.SPACE;
    }

    public String getVisibilityString() {
        return this.getActiveObject().getVisibility();
    }

    public boolean isArchiveToSpace() {
        return this.getArchiveSpace() != null;
    }

    public boolean isArchiveToTrash() {
        return !this.isArchiveToSpace();
    }

    public boolean isReviewAfterLastView() {
        return DAYS_AFTER_LAST_VIEW.equals(this.getReviewPolicy());
    }

    public boolean isReviewAfterPublished() {
        return DAYS_AFTER_PUBLISHED.equals(this.getReviewPolicy());
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setArchiveAfterDaysInReview(int archiveAfterDaysInReview) {
        this.getActiveObject().setArchiveAfterDaysInReview(archiveAfterDaysInReview);
    }

    public void setArchivePolicy(String archivePolicy) {
        this.getActiveObject().setArchivePolicy(archivePolicy);
    }

    public void setArchiveSpaceKey(String spaceKey) {
        this.getActiveObject().setArchiveSpaceKey(spaceKey);
    }

    public void setName(String name) {
        this.getActiveObject().setName(name);
    }

    public void setReviewDaysAfterPublished(int reviewDaysAfterPublished) {
        this.getActiveObject().setReviewDaysAfterPublished(reviewDaysAfterPublished);
    }

    public void setReviewPolicy(String reviewPolicy) {
        this.getActiveObject().setReviewPolicy(reviewPolicy);
    }

    public void setReviewLabel(String reviewLabel) {
        this.getActiveObject().setReviewLabel(reviewLabel);
    }

    public void setSpaceCategories(List<String> spaceCategories) {
        this.setSpaceCategoriesString(new BrikitList(spaceCategories).join(","));
    }

    public void setSpaceCategoriesString(String spaceCategoriesCSV) {
        this.getActiveObject().setSpaceCategories(spaceCategoriesCSV);
    }

    public void setSpaceKey(String spaceKey) {
        this.getActiveObject().setSpaceKey(spaceKey);
    }

    public void setVisibility(String visibility) {
        this.getActiveObject().setVisibility(visibility);
    }

    public void setVisibility(WorkflowVisibility visibility) {
        this.setVisibility(visibility.name());
    }

    public boolean shouldArchive() {
        return AFTER_DAYS_IN_REVIEW.equals(this.getArchivePolicy());
    }

    public boolean usesPageViews() {
        return true;
    }

    public void update(ActiveObjects activeObjects, JsonObject contentFlowJSON) throws Exception {
        int contentFlowID = contentFlowJSON.get("id").getAsInt();
        if (this.getID() != contentFlowID) {
            throw new Exception(Confluence.getText((String)"com.brikit.contentflow.workflow.ids.do.not.match"));
        }
        String name = contentFlowJSON.get(NAME_KEY).getAsString();
        name = ArchivePolicy.ensureNameIsUnique(activeObjects, name, contentFlowID);
        if (ContentFlowUtils.jsonHasKeyNotNull(contentFlowJSON, NAME_KEY)) {
            this.setName(name);
        }
        if (ContentFlowUtils.jsonHasKeyNotNull(contentFlowJSON, VISIBILITY_KEY)) {
            this.setVisibility(contentFlowJSON.get(VISIBILITY_KEY).getAsString());
        }
        if (ContentFlowUtils.jsonHasKeyNotNull(contentFlowJSON, SPACE_CATEGORIES_KEY)) {
            this.setSpaceCategoriesString(contentFlowJSON.get(SPACE_CATEGORIES_KEY).getAsString());
        }
        if (ContentFlowUtils.jsonHasKeyNotNull(contentFlowJSON, SPACE_KEY)) {
            this.setSpaceKey(contentFlowJSON.get(SPACE_KEY).getAsString());
        }
        if (ContentFlowUtils.jsonHasKeyNotNull(contentFlowJSON, REVIEW_AFTER_KEY)) {
            this.setReviewDaysAfterPublished(contentFlowJSON.get(REVIEW_AFTER_KEY).getAsInt());
        }
        if (ContentFlowUtils.jsonHasKeyNotNull(contentFlowJSON, ARCHIVE_AFTER_KEY)) {
            this.setArchiveAfterDaysInReview(contentFlowJSON.get(ARCHIVE_AFTER_KEY).getAsInt());
        }
        this.save();
    }
}

