/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.contentflow.model;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.mywork.service.LocalNotificationService;
import com.brikit.contentflow.model.ApprovalStep;
import com.brikit.contentflow.model.ArchivedPage;
import com.brikit.contentflow.model.Archiver;
import com.brikit.contentflow.model.ContentFlowConfiguration;
import com.brikit.contentflow.model.PageApprovalStep;
import com.brikit.contentflow.model.PageRestricter;
import com.brikit.contentflow.model.PageReviewFeedback;
import com.brikit.contentflow.model.PageReviewer;
import com.brikit.contentflow.model.PageStatus;
import com.brikit.contentflow.model.PageStatusContentEntity;
import com.brikit.contentflow.model.PublishedPage;
import com.brikit.contentflow.model.Publisher;
import com.brikit.contentflow.model.RestrictedPage;
import com.brikit.contentflow.model.Workflow;
import com.brikit.contentflow.model.ao.ApprovalStepAO;
import com.brikit.contentflow.model.ao.PageReviewFeedbackAO;
import com.brikit.contentflow.model.ao.PageWorkflowAO;
import com.brikit.contentflow.model.query.PageWorkflowQuery;
import com.brikit.core.ao.AbstractActiveObjectsModel;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitMap;
import com.brikit.core.util.BrikitNumber;
import com.brikit.core.util.BrikitString;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class PageWorkflow
extends AbstractActiveObjectsModel
implements Comparable {
    public static final String EDITOR_USER_KEY_KEY = "editorUserKey";
    public static final String STATUS_COMPLETE = "COMPLETE";
    protected static final BrikitMap<String, String> IGNORE_AUTOMATIC_WORKFLOW_LIST = new BrikitMap();
    protected PageWorkflowAO activeObject;
    protected Workflow workflow;
    protected BrikitList<PageApprovalStep> pageApprovalSteps;
    protected PageApprovalStep currentPageApprovalStep;
    protected BrikitList<PageReviewFeedback> pageReviewFeedbackList;

    public PageWorkflow(ActiveObjects activeObjects, PageWorkflowAO activeObject) {
        super(activeObjects);
        this.setActiveObject(activeObject);
    }

    public static synchronized void addUserToIgnoreList(String username) {
        IGNORE_AUTOMATIC_WORKFLOW_LIST.put((Object)username, (Object)"true");
    }

    public static synchronized void removeUserFromIgnoreList(String username) {
        IGNORE_AUTOMATIC_WORKFLOW_LIST.remove((Object)username);
    }

    protected static synchronized boolean isUserOnIgnoreList(String username) {
        return IGNORE_AUTOMATIC_WORKFLOW_LIST.get((Object)username) != null;
    }

    public static void applyWorkflow(ActiveObjects activeObjects, Integer workflowId, AbstractPage abstractPage, Boolean newPage) {
        if (abstractPage == null || workflowId == null) {
            return;
        }
        if (!Workflow.isWorkflowAvailable(activeObjects, (int)workflowId, abstractPage)) {
            return;
        }
        Workflow workflow = Workflow.getWorkflowWithId(activeObjects, workflowId);
        if (workflow == null) {
            return;
        }
        PageWorkflow pageWorkflow = PageWorkflow.getPageWorkflow(activeObjects, abstractPage.getId());
        if (pageWorkflow != null) {
            pageWorkflow.removeFromPage();
        }
        if ((pageWorkflow = PageWorkflow.createPageWorkflow(activeObjects, abstractPage.getId(), workflow)) == null) {
            return;
        }
        PageWorkflow.restrictPageForPublishingWorkflow(activeObjects, abstractPage, pageWorkflow);
    }

    public static PageWorkflow createPageWorkflow(ActiveObjects activeObjects, long pageId, Workflow workflow) {
        return PageWorkflow.createPageWorkflow(activeObjects, pageId, workflow, Confluence.getUserKeyString());
    }

    public static PageWorkflow createPageWorkflow(ActiveObjects activeObjects, long pageId, Workflow workflow, String editor) {
        if (workflow == null) {
            return null;
        }
        String spaceKey = Confluence.getSpaceKey((long)pageId);
        PageWorkflowAO pageWorkflowAO = (PageWorkflowAO)activeObjects.create(PageWorkflowAO.class, new DBParam[0]);
        pageWorkflowAO.setPageId(pageId);
        pageWorkflowAO.setSpaceKey(spaceKey);
        pageWorkflowAO.setEditorUserKey(editor);
        pageWorkflowAO.setWorkflowAO(workflow.getActiveObject());
        PageWorkflow pageWorkflow = new PageWorkflow(activeObjects, pageWorkflowAO);
        pageWorkflow.setCurrentStep(pageWorkflow.getFirstPageApprovalStep());
        pageWorkflow.save();
        Confluence.addLabelsFromStrings(workflow.getLabels(), (AbstractPage)pageWorkflow.getAbstractPage());
        pageWorkflow.applyEntryPageStatus();
        Confluence.addWatcher((AbstractPage)Confluence.getPageOrBlogPost((long)pageId));
        return pageWorkflow;
    }

    public static void created(ActiveObjects activeObjects, AbstractPage abstractPage) {
        if (abstractPage == null) {
            return;
        }
        PageWorkflow pageWorkflow = PageWorkflow.getPageWorkflowOrActivateSpaceWorkflow(activeObjects, abstractPage);
        PageWorkflow.restrictPageForPublishingWorkflow(activeObjects, abstractPage, pageWorkflow);
    }

    protected static void restrictPageForPublishingWorkflow(ActiveObjects activeObjects, AbstractPage abstractPage, PageWorkflow pageWorkflow) {
        if (pageWorkflow == null || abstractPage == null || !pageWorkflow.isPublishing()) {
            return;
        }
        PageRestricter pageRestricter = new PageRestricter(activeObjects, abstractPage);
        pageRestricter.restrictForPublishingWorkflow(pageWorkflow);
        PublishedPage.createForNewPage(activeObjects, abstractPage);
    }

    protected static List<PageWorkflow> fromActiveObjects(ActiveObjects activeObjects, PageWorkflowAO[] pageWorkflowAOS) {
        ArrayList<PageWorkflow> pageWorkflows = new ArrayList<PageWorkflow>(pageWorkflowAOS.length);
        for (PageWorkflowAO pageWorkflowAO : pageWorkflowAOS) {
            pageWorkflows.add(new PageWorkflow(activeObjects, pageWorkflowAO));
        }
        return pageWorkflows;
    }

    public static List<PageWorkflow> getActivePageWorkflows(ActiveObjects activeObjects, Space space) {
        PageWorkflowQuery query = new PageWorkflowQuery(activeObjects);
        return PageWorkflow.fromActiveObjects(activeObjects, query.getActivePageWorkflows(space.getKey()));
    }

    public static List<PageWorkflow> getAllPageWorkflows(ActiveObjects activeObjects, Space space) {
        PageWorkflowQuery query = new PageWorkflowQuery(activeObjects);
        return PageWorkflow.fromActiveObjects(activeObjects, query.getAllPageWorkflows(space.getKey()));
    }

    public static PageWorkflow getPageWorkflow(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return PageWorkflow.getPageWorkflow(activeObjects, abstractPage.getId());
    }

    public static PageWorkflow getPageWorkflow(ActiveObjects activeObjects, String pageIdString) {
        return PageWorkflow.getPageWorkflow(activeObjects, BrikitNumber.parseInteger((String)pageIdString));
    }

    public static boolean isWorkflowInUse(ActiveObjects activeObjects, int workflowID) {
        PageWorkflowQuery query = new PageWorkflowQuery(activeObjects);
        return query.getAnyPageWorkflowForWorkflowID(workflowID) != null;
    }

    public static PageWorkflow getPageWorkflow(ActiveObjects activeObjects, long pageId) {
        PageWorkflowAO pageWorkflowAO = PageWorkflow.getPageWorkflowAO(activeObjects, pageId);
        return pageWorkflowAO == null ? null : new PageWorkflow(activeObjects, pageWorkflowAO);
    }

    public static PageWorkflowAO getPageWorkflowAO(ActiveObjects activeObjects, long pageId) {
        PageWorkflowQuery query = new PageWorkflowQuery(activeObjects);
        return query.getPageWorkflowForPage(pageId);
    }

    public static PageWorkflow getPageWorkflowOrActivateSpaceWorkflow(ActiveObjects activeObjects, AbstractPage abstractPage) {
        if (abstractPage == null) {
            return null;
        }
        return PageWorkflow.getPageWorkflowOrActivateSpaceWorkflow(activeObjects, abstractPage.getId());
    }

    public static PageWorkflow getPageWorkflowOrActivateSpaceWorkflow(ActiveObjects activeObjects, long pageId) {
        if (PageWorkflow.isUserOnIgnoreList(Confluence.getUsername())) {
            return null;
        }
        PageWorkflowAO pageWorkflowAO = PageWorkflow.getPageWorkflowAO(activeObjects, pageId);
        PageWorkflow pageWorkflow = new PageWorkflow(activeObjects, pageWorkflowAO);
        if (pageWorkflowAO != null && !pageWorkflowAO.isComplete()) {
            return pageWorkflow;
        }
        pageWorkflow = null;
        Workflow automaticWorkflow = ContentFlowConfiguration.getAutomaticWorkflow(activeObjects, pageId);
        if (automaticWorkflow != null) {
            pageWorkflow = PageWorkflow.createPageWorkflow(activeObjects, pageId, automaticWorkflow);
        }
        return pageWorkflow;
    }

    public static List<PageWorkflow> getPageWorkflowsReferencingApprovalStep(ActiveObjects activeObjects, ApprovalStep approvalStep) {
        PageWorkflowQuery query = new PageWorkflowQuery(activeObjects);
        return PageWorkflow.fromActiveObjects(activeObjects, query.getPageWorkflowsReferencingApprovalStep(approvalStep));
    }

    public static List<PageWorkflow> getWorkflowsWaitingOnUser(ActiveObjects activeObjects, ConfluenceUser aUser) {
        PageWorkflowQuery query = new PageWorkflowQuery(activeObjects);
        return PageWorkflow.fromActiveObjects(activeObjects, query.getPageWorkflowsWaitingOnUser(aUser));
    }

    public static boolean hasActiveWorkflow(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return abstractPage == null ? false : PageWorkflow.hasActiveWorkflow(activeObjects, abstractPage.getId());
    }

    public static boolean hasActiveWorkflow(ActiveObjects activeObjects, long pageId) {
        PageWorkflow pageWorkflow = PageWorkflow.getPageWorkflow(activeObjects, pageId);
        return pageWorkflow != null && !pageWorkflow.isComplete();
    }

    public static boolean hasWorkflow(ActiveObjects activeObjects, AbstractPage abstractPage) {
        return abstractPage == null ? false : PageWorkflow.hasWorkflow(activeObjects, abstractPage.getId());
    }

    public static boolean hasWorkflow(ActiveObjects activeObjects, long pageId) {
        return PageWorkflow.hasActiveWorkflow(activeObjects, pageId) || ContentFlowConfiguration.getAutomaticWorkflow(activeObjects, pageId) != null;
    }

    public static void removed(ActiveObjects activeObjects, AbstractPage abstractPage) {
        RestrictedPage restrictedPage;
        if (abstractPage == null) {
            return;
        }
        PageWorkflow pageWorkflow = PageWorkflow.getPageWorkflow(activeObjects, abstractPage);
        if (pageWorkflow != null) {
            pageWorkflow.removeFromPage();
        }
        if ((restrictedPage = RestrictedPage.getRestrictedPage(activeObjects, abstractPage)) != null) {
            restrictedPage.delete();
        }
    }

    public static void restored(ActiveObjects activeObjects, AbstractPage abstractPage) {
        if (abstractPage == null) {
            return;
        }
        ArchivedPage archivedPage = ArchivedPage.getArchivedPageForPage(activeObjects, abstractPage);
        if (archivedPage != null) {
            Archiver.unarchivedFromSpaceTrash(archivedPage);
        }
    }

    public static void updated(ActiveObjects activeObjects, AbstractPage abstractPage) {
        if (abstractPage == null) {
            return;
        }
        AbstractPage previousVersion = Confluence.getPreviousVersion((AbstractPage)abstractPage);
        if (previousVersion != null && Confluence.getBodyAsString((ContentEntityObject)abstractPage).equals(Confluence.getBodyAsString((ContentEntityObject)previousVersion))) {
            return;
        }
        PageWorkflow pageWorkflow = PageWorkflow.getPageWorkflowOrActivateSpaceWorkflow(activeObjects, abstractPage);
        if (pageWorkflow != null && pageWorkflow.isPublishing()) {
            Publisher.setPublishedVersionToPrevious(activeObjects, abstractPage);
        }
    }

    public static boolean userCanViewWorkflow(ActiveObjects activeObjects, AbstractPage abstractPage) {
        PageWorkflow pageWorkflow = PageWorkflow.getPageWorkflow(activeObjects, abstractPage);
        if (pageWorkflow == null) {
            return false;
        }
        return Confluence.canEdit((AbstractPage)abstractPage) || pageWorkflow.getWorkflow().currentUserIsInWorkflow() || pageWorkflow.isComplete();
    }

    public static boolean userIsMemberOfPublishingWorkflow(ActiveObjects activeObjects, AbstractPage abstractPage) {
        if (Confluence.canEdit((AbstractPage)abstractPage)) {
            return true;
        }
        PageWorkflow pageWorkflow = PageWorkflow.getPageWorkflow(activeObjects, abstractPage);
        return pageWorkflow != null && pageWorkflow.isPublishing() && pageWorkflow.getWorkflow().currentUserIsInWorkflow();
    }

    protected void applyEntryPageStatus() {
        this.applyPageStatus(this.getWorkflow().getEntryPageStatus());
    }

    protected void applyExitPageStatus() {
        this.applyPageStatus(this.getWorkflow().getExitPageStatus());
    }

    protected void applyPageStatus(PageStatus pageStatus) {
        PageStatusContentEntity.setPageStatus(this.getActiveObjects(), this.getPageId(), pageStatus);
    }

    public void clearCurrentApprovalStepReference() {
        this.getActiveObject().setCurrentApprovalStepAO(null);
        this.save();
    }

    public void clearLabels() {
        Confluence.removeLabels(this.getWorkflow().getAllApprovalStepLabels(), (AbstractPage)this.getAbstractPage());
        Confluence.removeLabels(this.getWorkflow().getLabels(), (AbstractPage)this.getAbstractPage());
    }

    public void clearPageStatus() {
        PageStatus entryPageStatus;
        PageStatus pageStatus = PageStatus.getPageStatusForPage(this.getActiveObjects(), this.getAbstractPage());
        if (pageStatus == null) {
            return;
        }
        boolean statusNeedsClearing = false;
        PageStatus currentPageStatus = this.getCurrentPageApprovalStep().getPageStatus();
        if (currentPageStatus != null && pageStatus.getID() == currentPageStatus.getID()) {
            statusNeedsClearing = true;
        }
        if ((entryPageStatus = this.getWorkflow().getEntryPageStatus()) != null && pageStatus.getID() == entryPageStatus.getID()) {
            statusNeedsClearing = true;
        }
        if (statusNeedsClearing) {
            PageStatusContentEntity.setPageStatus(this.getActiveObjects(), this.getAbstractPage(), null);
        }
    }

    public int compareTo(Object o) {
        String title1 = this.getAbstractPage().getTitle();
        String title2 = ((PageWorkflow)o).getAbstractPage().getTitle();
        return Collator.getInstance().compare(title1 == null ? "" : title1, title2 == null ? "" : title2);
    }

    public boolean currentUserCanReject() {
        if (Confluence.isAnonymousUser()) {
            return false;
        }
        PageApprovalStep currentPageApprovalStep = this.getCurrentPageApprovalStep();
        ApprovalStep currentApprovalStep = currentPageApprovalStep.getApprovalStep();
        return currentPageApprovalStep != null && currentPageApprovalStep.isCurrentUserReviewer() && !this.getWorkflow().isFirstStep(currentApprovalStep);
    }

    public boolean currentUserCanRemove() {
        if (Confluence.isAnonymousUser()) {
            return false;
        }
        if (Confluence.canAdministerSpace((Space)this.getSpace())) {
            return true;
        }
        ContentFlowConfiguration configuration = ContentFlowConfiguration.forPage(this.getActiveObjects(), this.getAbstractPage());
        return this.getWorkflow().hasRemovePermissionsName() ? this.currentUserHasExplicitRemovePermission() : !configuration.isAutomatic(this.getWorkflow()) && (Confluence.canEdit((AbstractPage)this.getAbstractPage()) || this.getWorkflow().currentUserIsInWorkflow());
    }

    protected boolean currentUserHasExplicitRemovePermission() {
        if (!this.getWorkflow().hasRemovePermissionsName()) {
            return false;
        }
        return this.getWorkflow().isRemovePermissionsUser() ? this.getWorkflow().getRemovePermissionsName().equals(Confluence.getUsername()) : Confluence.isGroupMember((String)this.getWorkflow().getRemovePermissionsName());
    }

    public boolean currentUserCanUndoApprove() {
        BrikitList feedbackList;
        PageReviewFeedback feedback;
        if (Confluence.isAnonymousUser() || this.isComplete()) {
            return false;
        }
        PageReviewer pageReviewerForCurrentUser = this.pageReviewerForCurrentUserInCurrentApprovalStep();
        if (pageReviewerForCurrentUser != null && pageReviewerForCurrentUser.isApproved()) {
            return true;
        }
        List<PageReviewFeedback> allFeedback = this.getPageReviewFeedbackList();
        if (allFeedback != null && (feedback = (PageReviewFeedback)((Object)(feedbackList = new BrikitList(allFeedback)).last())) != null) {
            return feedback.getUser().equals(Confluence.getConfluenceUser()) && feedback.isApproved();
        }
        return false;
    }

    public boolean currentUserCanUndoReject() {
        if (Confluence.isAnonymousUser()) {
            return false;
        }
        PageReviewer pageReviewerForCurrentUser = this.pageReviewerForCurrentUserInCurrentApprovalStep();
        if (pageReviewerForCurrentUser != null && pageReviewerForCurrentUser.isRejected()) {
            return true;
        }
        pageReviewerForCurrentUser = this.pageReviewerForCurrentUserInNextApprovalStep();
        return pageReviewerForCurrentUser != null && pageReviewerForCurrentUser.isRejected() && this.getCurrentPageApprovalStep() != null && !this.getCurrentPageApprovalStep().hasApprovalActivity();
    }

    public boolean currentUserNeedsToApprove() {
        PageApprovalStep currentPageApprovalStep = this.getCurrentPageApprovalStep();
        return currentPageApprovalStep != null && currentPageApprovalStep.currentUserNeedsToApprove();
    }

    public void delete() {
        for (PageReviewFeedback pageReviewFeedback : this.getPageReviewFeedbackList()) {
            pageReviewFeedback.delete();
        }
        this.getActiveObjects().delete(new RawEntity[]{this.getActiveObject()});
    }

    protected void forceComplete() {
        if (this.isComplete()) {
            return;
        }
        for (PageApprovalStep pageApprovalStep : this.getPageApprovalSteps()) {
            pageApprovalStep.forceComplete();
        }
        PageApprovalStep pageApprovalStep = this.getLastPageApprovalStep();
        if (pageApprovalStep != null) {
            this.setCurrentStep(pageApprovalStep);
        }
        this.setComplete(true);
        this.save();
    }

    public AbstractPage getAbstractPage() {
        return Confluence.getPageOrBlogPost((long)this.getPageId());
    }

    public PageWorkflowAO getActiveObject() {
        return this.activeObject;
    }

    public PageApprovalStep getCurrentPageApprovalStep() {
        if (this.currentPageApprovalStep == null) {
            try {
                ApprovalStepAO approvalStepAO = this.getActiveObject().getCurrentApprovalStepAO();
                if (approvalStepAO != null) {
                    ApprovalStep approvalStep = this.getWorkflow().approvalStepWithID(approvalStepAO.getID());
                    this.currentPageApprovalStep = this.getPageApprovalStep(approvalStep);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.currentPageApprovalStep;
    }

    public int getCurrentPageVersion() {
        return Confluence.getCurrent((AbstractPage)this.getAbstractPage()).getVersion();
    }

    public PageApprovalStep getFirstPageApprovalStep() {
        ApprovalStep firstApprovalStep = this.getWorkflow().getFirstStep();
        return this.getPageApprovalStep(firstApprovalStep);
    }

    public int getID() {
        return this.getActiveObject().getID();
    }

    public ConfluenceUser getEditor() {
        return Confluence.getConfluenceUserByUserKey((String)this.getEditorUserKeyString());
    }

    public String getEditorUserKeyString() {
        return this.getActiveObject().getEditorUserKey();
    }

    public PageApprovalStep getLastPageApprovalStep() {
        PageApprovalStep pageApprovalStep;
        for (pageApprovalStep = this.getCurrentPageApprovalStep(); pageApprovalStep != null && pageApprovalStep.hasNextStep(); pageApprovalStep = pageApprovalStep.nextStep()) {
        }
        return pageApprovalStep;
    }

    public PageApprovalStep getNextPageApprovalStep() {
        if (this.getCurrentPageApprovalStep() == null) {
            return null;
        }
        ApprovalStep nextApprovalStep = this.getWorkflow().nextStep(this.getCurrentPageApprovalStep().getApprovalStep());
        return nextApprovalStep != null ? this.getPageApprovalStep(nextApprovalStep) : null;
    }

    public PageApprovalStep getPageApprovalStep(ApprovalStep approvalStep) {
        return new PageApprovalStep(approvalStep, this);
    }

    public BrikitList<PageApprovalStep> getPageApprovalSteps() {
        if (this.pageApprovalSteps == null) {
            this.pageApprovalSteps = new BrikitList();
            for (ApprovalStep approvalStep : this.getWorkflow().getApprovalSteps()) {
                this.pageApprovalSteps.add((Object)this.getPageApprovalStep(approvalStep));
            }
        }
        return this.pageApprovalSteps;
    }

    public long getPageId() {
        return this.getActiveObject().getPageId();
    }

    public List<PageReviewFeedback> getPageReviewFeedbackList() {
        if (this.pageReviewFeedbackList == null) {
            this.pageReviewFeedbackList = new BrikitList();
            List<PageReviewFeedbackAO> pageReviewFeedbackAOs = Arrays.asList(this.getActiveObject().getPageReviewFeedbackAOs());
            for (PageReviewFeedbackAO pageReviewFeedbackAO : pageReviewFeedbackAOs) {
                this.pageReviewFeedbackList.add((Object)new PageReviewFeedback(this.getActiveObjects(), pageReviewFeedbackAO));
            }
            Collections.sort(this.pageReviewFeedbackList, PageReviewFeedback.DateOrder);
        }
        return this.pageReviewFeedbackList;
    }

    public PageApprovalStep getPreviousPageApprovalStep() {
        ApprovalStep previousApprovalStep = this.getWorkflow().previousStep(this.getCurrentPageApprovalStep().getApprovalStep());
        return previousApprovalStep != null ? this.getPageApprovalStep(previousApprovalStep) : null;
    }

    public Space getSpace() {
        return Confluence.getSpace((String)this.getSpaceKey());
    }

    public String getSpaceKey() {
        return this.getActiveObject().getSpaceKey();
    }

    public String getSpaceName() {
        return Confluence.getSpaceName((String)this.getSpaceKey());
    }

    public String getStatus() {
        return this.getActiveObject().getStatus();
    }

    public Workflow getWorkflow() {
        if (this.workflow == null) {
            this.workflow = new Workflow(this.getActiveObjects(), this.getActiveObject().getWorkflowAO());
        }
        return this.workflow;
    }

    public boolean isComplete() {
        String status = this.getActiveObject().getStatus();
        return BrikitString.isSet((String)status) && status.equals(STATUS_COMPLETE);
    }

    public boolean isCurrentStep(PageApprovalStep pageApprovalStep) {
        if (this.getCurrentPageApprovalStep() == null) {
            return false;
        }
        return pageApprovalStep != null && pageApprovalStep.getApprovalStep().equals((Object)this.getCurrentPageApprovalStep().getApprovalStep());
    }

    public boolean isFirstStep(PageApprovalStep pageApprovalStep) {
        return this.getWorkflow().isFirstStep(pageApprovalStep.getApprovalStep());
    }

    public boolean isLastStepComplete() {
        return this.getCurrentPageApprovalStep() != null && this.getCurrentPageApprovalStep().isComplete() && !this.getCurrentPageApprovalStep().hasNextStep();
    }

    public boolean isPublishing() {
        return this.getWorkflow().isPublishing();
    }

    public boolean isStarted() {
        PageApprovalStep firstPageApprovalStep = this.getFirstPageApprovalStep();
        return firstPageApprovalStep != null && firstPageApprovalStep.hasApprovalActivity();
    }

    public PageReviewer pageReviewerForCurrentUserInCurrentApprovalStep() {
        return this.pageReviewerForCurrentUserInPageApprovalStep(this.getCurrentPageApprovalStep());
    }

    public PageReviewer pageReviewerForCurrentUserInPageApprovalStep(PageApprovalStep pageApprovalStep) {
        return pageApprovalStep == null ? null : pageApprovalStep.pageReviewerForCurrentUser();
    }

    public PageReviewer pageReviewerForCurrentUserInNextApprovalStep() {
        return this.pageReviewerForCurrentUserInPageApprovalStep(this.getNextPageApprovalStep());
    }

    public PageReviewer pageReviewerForCurrentUserInPreviousApprovalStep() {
        return this.pageReviewerForCurrentUserInPageApprovalStep(this.getPreviousPageApprovalStep());
    }

    public void publish() {
        this.clearLabels();
        if (this.isPublishing()) {
            Publisher.publish(this.activeObjects, this.getAbstractPage());
        }
        this.applyExitPageStatus();
    }

    public void removeFromPage() {
        this.clearLabels();
        this.clearPageStatus();
        this.delete();
        RestrictedPage restrictedPage = RestrictedPage.getRestrictedPage(this.getActiveObjects(), this.getAbstractPage());
        if (restrictedPage != null) {
            restrictedPage.removeFromPage();
        }
    }

    public void routingComplete() {
        this.forceComplete();
        this.clearLabels();
        this.applyExitPageStatus();
    }

    public void save() {
        this.getActiveObject().save();
    }

    public void setActiveObject(PageWorkflowAO activeObject) {
        this.activeObject = activeObject;
    }

    public void setComplete(boolean complete) {
        this.getActiveObject().setStatus(STATUS_COMPLETE);
        this.getActiveObject().setComplete(complete);
    }

    public void setCurrentStep(PageApprovalStep pageApprovalStep) {
        PageStatus pageStatus;
        this.currentPageApprovalStep = pageApprovalStep;
        this.getActiveObject().setCurrentApprovalStepAO(pageApprovalStep.getApprovalStep().getActiveObject());
        Confluence.removeLabels(this.getWorkflow().getAllApprovalStepLabels(), (AbstractPage)this.getAbstractPage());
        if (!pageApprovalStep.isComplete()) {
            Confluence.addLabel((String)pageApprovalStep.getLabel(), (AbstractPage)this.getAbstractPage());
        }
        if ((pageStatus = pageApprovalStep.getPageStatus()) != null) {
            PageStatusContentEntity.setPageStatus(this.getActiveObjects(), this.getPageId(), pageStatus);
        }
    }

    public void setEditorUserKey(String editorUserKey) {
        this.getActiveObject().setEditorUserKey(editorUserKey);
    }

    public void setSpaceKey(String spaceKey) {
        this.getActiveObject().setSpaceKey(spaceKey);
    }

    public void setStatus(String status) {
        this.getActiveObject().setStatus(status);
    }

    public void stepBackward(LocalNotificationService notificationService, boolean dueToReject) {
        PageApprovalStep previousPageApprovalStep = this.getPreviousPageApprovalStep();
        if (previousPageApprovalStep != null) {
            this.setCurrentStep(previousPageApprovalStep);
            if (dueToReject) {
                previousPageApprovalStep.clearApprovals(notificationService);
            }
        }
        this.save();
    }

    public void stepForward() {
        PageApprovalStep nextPageApprovalStep = this.getNextPageApprovalStep();
        if (nextPageApprovalStep != null) {
            this.setCurrentStep(nextPageApprovalStep);
        }
        this.save();
    }

    public String getTimeInStatus() {
        PageReviewFeedback latest = null;
        List<PageReviewFeedback> pageReviewFeedbackList = this.getPageReviewFeedbackList();
        if (pageReviewFeedbackList.isEmpty()) {
            return "";
        }
        latest = pageReviewFeedbackList.get(pageReviewFeedbackList.size() - 1);
        DateFormatter formatter = Confluence.getDateFormatter((TimeZone)Confluence.getTimeZone());
        return latest != null ? formatter.format(latest.getCreationDate().getTime()) : "";
    }

    public void undoApprove(LocalNotificationService notificationService) {
        if (!this.currentUserCanUndoApprove()) {
            return;
        }
        PageReviewer pageReviewerForCurrentUser = this.pageReviewerForCurrentUserInCurrentApprovalStep();
        if (pageReviewerForCurrentUser != null && pageReviewerForCurrentUser.isApproved()) {
            pageReviewerForCurrentUser.undoApprove(notificationService);
            return;
        }
        pageReviewerForCurrentUser = this.pageReviewerForCurrentUserInPreviousApprovalStep();
        if (pageReviewerForCurrentUser != null && pageReviewerForCurrentUser.isApproved()) {
            pageReviewerForCurrentUser.undoApprove(notificationService);
        }
    }

    public void undoReject(LocalNotificationService notificationService) {
        if (!this.currentUserCanUndoReject()) {
            return;
        }
        PageReviewer pageReviewerForCurrentUser = this.pageReviewerForCurrentUserInCurrentApprovalStep();
        if (pageReviewerForCurrentUser != null && pageReviewerForCurrentUser.isRejected()) {
            pageReviewerForCurrentUser.undoReject(notificationService);
            return;
        }
        pageReviewerForCurrentUser = this.pageReviewerForCurrentUserInNextApprovalStep();
        if (pageReviewerForCurrentUser != null && pageReviewerForCurrentUser.isRejected()) {
            pageReviewerForCurrentUser.undoReject(notificationService);
        }
    }
}

