/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.actions;

import com.brikit.blueprintmaker.actions.BlueprintMakerActionSupport;
import com.brikit.blueprintmaker.model.BlueprintDefinitions;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitFile;
import java.io.File;

public class DownloadBlueprintDefinitionsAction
extends BlueprintMakerActionSupport {
    protected String downloadPath;

    public String execute() throws Exception {
        File dataFile = BrikitFile.getConfluenceTempDirectoryPath((String)"blueprint-definitions.json");
        String settings = BrikitFile.readFile((File)BlueprintDefinitions.getBlueprintDefinitionsFile());
        BrikitFile.write((String)settings, (File)dataFile);
        this.setDownloadPath(BrikitFile.prepareDownloadPath((String)dataFile.getPath()) + "?contentType=application/json");
        BrikitFile.allowUserToDownload((File)dataFile);
        return "success";
    }

    public String getDownloadPath() {
        return this.downloadPath;
    }

    public void setDownloadPath(String downloadPath) {
        this.downloadPath = downloadPath;
    }

    public void validate() {
        super.validate();
        if (!Confluence.isConfluenceAdministrator()) {
            this.addActionError(this.getText("com.brikit.blueprintmaker.insufficient.permissions"));
        }
    }
}

