/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.util;

import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitFile;
import com.brikit.core.util.BrikitString;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class BrikitMobile {
    private static final Pattern MOBILE_USER_AGENT_REGEX = Pattern.compile("(iPhone;|iPad;|iPhone Simulator;|iPod;|iPod touch;|Linux; U; Android)");
    private static final Pattern ANDROID_CHROME = Pattern.compile("Chrome/[.\\d]* Mobile");
    private static final Pattern OLD_ANDROID = Pattern.compile("Linux; U; Android (?:[23]\\.\\d|4\\.0\\.[12])");

    public static boolean isPhone() {
        return BrikitMobile.isPhoneReal() || BrikitMobile.isPhoneFaker();
    }

    public static boolean isPhoneFaker() {
        return BrikitFile.getBrikitFile("always-mobile.txt").exists();
    }

    public static boolean isPhoneReal() {
        return BrikitMobile.isPhone(null);
    }

    public static boolean isPhone(HttpServletRequest servletRequest) {
        if (servletRequest == null) {
            servletRequest = Confluence.getServletRequest();
        }
        if (servletRequest == null) {
            return false;
        }
        String userAgent = servletRequest.getHeader("user-agent");
        return BrikitString.isSet(userAgent) && !OLD_ANDROID.matcher(userAgent).find() && (MOBILE_USER_AGENT_REGEX.matcher(userAgent).find() || ANDROID_CHROME.matcher(userAgent).find());
    }
}

