/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.core.confluence;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.definition.MacroBody;
import com.atlassian.confluence.content.render.xhtml.definition.PlainTextMacroBody;
import com.atlassian.confluence.content.render.xhtml.definition.RichTextMacroBody;
import com.atlassian.confluence.content.render.xhtml.storage.macro.MacroId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionReplacer;
import com.atlassian.confluence.xhtml.api.MacroDefinitionUpdater;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitMap;
import com.brikit.core.util.BrikitNumber;
import com.brikit.core.util.BrikitString;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MacroParser {
    public static final String TRUE_PARAM_VALUE = "true";
    public static final String FALSE_PARAM_VALUE = "false";

    public static boolean booleanFromParameter(String aString) {
        return TRUE_PARAM_VALUE.equalsIgnoreCase(aString);
    }

    public static MacroDefinition clone(MacroDefinition macro) {
        MacroDefinition clone = MacroParser.createMacroDefinition(macro.getName());
        MacroParser.copy(macro, clone);
        return clone;
    }

    public static boolean contains(List<MacroDefinition> macroList, MacroDefinition aMacro) {
        if (macroList == null || aMacro == null) {
            return false;
        }
        for (MacroDefinition macro : macroList) {
            if (!MacroParser.equals(macro, aMacro)) continue;
            return true;
        }
        return false;
    }

    public static boolean containsMacro(AbstractPage abstractPage, String macroName) {
        try {
            return !MacroParser.extractMacros(abstractPage, macroName).isEmpty();
        }
        catch (XhtmlException ex) {
            BrikitLog.logError("Unable to parse XHTML storage format for page: " + abstractPage, (Exception)((Object)ex));
            return false;
        }
    }

    public static boolean containsUsingParameterMatch(List<MacroDefinition> macroList, MacroDefinition aMacro, List<String> parameters) {
        if (macroList == null || aMacro == null) {
            return false;
        }
        for (MacroDefinition macro : macroList) {
            if (!MacroParser.equalsNameAndParameters(macro, aMacro, parameters)) continue;
            return true;
        }
        return false;
    }

    public static void copy(MacroDefinition sourceMacro, MacroDefinition targetMacro) {
        targetMacro.setName(sourceMacro.getName());
        if (sourceMacro.getBody() instanceof RichTextMacroBody) {
            MacroParser.setBody(targetMacro, sourceMacro.getBodyText());
        } else {
            MacroParser.setBodyPlainText(targetMacro, sourceMacro.getBodyText());
        }
        targetMacro.setDefaultParameterValue(sourceMacro.getDefaultParameterValue());
        targetMacro.setParameters(new HashMap(sourceMacro.getParameters()));
        if (MacroParser.useTypedParameters()) {
            targetMacro.setStorageVersion(sourceMacro.getStorageVersion());
            targetMacro.setTypedParameters(sourceMacro.getTypedParameters());
        }
    }

    public static MacroDefinition createMacroDefinition(String name) {
        return MacroDefinition.builder().withName(name).withStorageVersion("2").build();
    }

    public static boolean equals(MacroDefinition macro1, MacroDefinition macro2) {
        if (macro1 == macro2) {
            return true;
        }
        if (macro1 == null && macro2 != null) {
            return false;
        }
        if (macro1 != null && macro2 == null) {
            return false;
        }
        if (macro1.getName().equals(macro2.getName()) && MacroParser.hasParameter(macro1, "id") && MacroParser.getStringParameter(macro1, "id").equals(MacroParser.getStringParameter(macro2, "id"))) {
            return true;
        }
        if (!macro1.getBodyText().equals(macro2.getBodyText())) {
            return false;
        }
        if (!BrikitString.equal(macro1.getDefaultParameterValue(), macro2.getDefaultParameterValue())) {
            return false;
        }
        if (!BrikitString.equal(macro1.getName(), macro2.getName())) {
            return false;
        }
        if (!BrikitMap.equals(macro1.getParameters(), macro2.getParameters())) {
            return false;
        }
        return !MacroParser.useTypedParameters() || BrikitMap.equals(macro1.getTypedParameters(), macro2.getTypedParameters());
    }

    public static boolean equalsNameAndParameters(MacroDefinition macro1, MacroDefinition macro2, List<String> parameters) {
        if (macro1 == null && macro2 == null) {
            return true;
        }
        if (macro1 == null || macro2 == null) {
            return false;
        }
        return macro1.getName().equals(macro2.getName()) && BrikitMap.equalsKeySubset(macro1.getParameters(), macro2.getParameters(), parameters);
    }

    public static List<MacroDefinition> extractMacros(AbstractPage abstractPage) throws XhtmlException {
        return MacroParser.extractMacros(abstractPage, null);
    }

    public static List<MacroDefinition> extractMacros(AbstractPage abstractPage, String macroName) throws XhtmlException {
        return MacroParser.extractMacros(abstractPage, macroName, null);
    }

    public static List<MacroDefinition> extractMacros(AbstractPage abstractPage, String macroName, String parameter) throws XhtmlException {
        return MacroParser.extractMacros(abstractPage, macroName, parameter, null);
    }

    public static List<MacroDefinition> extractMacros(AbstractPage abstractPage, String macroName, String parameter, String value) throws XhtmlException {
        ArrayList<MacroDefinition> macros = new ArrayList<MacroDefinition>();
        if (abstractPage == null) {
            return macros;
        }
        return MacroParser.extractMacrosFromStorageFormat(abstractPage, Confluence.getBodyAsString((ContentEntityObject)abstractPage), macroName, parameter, value);
    }

    public static List<MacroDefinition> extractMacrosFromStorageFormat(AbstractPage abstractPage, String storageFormat) throws XhtmlException {
        return MacroParser.extractMacrosFromStorageFormat(abstractPage, storageFormat, null);
    }

    public static List<MacroDefinition> extractMacrosFromStorageFormat(AbstractPage abstractPage, String storageFormat, String macroName) throws XhtmlException {
        return MacroParser.extractMacrosFromStorageFormat(abstractPage, storageFormat, macroName, null);
    }

    public static List<MacroDefinition> extractMacrosFromStorageFormat(AbstractPage abstractPage, String storageFormat, String macroName, String parameter) throws XhtmlException {
        return MacroParser.extractMacrosFromStorageFormat(abstractPage, storageFormat, macroName, parameter, null);
    }

    public static List<MacroDefinition> extractMacrosFromStorageFormat(AbstractPage contextPage, String storageFormat, final String macroName, final String parameter, final String value) throws XhtmlException {
        final ArrayList<MacroDefinition> macros = new ArrayList<MacroDefinition>();
        if (!BrikitString.isSet(storageFormat)) {
            return macros;
        }
        final ConversionContext context = Confluence.getConversionContext(contextPage);
        Confluence.getXhtmlContent().replaceMacroDefinitionsWithString(storageFormat, context, new MacroDefinitionReplacer(){

            public String replace(MacroDefinition macro) throws XhtmlException {
                if (!BrikitString.isSet(macroName) || macro.getName().equalsIgnoreCase(macroName) && MacroParser.hasParameter(macro, parameter, value)) {
                    macros.add(macro);
                }
                return Confluence.getXhtmlContent().convertMacroDefinitionToStorage(macro, context);
            }
        });
        return macros;
    }

    public static MacroDefinition findMacroById(AbstractPage abstractPage, String macroId) throws XhtmlException {
        return MacroParser.findMacroByIdFromStorageFormat(abstractPage, Confluence.getBodyAsString((ContentEntityObject)abstractPage), macroId);
    }

    public static MacroDefinition findMacroByIdFromStorageFormat(AbstractPage contextPage, String storageFormat, final String macroId) throws XhtmlException {
        final BrikitList macros = new BrikitList();
        final ConversionContext context = Confluence.getConversionContext(contextPage);
        Confluence.getXhtmlContent().replaceMacroDefinitionsWithString(storageFormat, context, new MacroDefinitionReplacer(){

            public String replace(MacroDefinition macro) throws XhtmlException {
                if (MacroParser.hasId(macro, macroId)) {
                    macros.add(macro);
                }
                return Confluence.getXhtmlContent().convertMacroDefinitionToStorage(macro, context);
            }
        });
        return (MacroDefinition)macros.first();
    }

    public static MacroDefinition firstMacro(AbstractPage abstractPage) throws XhtmlException {
        return MacroParser.firstMacro(abstractPage, null);
    }

    public static MacroDefinition firstMacro(AbstractPage abstractPage, String macroName) throws XhtmlException {
        return MacroParser.firstMacro(abstractPage, macroName, null);
    }

    public static MacroDefinition firstMacro(AbstractPage abstractPage, String macroName, String parameter) throws XhtmlException {
        return MacroParser.firstMacro(abstractPage, macroName, parameter, null);
    }

    public static MacroDefinition firstMacro(AbstractPage abstractPage, String macroName, String parameter, String value) throws XhtmlException {
        List<MacroDefinition> macros = MacroParser.extractMacros(abstractPage, macroName, parameter, value);
        return macros.isEmpty() ? null : macros.get(0);
    }

    public static MacroDefinition firstMacroFromStorageFormat(AbstractPage abstractPage, String storageFormat, String macroName) throws XhtmlException {
        return MacroParser.firstMacroFromStorageFormat(abstractPage, storageFormat, macroName, null);
    }

    public static MacroDefinition firstMacroFromStorageFormat(AbstractPage abstractPage, String storageFormat, String macroName, String parameter) throws XhtmlException {
        return MacroParser.firstMacroFromStorageFormat(abstractPage, storageFormat, macroName, parameter, null);
    }

    public static MacroDefinition firstMacroFromStorageFormat(AbstractPage abstractPage, String storageFormat, String macroName, String parameter, String value) throws XhtmlException {
        List<MacroDefinition> macros = MacroParser.extractMacrosFromStorageFormat(abstractPage, storageFormat, macroName, parameter, value);
        return macros.isEmpty() ? null : macros.get(0);
    }

    public static boolean getBooleanParameter(MacroDefinition macro, String parameter) {
        return MacroParser.booleanFromParameter(MacroParser.getStringParameter(macro, parameter));
    }

    public static String getDefaultStringParameter(MacroDefinition macro) {
        return macro.getDefaultParameterValue();
    }

    public static int getIntegerParameter(MacroDefinition macro, String parameter) {
        return BrikitNumber.parseInteger(MacroParser.getStringParameter(macro, parameter));
    }

    public static Map<String, String> getParameters(MacroDefinition macro) {
        return macro == null ? new HashMap() : macro.getParameters();
    }

    public static String getStringParameter(MacroDefinition macro, String parameter) {
        if (MacroParser.useTypedParameters()) {
            return BrikitString.isSet(macro.getParameter(parameter)) ? macro.getParameter(parameter) : (String)macro.getTypedParameter(parameter, String.class);
        }
        return (String)macro.getParameters().get(parameter);
    }

    public static boolean hasBooleanParameter(MacroDefinition macro, String parameterName, boolean aBoolean) {
        return MacroParser.hasParameter(macro, parameterName, MacroParser.parameterFromBoolean(aBoolean));
    }

    public static boolean hasId(MacroDefinition macro, String macroId) {
        return BrikitString.isSet(macroId) && macroId.equalsIgnoreCase(MacroParser.macroId(macro));
    }

    public static boolean hasMacro(AbstractPage abstractPage) {
        return MacroParser.hasMacro(abstractPage, null);
    }

    public static boolean hasMacro(AbstractPage abstractPage, String macroName) {
        return MacroParser.hasMacro(abstractPage, macroName, null);
    }

    public static boolean hasMacro(AbstractPage abstractPage, String macroName, String parameter) {
        return MacroParser.hasMacro(abstractPage, macroName, parameter, null);
    }

    public static boolean hasMacro(AbstractPage abstractPage, String macroName, String parameter, String value) {
        try {
            return MacroParser.firstMacro(abstractPage, macroName, parameter, value) != null;
        }
        catch (XhtmlException e) {
            return false;
        }
    }

    public static boolean hasMacroInStorageFormat(AbstractPage abstractPage, String storageFormat, String macroName) {
        return MacroParser.hasMacroInStorageFormat(abstractPage, storageFormat, macroName, null);
    }

    public static boolean hasMacroInStorageFormat(AbstractPage abstractPage, String storageFormat, String macroName, String parameter) {
        return MacroParser.hasMacroInStorageFormat(abstractPage, storageFormat, macroName, parameter, null);
    }

    public static boolean hasMacroInStorageFormat(AbstractPage abstractPage, String storageFormat, String macroName, String parameter, String value) {
        try {
            return MacroParser.firstMacroFromStorageFormat(abstractPage, storageFormat, macroName, parameter, value) != null;
        }
        catch (XhtmlException e) {
            return false;
        }
    }

    public static boolean hasParameter(MacroDefinition macro, String parameter) {
        if (MacroParser.useTypedParameters()) {
            return macro.getParameters().containsKey(parameter) || macro.getTypedParameters().containsKey(parameter);
        }
        return macro.getParameters().containsKey(parameter);
    }

    public static boolean hasParameter(MacroDefinition macro, String parameter, String value) {
        if (parameter == null) {
            return true;
        }
        if (!MacroParser.hasParameter(macro, parameter)) {
            return false;
        }
        return value == null || value.equals(macro.getParameters().get(parameter)) || MacroParser.useTypedParameters() && value.equals(macro.getTypedParameters().get(parameter));
    }

    public static void insertMacro(AbstractPage abstractPage, MacroDefinition newMacro, MacroDefinition oldMacro, boolean before) throws Exception {
        String newBodyAsString = MacroParser.insertMacroIntoStorageFormat(abstractPage, Confluence.getBodyAsString((ContentEntityObject)abstractPage), newMacro, oldMacro, before);
        Confluence.savePage(abstractPage, newBodyAsString, null, false);
    }

    public static String insertMacroIntoStorageFormat(final AbstractPage abstractPage, String storageFormat, MacroDefinition newMacro, final MacroDefinition oldMacro, boolean before) throws Exception {
        ConversionContext context = Confluence.getConversionContext(abstractPage);
        String newMacroAsString = MacroParser.macroAsStorageFormat(abstractPage, newMacro);
        String oldMacroAsString = MacroParser.macroAsStorageFormat(abstractPage, oldMacro);
        final String replacementString = before ? newMacroAsString + oldMacroAsString : oldMacroAsString + newMacroAsString;
        return Confluence.getXhtmlContent().replaceMacroDefinitionsWithString(storageFormat, context, new MacroDefinitionReplacer(){

            public String replace(MacroDefinition macro) throws XhtmlException {
                return MacroParser.equals(macro, oldMacro) ? replacementString : MacroParser.macroAsStorageFormat(abstractPage, macro);
            }
        });
    }

    public static String jiggleMacrosInStorageFormat(AbstractPage abstractPage) throws Exception {
        return MacroParser.jiggleMacrosInStorageFormat(abstractPage, Confluence.getBodyAsString((ContentEntityObject)abstractPage));
    }

    public static String jiggleMacrosInStorageFormat(final AbstractPage abstractPage, String storageFormat) throws Exception {
        ConversionContext context = Confluence.getConversionContext(abstractPage);
        return Confluence.getXhtmlContent().replaceMacroDefinitionsWithString(storageFormat, context, new MacroDefinitionReplacer(){

            public String replace(MacroDefinition macro) throws XhtmlException {
                return MacroParser.macroAsStorageFormat(abstractPage, macro);
            }
        });
    }

    public static MacroDefinition lastMacro(AbstractPage abstractPage) {
        return MacroParser.lastMacro(abstractPage, null);
    }

    public static MacroDefinition lastMacro(AbstractPage abstractPage, String macroName) {
        return MacroParser.lastMacro(abstractPage, macroName, null);
    }

    public static MacroDefinition lastMacro(AbstractPage abstractPage, String macroName, String parameter) {
        return MacroParser.lastMacro(abstractPage, macroName, parameter, null);
    }

    public static MacroDefinition lastMacro(AbstractPage abstractPage, String macroName, String parameter, String value) {
        try {
            List<MacroDefinition> macros = MacroParser.extractMacros(abstractPage, macroName, parameter, value);
            return macros.isEmpty() ? null : macros.get(macros.size() - 1);
        }
        catch (XhtmlException ex) {
            BrikitLog.logError("Unable to parse XHTML storage format for page: " + abstractPage, (Exception)((Object)ex));
            return null;
        }
    }

    public static String macroAsStorageFormat(AbstractPage abstractPage, MacroDefinition macro) throws XhtmlException {
        return Confluence.macroAsStorage(abstractPage, macro);
    }

    public static String macrosAsStorageFormat(AbstractPage abstractPage, List<MacroDefinition> macros) throws XhtmlException {
        StringBuilder builder = new StringBuilder();
        for (MacroDefinition macro : macros) {
            builder.append(MacroParser.macroAsStorageFormat(abstractPage, macro));
        }
        return builder.toString();
    }

    public static String macroId(MacroDefinition macro) {
        MacroId macroId = (MacroId)macro.getMacroId().getOrNull();
        return macroId == null ? null : macroId.getId();
    }

    public static String parameterFromBoolean(boolean aBoolean) {
        return aBoolean ? TRUE_PARAM_VALUE : FALSE_PARAM_VALUE;
    }

    public static String parameterFromBoolean(boolean aBoolean, boolean nullIfFalse) {
        if (aBoolean) {
            return TRUE_PARAM_VALUE;
        }
        return nullIfFalse ? null : FALSE_PARAM_VALUE;
    }

    public static void removeMacro(AbstractPage abstractPage, MacroDefinition removeMacro) throws Exception {
        String newBodyAsString = MacroParser.removeMacroFromStorageFormat(abstractPage, Confluence.getBodyAsString((ContentEntityObject)abstractPage), removeMacro);
        Confluence.savePage(abstractPage, newBodyAsString, null, false);
    }

    public static String removeMacroFromStorageFormat(final AbstractPage abstractPage, String storageFormat, final MacroDefinition removeMacro) throws Exception {
        ConversionContext context = Confluence.getConversionContext(abstractPage);
        return Confluence.getXhtmlContent().replaceMacroDefinitionsWithString(storageFormat, context, new MacroDefinitionReplacer(){

            public String replace(MacroDefinition macro) throws XhtmlException {
                return MacroParser.equals(macro, removeMacro) ? "" : MacroParser.macroAsStorageFormat(abstractPage, macro);
            }
        });
    }

    public static void removeParameter(MacroDefinition macro, String key, AbstractPage abstractPage) throws Exception {
        MacroParser.setParameter(macro, key, null, abstractPage);
    }

    public static void replaceMacro(AbstractPage abstractPage, final String macroId, final MacroDefinition newMacro, String versionComment, boolean notifyWatchers) throws Exception {
        String bodyAsString = Confluence.getXhtmlContent().updateMacroDefinitions(Confluence.getBodyAsString((ContentEntityObject)abstractPage), Confluence.getConversionContext(abstractPage), new MacroDefinitionUpdater(){

            public MacroDefinition update(MacroDefinition macro) {
                if (MacroParser.hasId(macro, macroId)) {
                    MacroParser.copy(newMacro, macro);
                }
                return macro;
            }
        });
        Confluence.savePage(abstractPage, bodyAsString, versionComment, notifyWatchers);
    }

    public static void replaceMacro(AbstractPage abstractPage, final MacroDefinition oldMacro, final MacroDefinition newMacro, String versionComment, boolean notifyWatchers) throws Exception {
        String bodyAsString = Confluence.getXhtmlContent().updateMacroDefinitions(Confluence.getBodyAsString((ContentEntityObject)abstractPage), Confluence.getConversionContext(abstractPage), new MacroDefinitionUpdater(){

            public MacroDefinition update(MacroDefinition macro) {
                if (MacroParser.equals(macro, oldMacro)) {
                    MacroParser.copy(newMacro, macro);
                }
                return macro;
            }
        });
        Confluence.savePage(abstractPage, bodyAsString, versionComment, notifyWatchers);
    }

    public static void replaceMacro(AbstractPage abstractPage, MacroDefinition oldMacro, String replacementString, String versionComment, boolean notifyWatchers) throws Exception {
        String newBodyAsString = MacroParser.replaceMacroInStorageFormat(abstractPage, Confluence.getBodyAsString((ContentEntityObject)abstractPage), oldMacro, replacementString);
        Confluence.savePage(abstractPage, newBodyAsString, versionComment, notifyWatchers);
    }

    public static String replaceMacroBodyOnPage(final AbstractPage abstractPage, final MacroDefinition oldMacro, String replacementString) throws Exception {
        ConversionContext context = Confluence.getConversionContext(abstractPage);
        MacroDefinition newMacro = MacroParser.clone(oldMacro);
        MacroParser.setBody(newMacro, replacementString);
        final String replacementStorage = MacroParser.macroAsStorageFormat(abstractPage, newMacro);
        String bodyAsString = Confluence.getXhtmlContent().replaceMacroDefinitionsWithString(Confluence.getBodyAsString((ContentEntityObject)abstractPage), context, new MacroDefinitionReplacer(){

            public String replace(MacroDefinition macro) throws XhtmlException {
                return MacroParser.equals(macro, oldMacro) ? replacementStorage : MacroParser.macroAsStorageFormat(abstractPage, macro);
            }
        });
        return bodyAsString;
    }

    public static String replaceMacroInStorageFormat(AbstractPage abstractPage, MacroDefinition oldMacro, MacroDefinition newMacro) throws Exception {
        return MacroParser.replaceMacroInStorageFormat(abstractPage, Confluence.getBodyAsString((ContentEntityObject)abstractPage), oldMacro, newMacro);
    }

    public static String replaceMacroInStorageFormat(AbstractPage abstractPage, String storageFormat, MacroDefinition oldMacro, MacroDefinition newMacro) throws Exception {
        return MacroParser.replaceMacroInStorageFormat(abstractPage, storageFormat, oldMacro, Confluence.macroAsStorage(abstractPage, newMacro));
    }

    public static String replaceMacroInStorageFormat(final AbstractPage abstractPage, String storageFormat, final MacroDefinition oldMacro, final String replacementString) throws Exception {
        ConversionContext context = Confluence.getConversionContext(abstractPage);
        return Confluence.getXhtmlContent().replaceMacroDefinitionsWithString(storageFormat, context, new MacroDefinitionReplacer(){

            public String replace(MacroDefinition macro) throws XhtmlException {
                return MacroParser.equals(macro, oldMacro) ? replacementString : MacroParser.macroAsStorageFormat(abstractPage, macro);
            }
        });
    }

    public static String renameMacroInStorageFormat(final AbstractPage abstractPage, String storageFormat, final String oldMacroKey, final String newMacroKey) throws Exception {
        ConversionContext context = Confluence.getConversionContext(abstractPage);
        return Confluence.getXhtmlContent().replaceMacroDefinitionsWithString(storageFormat, context, new MacroDefinitionReplacer(){

            public String replace(MacroDefinition macro) throws XhtmlException {
                if (macro.getName().equals(oldMacroKey)) {
                    MacroParser.setName(macro, newMacroKey);
                }
                return MacroParser.macroAsStorageFormat(abstractPage, macro);
            }
        });
    }

    public static void setBody(MacroDefinition macro, String storageFormat) {
        macro.setBody((MacroBody)new RichTextMacroBody(storageFormat));
    }

    public static void setBodyPlainText(MacroDefinition macro, String plainText) {
        macro.setBody((MacroBody)new PlainTextMacroBody(plainText));
    }

    public static void setBooleanParameter(MacroDefinition macro, String key, boolean aBoolean, AbstractPage contextPage) throws Exception {
        MacroParser.setParameter(macro, key, MacroParser.parameterFromBoolean(aBoolean), contextPage);
    }

    public static void setDefaultStringParameter(MacroDefinition macro, String stringValue) {
        macro.setDefaultParameterValue(stringValue);
    }

    public static void setName(MacroDefinition macro, String name) {
        macro.setName(name);
    }

    public static void setParameter(MacroDefinition macro, String key, String value, AbstractPage contextPage) throws Exception {
        if (BrikitString.isSet(value)) {
            macro.getParameters().put(key, value);
        } else {
            macro.getParameters().remove(key);
        }
        if (MacroParser.useTypedParameters()) {
            if (Confluence.isConfluenceVersionAtLeast("5.7")) {
                Method setMethod = Confluence.getMacroParameterTypeParser().getClass().getDeclaredMethod("parseMacroParameter", String.class, String.class, String.class, Map.class, ConversionContext.class);
                if (setMethod != null) {
                    Object typed = !BrikitString.isSet(value) ? null : setMethod.invoke((Object)Confluence.getMacroParameterTypeParser(), macro.getName(), key, value, null, Confluence.getConversionContext(contextPage));
                    macro.setTypedParameter(key, typed);
                }
            } else {
                Method setMethod = Confluence.getMacroParameterTypeParser().getClass().getDeclaredMethod("parseMacroParameter", String.class, String.class, String.class, ConversionContext.class);
                if (setMethod != null) {
                    Object typed = !BrikitString.isSet(value) ? null : setMethod.invoke((Object)Confluence.getMacroParameterTypeParser(), macro.getName(), key, value, Confluence.getConversionContext(contextPage));
                    macro.setTypedParameter(key, typed);
                }
            }
        }
    }

    public static void setParameters(MacroDefinition macro, Map parameters, AbstractPage contextPage) throws Exception {
        BrikitMap.removeBlanks(parameters);
        macro.setParameters(parameters);
        if (MacroParser.useTypedParameters()) {
            Map typed = Confluence.getMacroParameterTypeParser().parseMacroParameters(macro.getName(), parameters, Confluence.getConversionContext(contextPage));
            macro.setTypedParameters(typed);
        }
    }

    public static boolean useTypedParameters() {
        return Confluence.isConfluenceVersionAtLeast("5.3");
    }
}

