/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.model;

import com.atlassian.confluence.core.AttachmentResource;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.plugins.createcontent.ContentBlueprintManager;
import com.atlassian.confluence.plugins.createcontent.actions.BlueprintManager;
import com.atlassian.confluence.plugins.createcontent.impl.ContentBlueprint;
import com.atlassian.confluence.spaces.Space;
import com.brikit.blueprintmaker.model.Access;
import com.brikit.blueprintmaker.model.BlueprintDefinitions;
import com.brikit.blueprintmaker.model.BlueprintField;
import com.brikit.blueprintmaker.model.BlueprintPage;
import com.brikit.blueprintmaker.model.ContentMaker;
import com.brikit.blueprintmaker.model.CopySpaceBlueprint;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.util.BrikitOrderedMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SpaceBlueprint {
    protected String name;
    protected String description;
    protected List<String> spaceCategories;
    protected String blueprintSpaceKey;
    protected String spaceKey;
    protected String spaceName;
    protected String spaceDescription;
    protected List<Access> accesses;
    protected List<BlueprintField> blueprintFieldsFromSpaceBlueprint;
    protected BrikitOrderedMap<String, BlueprintField> allBlueprintFields;

    public static Space createFromSpaceBlueprint(String blueprintName, String currentSpaceKey, String spaceName, String spaceKey, String spaceDescription, String valuesJson, Map<String, AttachmentResource> fileResources, BlueprintManager blueprintManager, ContentBlueprintManager contentBlueprintManager) throws Exception {
        SpaceBlueprint spaceBlueprint;
        SpaceBlueprint spaceBlueprint2 = spaceBlueprint = CopySpaceBlueprint.isCopySpace(blueprintName) ? new CopySpaceBlueprint(currentSpaceKey, spaceName, spaceKey, spaceDescription) : BlueprintDefinitions.getSpaceBlueprint(blueprintName);
        if (spaceBlueprint == null) {
            throw new Exception("Space blueprint " + blueprintName + " doesn't exist");
        }
        ContentMaker contentMaker = new ContentMaker(spaceBlueprint, spaceName, spaceKey, spaceDescription, valuesJson, fileResources);
        Space newSpace = contentMaker.createSpace();
        ArrayList pinnedBlueprints = new ArrayList();
        for (ContentBlueprint blueprint : pinnedBlueprints) {
            String indexPageTitle = blueprintManager.getIndexPageTitle(blueprint);
            Page indexPage = Confluence.getPage(contentMaker.getSpaceKey(), indexPageTitle);
            if (indexPage == null) continue;
            List<Page> blueprintPages = Confluence.getPermittedChildren(indexPage);
            String adjustedCaseTitle = indexPage.getTitle();
            Confluence.trashPage((AbstractPage)indexPage);
            Page newIndexPage = blueprintManager.createAndPinIndexPage(blueprint, newSpace);
            Confluence.setParent(blueprintPages, newIndexPage, true);
            Confluence.setPageTitle((AbstractPage)newIndexPage, adjustedCaseTitle);
        }
        return newSpace;
    }

    public SpaceBlueprint(String name, String description, List<String> spaceCategories, String blueprintSpaceKey, String spaceKey, String spaceName, String spaceDescription, List<BlueprintField> blueprintFieldsFromSpaceBlueprint, List<Access> accesses) {
        this.name = name;
        this.description = description;
        this.spaceCategories = spaceCategories;
        this.blueprintSpaceKey = blueprintSpaceKey;
        this.spaceKey = spaceKey;
        this.spaceName = spaceName;
        this.spaceDescription = spaceDescription;
        this.blueprintFieldsFromSpaceBlueprint = blueprintFieldsFromSpaceBlueprint;
        this.accesses = accesses;
    }

    public List<Access> getAccesses() {
        return this.accesses;
    }

    public BrikitOrderedMap<String, BlueprintField> getAllBlueprintFields() {
        if (this.allBlueprintFields == null) {
            this.allBlueprintFields = new BrikitOrderedMap();
            for (BlueprintField field : this.getBlueprintFieldsFromSpaceBlueprint()) {
                this.allBlueprintFields.put(field.getId(), field);
            }
            for (BlueprintField field : this.getBlueprintFieldsFromBlueprintSpacePages()) {
                this.allBlueprintFields.putIfAbsent(field.getId(), field);
            }
        }
        return this.allBlueprintFields;
    }

    protected List<BlueprintField> getBlueprintFieldsFromBlueprintSpacePages() {
        ArrayList<BlueprintField> fields = new ArrayList<BlueprintField>();
        for (Page page : Confluence.getAllPages(this.getBlueprintSpace())) {
            for (BlueprintField field : BlueprintPage.get((AbstractPage)page).getFields()) {
                if (fields.contains(field)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    public List<BlueprintField> getBlueprintFieldsFromSpaceBlueprint() {
        if (this.blueprintFieldsFromSpaceBlueprint == null) {
            this.blueprintFieldsFromSpaceBlueprint = new ArrayList<BlueprintField>();
        }
        return this.blueprintFieldsFromSpaceBlueprint;
    }

    public Space getBlueprintSpace() {
        return Confluence.getSpace(this.getBlueprintSpaceKey());
    }

    public String getBlueprintSpaceKey() {
        return this.blueprintSpaceKey;
    }

    public String getDescription() {
        return this.description;
    }

    public String getHomePageTitleBlueprint() {
        return Confluence.getSpaceHomePage(this.getBlueprintSpace()).getTitle();
    }

    public String getName() {
        return this.name;
    }

    public List<String> getSpaceCategories() {
        return this.spaceCategories;
    }

    public String getSpaceDescription() {
        return this.spaceDescription;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public String getSpaceName() {
        return this.spaceName;
    }
}

