/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.actions;

import com.brikit.blueprintmaker.actions.BlueprintMakerActionSupport;
import com.brikit.blueprintmaker.model.SpaceDefinitionSettings;
import com.brikit.core.confluence.Confluence;
import com.brikit.core.log.BrikitLog;
import com.brikit.core.util.BrikitString;
import java.io.File;
import java.util.Collections;
import org.apache.struts2.dispatcher.multipart.UploadedFile;

public class UploadSpaceDefinitionsAction
extends BlueprintMakerActionSupport {
    @Override
    public String execute() throws Exception {
        for (String parameterName : Collections.list(this.getMultiPartRequest().getFileParameterNames())) {
            UploadedFile[] files = this.getMultiPartRequest().getFiles(parameterName);
            for (int i = 0; i < files.length; ++i) {
                if (files[i] == null) continue;
                UploadedFile pluginFile = files[i];
                String filename = this.getMultiPartRequest().getFileNames(parameterName)[i];
                BrikitLog.log("Uploading: " + pluginFile.getAbsolutePath());
                try {
                    SpaceDefinitionSettings.uploadSettings(pluginFile.isFile() ? (File)pluginFile.getContent() : null);
                    this.setResult(filename);
                    continue;
                }
                catch (Exception ex) {
                    BrikitLog.logDebug("Unable to read settings in " + filename, ex);
                    this.addActionError(BrikitString.isSet(ex.getMessage()) ? ex.getMessage() : "Unable to read " + filename);
                    return "error";
                }
            }
        }
        return "success";
    }

    public void validate() {
        super.validate();
        if (!Confluence.isConfluenceAdministrator()) {
            this.addActionError(this.getText("com.brikit.blueprintmaker.insufficient.permissions"));
        }
    }
}

