/*
 * Decompiled with CFR 0.152.
 */
package com.brikit.blueprintmaker.model;

import com.brikit.blueprintmaker.model.BlueprintFieldType;
import com.brikit.blueprintmaker.model.BlueprintListField;
import com.brikit.core.util.BrikitList;
import com.brikit.core.util.BrikitString;

public class BlueprintField {
    protected String id;
    protected String name;
    protected String helpText;
    protected BlueprintFieldType type;
    protected String validation;
    protected String placeholder;
    protected boolean required;

    public static BlueprintField create(String id, String name, String type, String helpText, String placeholder, String validation, boolean required, BrikitList<String> values, boolean multiselect, boolean addLabels, String filterGroup) {
        BlueprintFieldType fieldType = BlueprintFieldType.get(type);
        boolean isListType = fieldType == BlueprintFieldType.LIST;
        BlueprintField field = isListType ? new BlueprintListField() : new BlueprintField();
        field.setId(id);
        field.setName(name);
        field.setType(type);
        field.setHelpText(helpText);
        field.setPlaceholder(placeholder);
        field.setValidation(validation);
        field.setRequired(required);
        if (isListType) {
            BlueprintListField listField = (BlueprintListField)field;
            listField.setValues(values);
            listField.setMultiselect(multiselect);
            listField.setAddLabels(addLabels);
            listField.setFilterGroup(filterGroup);
        }
        return field;
    }

    public static BlueprintField create(String name, String type, String helpText, String placeholder, String validation, boolean required) {
        return BlueprintField.create(BlueprintField.generateId(name), name, type, helpText, placeholder, validation, required, BrikitList.EMPTY_LIST, false, false, "");
    }

    protected static String generateId(String name) {
        return BrikitString.camelCase(name);
    }

    public String getHelpText() {
        return this.helpText;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getPlaceholder() {
        return this.placeholder;
    }

    public BlueprintFieldType getType() {
        return this.type;
    }

    public String getValidation() {
        return this.validation;
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setHelpText(String helpText) {
        this.helpText = helpText;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public void setType(BlueprintFieldType type) {
        this.type = type;
    }

    public void setType(String type) {
        this.type = BlueprintFieldType.get(type);
        if (!BrikitString.isSet(type)) {
            this.type = BlueprintFieldType.DEFAULT;
        }
    }

    public void setValidation(String validation) {
        this.validation = validation;
    }
}

